/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import rustic.common.crafting.EvaporatingBasinRecipe;
import rustic.common.crafting.IEvaporatingBasinRecipe;
import rustic.common.crafting.Recipes;
import rustic.compat.crafttweaker.CrTEvaporatingBasinRecipe;
import rustic.compat.crafttweaker.CraftTweakerHelper;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rustic.EvaporatingBasin")
public class EvaporatingBasin {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack input) {
        EvaporatingBasinRecipe r = new EvaporatingBasinRecipe(CraftTweakerHelper.toStack(output), CraftTweakerHelper.toFluidStack(input));
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack input, int time) {
        if (time < 20) {
            throw new IllegalArgumentException("Minimum evaporation time for evaporating basin is 20 ticks");
        }
        CraftTweakerAPI.apply((IAction)new Add(new CrTEvaporatingBasinRecipe(CraftTweakerMC.getItemStack((IItemStack)output), CraftTweakerMC.getLiquidStack((ILiquidStack)input), time)));
    }

    @ZenMethod
    public static void removeRecipe(@NotNull IItemStack output) {
        CraftTweakerAPI.apply((IAction)new RemoveItem(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removeRecipe(@NotNull ILiquidStack input) {
        CraftTweakerAPI.apply((IAction)new RemoveFluid(CraftTweakerMC.getLiquidStack((ILiquidStack)input)));
    }

    private static class RemoveFluid
    implements IAction {
        private final FluidStack input;

        public RemoveFluid(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            Recipes.removeEvaporatingRecipe(this.input);
        }

        public String describe() {
            return "Removing Evaporating Recipe for Fluid " + this.input.getLocalizedName();
        }
    }

    private static class RemoveItem
    implements IAction {
        private final ItemStack output;

        public RemoveItem(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            Recipes.removeEvaporatingRecipe(this.output);
        }

        public String describe() {
            return "Removing Evaporating Recipes for Item " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final IEvaporatingBasinRecipe recipe;

        public Add(IEvaporatingBasinRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            Recipes.evaporatingRecipesMap.put(this.recipe.getFluid(), this.recipe);
        }

        public String describe() {
            return "Adding Evaporating Recipe for Item " + this.recipe.getOutput().func_82833_r();
        }
    }
}

