/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class ClientUtils {
    public static void drawTexturedColoredRect(float x, float y, float width, float height, float minU, float minV, float maxU, float maxV, int color) {
        int blue = color & 0xFF;
        int green = color >> 8 & 0xFF;
        int red = color >> 16 & 0xFF;
        int alpha = color >> 24 & 0xFF;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexBuffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)minU, (double)maxV).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)maxU, (double)maxV).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)maxU, (double)minV).func_181669_b(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)minU, (double)minV).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public static IBakedModel getItemModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
    }

    public static TextureAtlasSprite getItemTexture(ItemStack stack) {
        EnumFacing[] faces;
        IBakedModel model = ClientUtils.getItemModel(stack);
        TextureAtlasSprite sprite = model.func_177554_e();
        if (!sprite.func_94215_i().equals("missingno")) {
            return sprite;
        }
        for (EnumFacing face : faces = new EnumFacing[]{null, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.UP, EnumFacing.DOWN}) {
            for (BakedQuad quad : model.func_188616_a(null, face, 0L)) {
                sprite = quad.func_187508_a();
                if (sprite.func_94215_i().equals("missingno")) continue;
                return sprite;
            }
        }
        return sprite;
    }

    public static int getItemColor(ItemStack stack) {
        return ClientUtils.getTextureColor(ClientUtils.getItemTexture(stack));
    }

    public static int getTextureColor(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return -65281;
        }
        int numPixels = 0;
        int[] data = sprite.func_147965_a(0)[0];
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b();
        int a = 255;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int c = data[y * width + x];
                if ((c >> 24 & 0xFF) <= 0) continue;
                r += c >> 16 & 0xFF;
                g += c >> 8 & 0xFF;
                b += c & 0xFF;
                ++numPixels;
            }
        }
        r = MathHelper.func_76125_a((int)Math.round((float)r / (float)numPixels), (int)0, (int)255);
        g = MathHelper.func_76125_a((int)Math.round((float)g / (float)numPixels), (int)0, (int)255);
        b = MathHelper.func_76125_a((int)Math.round((float)b / (float)numPixels), (int)0, (int)255);
        int color = a << 24 | r << 16 | g << 8 | b;
        return color;
    }
}

