/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fluids.Fluid;
import rustic.client.util.FluidClientUtil;
import rustic.common.tileentity.TileEntityLiquidBarrel;

public class LiquidBarrelRenderer
extends TileEntitySpecialRenderer<TileEntityLiquidBarrel> {
    int blue;
    int green;
    int red;
    int a;
    int lightx;
    int lighty;
    double minU;
    double minV;
    double maxU;
    double maxV;
    double diffU;
    double diffV;

    public void render(TileEntityLiquidBarrel te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TileEntityLiquidBarrel tank = te;
        int amount = tank.getAmount();
        int capacity = tank.getCapacity();
        Fluid fluid = tank.getFluid();
        if (fluid != null) {
            int c = fluid.getColor();
            this.blue = c & 0xFF;
            this.green = c >> 8 & 0xFF;
            this.red = c >> 16 & 0xFF;
            this.a = c >> 24 & 0xFF;
            TextureAtlasSprite sprite = FluidClientUtil.stillTextures.get(fluid);
            if (sprite == null) {
                return;
            }
            this.diffU = this.maxU - this.minU;
            this.diffV = this.maxV - this.minV;
            this.minU = (double)sprite.func_94209_e() + this.diffU * 0.1875;
            this.maxU = (double)sprite.func_94212_f() - this.diffU * 0.1875;
            this.minV = (double)sprite.func_94206_g() + this.diffV * 0.1875;
            this.maxV = (double)sprite.func_94210_h() - this.diffV * 0.1875;
            int i = this.func_178459_a().func_175626_b(te.func_174877_v(), fluid.getLuminosity());
            this.lightx = i >> 16 & 0xFFFF;
            this.lighty = i & 0xFFFF;
            GlStateManager.func_179123_a();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buffer = tess.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            buffer.func_181662_b(x + 0.1875, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.1875).func_187315_a(this.minU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.a).func_181675_d();
            buffer.func_181662_b(x + 0.8125, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.1875).func_187315_a(this.maxU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.a).func_181675_d();
            buffer.func_181662_b(x + 0.8125, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.8125).func_187315_a(this.maxU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.a).func_181675_d();
            buffer.func_181662_b(x + 0.1875, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.8125).func_187315_a(this.minU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.a).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179099_b();
        }
    }
}

