/*
 * Decompiled with CFR 0.152.
 */
package elucent.albedo.util;

import elucent.albedo.ConfigManager;
import elucent.albedo.EventManager;
import elucent.albedo.event.RenderChunkUniformsEvent;
import elucent.albedo.util.ShaderManager;
import elucent.albedo.util.ShaderUtil;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RenderUtil {
    public static boolean lightingEnabled = false;
    public static ShaderManager previousShader;
    public static boolean enabledLast;
    public static ItemCameraTransforms.TransformType itemTransformType;

    public static void renderChunkUniforms(RenderChunk c) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderChunkUniformsEvent(c));
    }

    public static void enableLightingUniforms() {
        if (!EventManager.isGui && ConfigManager.isLightingEnabled()) {
            if (enabledLast) {
                if (previousShader != null) {
                    previousShader.useShader();
                }
                enabledLast = false;
            }
            if (ShaderManager.isCurrentShader(ShaderUtil.entityLightProgram)) {
                ShaderUtil.entityLightProgram.setUniform("lightingEnabled", true);
            }
        }
    }

    public static void disableLightingUniforms() {
        if (!EventManager.isGui && ConfigManager.isLightingEnabled()) {
            if (ShaderManager.isCurrentShader(ShaderUtil.entityLightProgram)) {
                ShaderUtil.entityLightProgram.setUniform("lightingEnabled", false);
            }
            if (!enabledLast) {
                previousShader = ShaderManager.getCurrentShader();
                enabledLast = true;
                ShaderManager.stopShader();
            }
        }
    }

    public static void setTransform(ItemCameraTransforms.TransformType t) {
        itemTransformType = t;
    }

    static {
        enabledLast = false;
        itemTransformType = ItemCameraTransforms.TransformType.NONE;
    }
}

