/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem;

import CoroUtil.util.CoroUtilFile;
import CoroUtil.util.CoroUtilPhysics;
import CoroUtil.util.Vec3;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import weather2.ServerTickHandler;
import weather2.Weather;
import weather2.config.ConfigStorm;
import weather2.volcano.VolcanoObject;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.EnumWeatherObjectType;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.storm.WeatherObjectSandstorm;
import weather2.weathersystem.wind.WindManager;

public class WeatherManagerBase {
    public int dim;
    private List<WeatherObject> listStormObjects = new ArrayList<WeatherObject>();
    public HashMap<Long, WeatherObject> lookupStormObjectsByID = new HashMap();
    public HashMap<Integer, ArrayList<StormObject>> lookupStormObjectsByLayer = new HashMap();
    private List<VolcanoObject> listVolcanoes = new ArrayList<VolcanoObject>();
    public HashMap<Long, VolcanoObject> lookupVolcanoes = new HashMap();
    public WindManager windMan;
    public boolean isVanillaRainActiveOnServer = false;
    public boolean isVanillaThunderActiveOnServer = false;
    public int vanillaRainTimeOnServer = 0;
    public long lastStormFormed = 0L;
    public long lastSandstormFormed = 0L;
    public float cloudIntensity = 1.0f;
    private HashSet<Long> listWeatherBlockDamageDeflector = new HashSet();

    public WeatherManagerBase(int parDim) {
        this.dim = parDim;
        this.windMan = new WindManager(this);
        this.lookupStormObjectsByLayer.put(0, new ArrayList());
        this.lookupStormObjectsByLayer.put(1, new ArrayList());
        this.lookupStormObjectsByLayer.put(2, new ArrayList());
    }

    public void reset() {
        int i;
        for (i = 0; i < this.getStormObjects().size(); ++i) {
            WeatherObject so = this.getStormObjects().get(i);
            so.reset();
        }
        this.getStormObjects().clear();
        this.lookupStormObjectsByID.clear();
        try {
            for (i = 0; i < this.lookupStormObjectsByLayer.size(); ++i) {
                this.lookupStormObjectsByLayer.get(i).clear();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i2 = 0; i2 < this.getVolcanoObjects().size(); ++i2) {
            VolcanoObject vo = this.getVolcanoObjects().get(i2);
            vo.reset();
        }
        this.getVolcanoObjects().clear();
        this.lookupVolcanoes.clear();
        this.windMan.reset();
    }

    public World getWorld() {
        return null;
    }

    public void tick() {
        World world = this.getWorld();
        if (world != null) {
            int i;
            List<WeatherObject> list = this.getStormObjects();
            for (i = 0; i < list.size(); ++i) {
                WeatherObject so = list.get(i);
                if (this instanceof WeatherManagerServer && so.isDead) {
                    this.removeStormObject(so.ID);
                    ((WeatherManagerServer)this).syncStormRemove(so);
                    continue;
                }
                if (!so.isDead) {
                    so.tick();
                    continue;
                }
                if (!this.getWorld().field_72995_K) continue;
                Weather.dbg("WARNING!!! - detected isDead storm object still in client side list, had to remove storm object with ID " + so.ID + " from client side, wasnt properly removed via main channels");
                this.removeStormObject(so.ID);
            }
            for (i = 0; i < this.getVolcanoObjects().size(); ++i) {
                this.getVolcanoObjects().get(i).tick();
            }
            this.windMan.tick();
        }
    }

    public void tickRender(float partialTick) {
        World world = this.getWorld();
        if (world != null) {
            try {
                for (int i = 0; i < this.getStormObjects().size(); ++i) {
                    WeatherObject obj = this.getStormObjects().get(i);
                    if (obj == null) continue;
                    obj.tickRender(partialTick);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<WeatherObject> getStormObjects() {
        return this.listStormObjects;
    }

    public List<StormObject> getStormObjectsByLayer(int layer) {
        return this.lookupStormObjectsByLayer.get(layer);
    }

    public StormObject getStormObjectByID(long ID) {
        WeatherObject obj = this.lookupStormObjectsByID.get(ID);
        if (obj instanceof StormObject) {
            return (StormObject)obj;
        }
        return null;
    }

    public void addStormObject(WeatherObject so) {
        if (!this.lookupStormObjectsByID.containsKey(so.ID)) {
            this.listStormObjects.add(so);
            this.lookupStormObjectsByID.put(so.ID, so);
            if (so instanceof StormObject) {
                StormObject so2 = (StormObject)so;
                this.lookupStormObjectsByLayer.get(so2.layer).add(so2);
            }
        } else {
            Weather.dbg("Weather2 WARNING!!! Received new storm create for an ID that is already active! design bug or edgecase with PlayerEvent.Clone, ID: " + so.ID);
            Weather.dbgStackTrace();
        }
    }

    public void removeStormObject(long ID) {
        WeatherObject so = this.lookupStormObjectsByID.get(ID);
        if (so != null) {
            so.setDead();
            this.listStormObjects.remove(so);
            this.lookupStormObjectsByID.remove(ID);
            if (so instanceof StormObject) {
                StormObject so2 = (StormObject)so;
                this.lookupStormObjectsByLayer.get(so2.layer).remove(so2);
            }
        } else {
            Weather.dbg("error looking up storm ID on server for removal: " + ID + " - lookup count: " + this.lookupStormObjectsByID.size() + " - last used ID: " + WeatherObject.lastUsedStormID);
        }
    }

    public List<VolcanoObject> getVolcanoObjects() {
        return this.listVolcanoes;
    }

    public void addVolcanoObject(VolcanoObject so) {
        if (!this.lookupVolcanoes.containsKey(so.ID)) {
            this.listVolcanoes.add(so);
            this.lookupVolcanoes.put(so.ID, so);
        } else {
            Weather.dbg("Weather2 WARNING!!! Client received new volcano create for an ID that is already active! design bug");
        }
    }

    public void removeVolcanoObject(long ID) {
        VolcanoObject vo = this.lookupVolcanoes.get(ID);
        if (vo != null) {
            vo.setDead();
            this.listVolcanoes.remove(vo);
            this.lookupVolcanoes.remove(ID);
            Weather.dbg("removing volcano");
        }
    }

    public StormObject getClosestStormAny(Vec3 parPos, double maxDist) {
        return this.getClosestStorm(parPos, maxDist, -1, true);
    }

    public StormObject getClosestStorm(Vec3 parPos, double maxDist, int severityFlagMin) {
        return this.getClosestStorm(parPos, maxDist, severityFlagMin, false);
    }

    public StormObject getClosestStorm(Vec3 parPos, double maxDist, int severityFlagMin, boolean orRain) {
        StormObject closestStorm = null;
        double closestDist = 9999999.0;
        List<WeatherObject> listStorms = this.getStormObjects();
        for (int i = 0; i < listStorms.size(); ++i) {
            double dist;
            StormObject storm;
            WeatherObject wo = listStorms.get(i);
            if (!(wo instanceof StormObject) || (storm = (StormObject)wo) == null || storm.isDead || !((dist = storm.pos.distanceTo(parPos)) < closestDist) || !(dist <= maxDist) || (!storm.attrib_precipitation || !orRain) && severityFlagMin != -1 && storm.levelCurIntensityStage < severityFlagMin) continue;
            closestStorm = storm;
            closestDist = dist;
        }
        return closestStorm;
    }

    public boolean isPrecipitatingAt(BlockPos pos) {
        return this.isPrecipitatingAt(new Vec3(pos));
    }

    public boolean isPrecipitatingAt(Vec3 parPos) {
        List<WeatherObject> listStorms = this.getStormObjects();
        for (int i = 0; i < listStorms.size(); ++i) {
            double dist;
            StormObject storm;
            WeatherObject wo = listStorms.get(i);
            if (!(wo instanceof StormObject) || (storm = (StormObject)wo) == null || storm.isDead || !storm.attrib_precipitation || !((dist = storm.pos.distanceTo(parPos)) < (double)storm.size)) continue;
            return true;
        }
        return false;
    }

    public WeatherObjectSandstorm getClosestSandstorm(Vec3 parPos, double maxDist) {
        WeatherObjectSandstorm closestStorm = null;
        double closestDist = 9999999.0;
        List<WeatherObject> listStorms = this.getStormObjects();
        for (int i = 0; i < listStorms.size(); ++i) {
            double dist;
            WeatherObjectSandstorm storm;
            WeatherObject wo = listStorms.get(i);
            if (!(wo instanceof WeatherObjectSandstorm) || (storm = (WeatherObjectSandstorm)wo) == null || storm.isDead || !((dist = storm.pos.distanceTo(parPos)) < closestDist) || !(dist <= maxDist)) continue;
            closestStorm = storm;
            closestDist = dist;
        }
        return closestStorm;
    }

    public WeatherObjectSandstorm getClosestSandstormByIntensity(Vec3 parPos) {
        WeatherObjectSandstorm bestStorm = null;
        double closestDist = 9999999.0;
        double mostIntense = 0.0;
        List<WeatherObject> listStorms = this.getStormObjects();
        for (int i = 0; i < listStorms.size(); ++i) {
            WeatherObjectSandstorm sandstorm;
            WeatherObject wo = listStorms.get(i);
            if (!(wo instanceof WeatherObjectSandstorm) || (sandstorm = (WeatherObjectSandstorm)wo) == null || sandstorm.isDead) continue;
            List<Vec3> points = sandstorm.getSandstormAsShape();
            double scale = sandstorm.getSandstormScale();
            boolean inStorm = CoroUtilPhysics.isInConvexShape((Vec3)parPos, points);
            double dist = CoroUtilPhysics.getDistanceToShape((Vec3)parPos, points);
            if (inStorm) {
                closestDist = 0.0;
                if (!(scale > mostIntense)) continue;
                mostIntense = scale;
                bestStorm = sandstorm;
                continue;
            }
            if (!(closestDist > 0.0) || !(dist < closestDist)) continue;
            closestDist = dist;
            bestStorm = sandstorm;
        }
        return bestStorm;
    }

    public List<WeatherObject> getSandstormsAround(Vec3 parPos, double maxDist) {
        ArrayList<WeatherObject> storms = new ArrayList<WeatherObject>();
        for (int i = 0; i < this.getStormObjects().size(); ++i) {
            WeatherObject wo = this.getStormObjects().get(i);
            if (!(wo instanceof WeatherObjectSandstorm)) continue;
            WeatherObjectSandstorm storm = (WeatherObjectSandstorm)wo;
            if (storm.isDead || !(storm.pos.distanceTo(parPos) < maxDist)) continue;
            storms.add(storm);
        }
        return storms;
    }

    public List<WeatherObject> getStormsAroundForDeflector(Vec3 parPos, double maxDist) {
        ArrayList<WeatherObject> storms = new ArrayList<WeatherObject>();
        for (int i = 0; i < this.getStormObjects().size(); ++i) {
            WeatherObjectSandstorm sandstorm;
            List<Vec3> points;
            double distToStorm;
            WeatherObject wo = this.getStormObjects().get(i);
            if (wo.isDead) continue;
            if (wo instanceof StormObject) {
                StormObject storm = (StormObject)wo;
                if (!(storm.pos.distanceTo(parPos) < maxDist) || (!storm.attrib_precipitation || !ConfigStorm.Storm_Deflector_RemoveRainstorms) && storm.levelCurIntensityStage < ConfigStorm.Storm_Deflector_MinStageRemove) continue;
                storms.add(storm);
                continue;
            }
            if (!(wo instanceof WeatherObjectSandstorm) || !ConfigStorm.Storm_Deflector_RemoveSandstorms || !((distToStorm = CoroUtilPhysics.getDistanceToShape((Vec3)parPos, points = (sandstorm = (WeatherObjectSandstorm)wo).getSandstormAsShape())) < maxDist)) continue;
            storms.add(wo);
        }
        return storms;
    }

    public List<WeatherObject> getStormsAround(Vec3 parPos, double maxDist) {
        ArrayList<WeatherObject> storms = new ArrayList<WeatherObject>();
        for (int i = 0; i < this.getStormObjects().size(); ++i) {
            WeatherObjectSandstorm sandstorm;
            List<Vec3> points;
            double distToStorm;
            WeatherObject wo = this.getStormObjects().get(i);
            if (wo.isDead) continue;
            if (wo instanceof StormObject) {
                StormObject storm = (StormObject)wo;
                if (!(storm.pos.distanceTo(parPos) < maxDist) || !storm.attrib_precipitation && storm.levelCurIntensityStage <= StormObject.STATE_NORMAL) continue;
                storms.add(storm);
                continue;
            }
            if (!(wo instanceof WeatherObjectSandstorm) || !((distToStorm = CoroUtilPhysics.getDistanceToShape((Vec3)parPos, points = (sandstorm = (WeatherObjectSandstorm)wo).getSandstormAsShape())) < maxDist)) continue;
            storms.add(wo);
        }
        return storms;
    }

    public void writeToFile() {
        NBTTagCompound mainNBT = new NBTTagCompound();
        NBTTagCompound listVolcanoesNBT = new NBTTagCompound();
        for (int i = 0; i < this.listVolcanoes.size(); ++i) {
            VolcanoObject td = this.listVolcanoes.get(i);
            NBTTagCompound teamNBT = new NBTTagCompound();
            td.writeToNBT(teamNBT);
            listVolcanoesNBT.func_74782_a("volcano_" + td.ID, (NBTBase)teamNBT);
        }
        mainNBT.func_74782_a("volcanoData", (NBTBase)listVolcanoesNBT);
        mainNBT.func_74772_a("lastUsedIDVolcano", VolcanoObject.lastUsedID);
        NBTTagCompound listStormsNBT = new NBTTagCompound();
        for (int i = 0; i < this.listStormObjects.size(); ++i) {
            WeatherObject obj = this.listStormObjects.get(i);
            obj.getNbtCache().setUpdateForced(true);
            obj.writeToNBT();
            obj.getNbtCache().setUpdateForced(false);
            listStormsNBT.func_74782_a("storm_" + obj.ID, (NBTBase)obj.getNbtCache().getNewNBT());
        }
        mainNBT.func_74782_a("stormData", (NBTBase)listStormsNBT);
        mainNBT.func_74772_a("lastUsedIDStorm", WeatherObject.lastUsedStormID);
        mainNBT.func_74772_a("lastStormFormed", this.lastStormFormed);
        mainNBT.func_74772_a("lastSandstormFormed", this.lastSandstormFormed);
        mainNBT.func_74776_a("cloudIntensity", this.cloudIntensity);
        mainNBT.func_74782_a("windMan", (NBTBase)this.windMan.writeToNBT(new NBTTagCompound()));
        String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "weather2" + File.separator;
        try {
            if (!new File(saveFolder).exists()) {
                new File(saveFolder).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(saveFolder + "WeatherData_" + this.dim + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)mainNBT, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readFromFile() {
        NBTTagCompound rtsNBT = new NBTTagCompound();
        String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "weather2" + File.separator;
        boolean readFail = false;
        try {
            if (new File(saveFolder + "WeatherData_" + this.dim + ".dat").exists()) {
                rtsNBT = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(saveFolder + "WeatherData_" + this.dim + ".dat"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            readFail = true;
        }
        if (!readFail) {
            try {
                File tmp = new File(saveFolder + "WeatherData_" + this.dim + "_BACKUP0.dat");
                if (tmp.exists()) {
                    FileUtils.copyFile((File)tmp, (File)new File(saveFolder + "WeatherData_" + this.dim + "_BACKUP1.dat"));
                }
                if (new File(saveFolder + "WeatherData_" + this.dim + ".dat").exists()) {
                    FileUtils.copyFile((File)new File(saveFolder + "WeatherData_" + this.dim + ".dat"), (File)new File(saveFolder + "WeatherData_" + this.dim + "_BACKUP0.dat"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            System.out.println("WARNING! Weather2 File: WeatherData.dat failed to load, automatically restoring to backup from previous game run");
            try {
                if (new File(saveFolder + "WeatherData_" + this.dim + "_BACKUP0.dat").exists()) {
                    rtsNBT = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(saveFolder + "WeatherData_" + this.dim + "_BACKUP0.dat"));
                } else {
                    System.out.println("WARNING! Failed to find backup file WeatherData_BACKUP0.dat, nothing loaded");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("WARNING! Error loading backup file WeatherData_BACKUP0.dat, nothing loaded");
            }
        }
        this.lastStormFormed = rtsNBT.func_74763_f("lastStormFormed");
        this.lastSandstormFormed = rtsNBT.func_74763_f("lastSandstormFormed");
        if (rtsNBT.func_74764_b("cloudIntensity")) {
            this.cloudIntensity = rtsNBT.func_74760_g("cloudIntensity");
        }
        VolcanoObject.lastUsedID = rtsNBT.func_74763_f("lastUsedIDVolcano");
        WeatherObject.lastUsedStormID = rtsNBT.func_74763_f("lastUsedIDStorm");
        this.windMan.readFromNBT(rtsNBT.func_74775_l("windMan"));
        NBTTagCompound nbtVolcanoes = rtsNBT.func_74775_l("volcanoData");
        for (String tagName : nbtVolcanoes.func_150296_c()) {
            NBTTagCompound teamData = nbtVolcanoes.func_74775_l(tagName);
            VolcanoObject to = new VolcanoObject(ServerTickHandler.lookupDimToWeatherMan.get(0));
            try {
                to.readFromNBT(teamData);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.addVolcanoObject(to);
            ((WeatherManagerServer)this).syncVolcanoNew(to);
            to.initPost();
        }
        NBTTagCompound nbtStorms = rtsNBT.func_74775_l("stormData");
        for (String tagName : nbtStorms.func_150296_c()) {
            NBTTagCompound data = nbtStorms.func_74775_l(tagName);
            if (ServerTickHandler.lookupDimToWeatherMan.get(this.dim) != null) {
                WeatherObject wo = null;
                if (data.func_74762_e("weatherObjectType") == EnumWeatherObjectType.CLOUD.ordinal()) {
                    wo = new StormObject(this);
                } else if (data.func_74762_e("weatherObjectType") == EnumWeatherObjectType.SAND.ordinal()) {
                    wo = new WeatherObjectSandstorm(this);
                }
                try {
                    wo.getNbtCache().setNewNBT(data);
                    wo.readFromNBT();
                    wo.getNbtCache().updateCacheFromNew();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.addStormObject(wo);
                ((WeatherManagerServer)this).syncStormNew(wo);
                continue;
            }
            System.out.println("WARNING: trying to load storm objects for missing dimension: " + this.dim);
        }
    }

    public WindManager getWindManager() {
        return this.windMan;
    }

    public HashSet<Long> getListWeatherBlockDamageDeflector() {
        return this.listWeatherBlockDamageDeflector;
    }

    public void setListWeatherBlockDamageDeflector(HashSet<Long> listWeatherBlockDamageDeflector) {
        this.listWeatherBlockDamageDeflector = listWeatherBlockDamageDeflector;
    }
}

