/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import CoroUtil.util.Vec3;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import weather2.CommonProxy;
import weather2.block.BlockSandLayer;

public class WeatherUtilBlock {
    public static int layerableHeightPropMax = 8;

    public static void fillAgainstWallSmoothly(World world, Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable) {
        WeatherUtilBlock.fillAgainstWallSmoothly(world, posSource, directionYaw, scanDistance, fillRadius, blockLayerable, 4);
    }

    public static void fillAgainstWallSmoothly(World world, Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable, int heightDiff) {
        int heightTest;
        IBlockState stateTest = world.func_180495_p(posSource.toBlockPos());
        if (stateTest.func_177230_c() != blockLayerable || (heightTest = WeatherUtilBlock.getHeightForAnyBlock(stateTest)) < 8) {
            // empty if block
        }
        BlockPos posSourcei = posSource.toBlockPos();
        int y = posSourcei.func_177956_o();
        float tickStep = 0.75f;
        Vec3 posLastNonWall = new Vec3(posSource);
        Vec3 posWall = null;
        BlockPos lastScannedPosXZ = null;
        int previousBlockHeight = 0;
        for (float i = 0.0f; i < scanDistance; i += tickStep) {
            double vecX = -Math.sin(Math.toRadians(directionYaw)) * (double)i;
            double vecZ = Math.cos(Math.toRadians(directionYaw)) * (double)i;
            int x = MathHelper.func_76128_c((double)(posSource.xCoord + vecX));
            int z = MathHelper.func_76128_c((double)(posSource.zCoord + vecZ));
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos posXZ = new BlockPos(x, 0, z);
            IBlockState state = world.func_180495_p(pos);
            if (lastScannedPosXZ != null && posXZ.equals(lastScannedPosXZ)) continue;
            lastScannedPosXZ = new BlockPos((Vec3i)posXZ);
            AxisAlignedBB aabbCompare = new AxisAlignedBB(pos);
            ArrayList listAABBCollision = new ArrayList();
            state.func_185908_a(world, pos, aabbCompare, listAABBCollision, null, false);
            if (state.func_185904_a() != Material.field_151579_a && state.func_185904_a() != Material.field_151585_k && !state.func_177230_c().func_176200_f((IBlockAccess)world, pos) && !listAABBCollision.isEmpty()) {
                BlockPos posUp = new BlockPos(x, y + 1, z);
                IBlockState stateUp = world.func_180495_p(posUp);
                if (stateUp.func_185904_a() == Material.field_151579_a) {
                    int height = WeatherUtilBlock.getHeightForAnyBlock(state);
                    if (height - previousBlockHeight <= heightDiff) {
                        if (height == 8) {
                            previousBlockHeight = 0;
                            ++y;
                        } else {
                            previousBlockHeight = height;
                        }
                        posLastNonWall = new Vec3(posSource.xCoord + vecX, (double)y, posSource.zCoord + vecZ);
                        continue;
                    }
                    posWall = new Vec3(posSource.xCoord + vecX, (double)y, posSource.zCoord + vecZ);
                    break;
                }
                posWall = new Vec3(posSource.xCoord + vecX, (double)y, posSource.zCoord + vecZ);
                break;
            }
            posLastNonWall = new Vec3(posSource.xCoord + vecX, (double)y, posSource.zCoord + vecZ);
        }
        if (posWall != null) {
            int amountWeHave = 1;
            int amountToAddPerXZ = 1;
            IBlockState state = world.func_180495_p(posWall.toBlockPos());
            IBlockState state1 = world.func_180495_p(posLastNonWall.toBlockPos().func_177982_a(1, 0, 0));
            IBlockState state22 = world.func_180495_p(posLastNonWall.toBlockPos().func_177982_a(-1, 0, 0));
            IBlockState state3 = world.func_180495_p(posLastNonWall.toBlockPos().func_177982_a(0, 0, 1));
            IBlockState state4 = world.func_180495_p(posLastNonWall.toBlockPos().func_177982_a(0, 0, -1));
            if (state.func_177230_c() == Blocks.field_150434_aF || state1.func_177230_c() == Blocks.field_150434_aF || state22.func_177230_c() == Blocks.field_150434_aF || state3.func_177230_c() == Blocks.field_150434_aF || state4.func_177230_c() == Blocks.field_150434_aF) {
                return;
            }
            BlockPos pos2 = new BlockPos(posLastNonWall.xCoord, posLastNonWall.yCoord, posLastNonWall.zCoord);
            IBlockState state2 = world.func_180495_p(pos2);
            if (state2.func_185904_a() == Material.field_151586_h || state2.func_185904_a() == Material.field_151587_i) {
                return;
            }
            amountWeHave = WeatherUtilBlock.trySpreadOnPos2(world, new BlockPos(posLastNonWall.xCoord, posLastNonWall.yCoord, posLastNonWall.zCoord), amountWeHave, amountToAddPerXZ, 10, blockLayerable);
        }
    }

    public static void fillAgainstWall(World world, Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable) {
        int ySource;
        float thickness = 1.0f;
        float tickStep = 0.75f;
        BlockPos posSourcei = posSource.toBlockPos();
        int y = ySource = WeatherUtilBlock.getPrecipitationHeightSafe(world, posSourcei).func_177956_o();
        y = (int)posSource.yCoord;
        float startScan = scanDistance;
        Vec3 posLastNonWall = new Vec3(posSource);
        Vec3 posWall = null;
        for (float i = 0.0f; i < scanDistance; i += tickStep) {
            int z;
            double vecX = -Math.sin(Math.toRadians(directionYaw)) * (double)i;
            double vecZ = Math.cos(Math.toRadians(directionYaw)) * (double)i;
            int x = MathHelper.func_76128_c((double)(posSource.xCoord + vecX));
            BlockPos pos = new BlockPos(x, y, z = MathHelper.func_76128_c((double)(posSource.zCoord + vecZ)));
            IBlockState state = world.func_180495_p(pos);
            if (state.func_185904_a() != Material.field_151579_a) {
                startScan = i;
                posWall = new Vec3(posSource.xCoord + vecX, (double)y, posSource.zCoord + vecZ);
                break;
            }
            posLastNonWall = new Vec3(posSource.xCoord + vecX, (double)y, posSource.zCoord + vecZ);
        }
        double distFromSourceToWall = posSource.distanceTo(posLastNonWall);
        if (posWall != null) {
            IBlockState stateCheck;
            BlockPos posCheck = new BlockPos((Vec3i)posWall.toBlockPos());
            int heightOfWall = 0;
            int heightNeeded = 2;
            while (heightOfWall++ < heightNeeded && (stateCheck = world.func_180495_p(posCheck = posCheck.func_177982_a(0, 1, 0))).isSideSolid((IBlockAccess)world, posCheck, EnumFacing.UP)) {
            }
            if (heightOfWall >= heightNeeded) {
                int amountWeHave = 4;
                int amountToAddPerXZ = 2;
                amountWeHave = WeatherUtilBlock.trySpreadOnPos2(world, new BlockPos(posLastNonWall.xCoord, posLastNonWall.yCoord, posLastNonWall.zCoord), amountWeHave, amountToAddPerXZ, 10, blockLayerable);
            }
        }
    }

    public static void floodAreaWithLayerableBlock(World world, Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable, int amountToTakeOrFill) {
        WeatherUtilBlock.floodAreaWithLayerableBlock(world, posSource, directionYaw, scanDistance, fillRadius, -1.0f, blockLayerable, amountToTakeOrFill);
    }

    public static void floodAreaWithLayerableBlock(World world, Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, float takeRadius, Block blockLayerable, int amountToTakeOrRelocate) {
        BlockPos pos;
        int z;
        int x;
        double vecZ;
        double vecX;
        float orientationMulti;
        int mode;
        float angle;
        int amountToAddBasedOnDist;
        float i;
        int ySource;
        float thickness = 1.0f;
        float tickStep = 0.75f;
        BlockPos posSourcei = posSource.toBlockPos();
        int y = ySource = WeatherUtilBlock.getPrecipitationHeightSafe(world, posSourcei).func_177956_o();
        y = (int)posSource.yCoord;
        float startScan = scanDistance;
        Vec3 posLastNonWall = new Vec3(posSource);
        Vec3 posWall = null;
        for (float i2 = 0.0f; i2 < scanDistance; i2 += tickStep) {
            int z2;
            double vecX2 = -Math.sin(Math.toRadians(directionYaw)) * (double)i2;
            double vecZ2 = Math.cos(Math.toRadians(directionYaw)) * (double)i2;
            int x2 = MathHelper.func_76128_c((double)(posSource.xCoord + vecX2));
            BlockPos pos2 = new BlockPos(x2, y, z2 = MathHelper.func_76128_c((double)(posSource.zCoord + vecZ2)));
            IBlockState state = world.func_180495_p(pos2);
            if (state.func_185904_a() != Material.field_151579_a) {
                startScan = i2;
                posWall = new Vec3(posSource.xCoord + vecX2, (double)y, posSource.zCoord + vecZ2);
                break;
            }
            posLastNonWall = new Vec3(posSource.xCoord + vecX2, (double)y, posSource.zCoord + vecZ2);
        }
        double distFromSourceToWall = posSource.distanceTo(posLastNonWall);
        boolean doRadius = true;
        if (takeRadius != -1.0f && distFromSourceToWall <= 2.0) {
            doRadius = false;
        }
        float angleScanResolution = 1.0f;
        float spreadDist = fillRadius;
        int maxFallDist = 20;
        int amountToTakePerXZ = 2;
        int amountToAddPerXZ = 2;
        int amountWeHave = 0;
        amountWeHave = takeRadius != -1.0f ? WeatherUtilBlock.tryTakeFromPos(world, posSourcei, amountWeHave, amountToTakePerXZ, maxFallDist, blockLayerable) : amountToTakeOrRelocate;
        ArrayList<BlockPos> listProcessedFilter = new ArrayList<BlockPos>();
        if (doRadius) {
            for (i = 1.0f; i < takeRadius; i += 0.75f) {
                amountToAddBasedOnDist = 2;
                for (angle = 0.0f; angle <= 180.0f; angle += angleScanResolution) {
                    for (mode = 0; mode <= 1; ++mode) {
                        orientationMulti = 1.0f;
                        if (mode == 1) {
                            orientationMulti = -1.0f;
                        }
                        vecX = -Math.sin(Math.toRadians(directionYaw - angle * orientationMulti)) * (double)i;
                        vecZ = Math.cos(Math.toRadians(directionYaw - angle * orientationMulti)) * (double)i;
                        x = MathHelper.func_76128_c((double)(posSource.xCoord + vecX));
                        z = MathHelper.func_76128_c((double)(posSource.zCoord + vecZ));
                        y = (int)posSource.yCoord;
                        pos = new BlockPos(x, y, z);
                        IBlockState state = world.func_180495_p(pos);
                        if (listProcessedFilter.contains(pos)) continue;
                        listProcessedFilter.add(pos);
                        amountWeHave = WeatherUtilBlock.tryTakeFromPos(world, pos, amountWeHave, amountToTakePerXZ, maxFallDist, blockLayerable);
                    }
                }
            }
        }
        listProcessedFilter.clear();
        amountWeHave = WeatherUtilBlock.trySpreadOnPos2(world, new BlockPos(posLastNonWall.xCoord, posLastNonWall.yCoord, posLastNonWall.zCoord), amountWeHave, amountToAddPerXZ, maxFallDist, blockLayerable);
        if (doRadius) {
            for (i = 1.0f; i < spreadDist && amountWeHave > 0; i += 0.75f) {
                amountToAddBasedOnDist = (int)((float)layerableHeightPropMax + 1.0f - i * 1.5f);
                if (amountToAddBasedOnDist < 1) {
                    amountToAddBasedOnDist = 1;
                }
                amountToAddBasedOnDist = 2;
                for (angle = 0.0f; angle <= 180.0f && amountWeHave > 0; angle += angleScanResolution) {
                    for (mode = 0; mode <= 1 && amountWeHave > 0; ++mode) {
                        Vec3d destTest;
                        orientationMulti = 1.0f;
                        if (mode == 1) {
                            orientationMulti = -1.0f;
                        }
                        vecX = -Math.sin(Math.toRadians(directionYaw - angle * orientationMulti)) * (double)i;
                        vecZ = Math.cos(Math.toRadians(directionYaw - angle * orientationMulti)) * (double)i;
                        x = MathHelper.func_76128_c((double)(posLastNonWall.xCoord + vecX));
                        z = MathHelper.func_76128_c((double)(posLastNonWall.zCoord + vecZ));
                        y = (int)posLastNonWall.yCoord;
                        pos = new BlockPos(x, y, z);
                        Vec3d sourceTest = posSource.addVector(0.0, 1.0, 0.0).toMCVec();
                        RayTraceResult destFound = world.func_72901_a(sourceTest, destTest = new Vec3d((double)((float)x + 0.5f), (double)((float)y + 1.5f), (double)((float)z + 0.5f)), false);
                        if (destFound != null) continue;
                        IBlockState state = world.func_180495_p(pos);
                        if (listProcessedFilter.contains(pos)) continue;
                        listProcessedFilter.add(pos);
                        amountWeHave = WeatherUtilBlock.trySpreadOnPos2(world, pos, amountWeHave, amountToAddBasedOnDist, maxFallDist, blockLayerable);
                    }
                }
            }
        }
        System.out.println("leftover: " + amountWeHave);
    }

    public static int tryTakeFromPos(World world, BlockPos posTakeFrom, int amount, int amountAllowedToTakeForXZ, int maxDropAllowed, Block blockLayerable) {
        int amountTaken = 0;
        IBlockState statePos = world.func_180495_p(posTakeFrom);
        if (!WeatherUtilBlock.isLayeredOrVanillaVersionOfBlock(statePos, blockLayerable) && statePos.func_177230_c() != Blocks.field_150350_a) {
            return amount;
        }
        int dropDist = 0;
        BlockPos posScan = new BlockPos((Vec3i)posTakeFrom);
        while (statePos.func_177230_c() == Blocks.field_150350_a && dropDist++ < maxDropAllowed) {
            statePos = world.func_180495_p(posScan = posScan.func_177982_a(0, -1, 0));
            if (WeatherUtilBlock.isLayeredOrVanillaVersionOfBlock(statePos, blockLayerable) || statePos.func_177230_c() == Blocks.field_150350_a) continue;
            return amount;
        }
        int amountLeftToTake = amountAllowedToTakeForXZ;
        while (amountTaken < amountAllowedToTakeForXZ) {
            int amountReturn = WeatherUtilBlock.takeHeightFromLayerableBlock(world, posScan, blockLayerable, amountLeftToTake);
            amountTaken += amountReturn;
            statePos = world.func_180495_p(posScan = posScan.func_177982_a(0, -1, 0));
            if (WeatherUtilBlock.isLayeredOrVanillaVersionOfBlock(statePos, blockLayerable)) continue;
            break;
        }
        return amount + amountTaken;
    }

    public static int trySpreadOnPos2(World world, BlockPos posSpreadTo, int amount, int amountAllowedToAdd, int maxDropAllowed, Block blockLayerable) {
        int distForPlaceableBlocks;
        if (amount <= 0) {
            return amount;
        }
        if (world.func_180495_p(posSpreadTo.func_177982_a(0, 1, 0)).func_185904_a() != Material.field_151579_a) {
            return amount;
        }
        IBlockState statePos = world.func_180495_p(posSpreadTo);
        BlockPos posCheckNonAir = new BlockPos((Vec3i)posSpreadTo);
        IBlockState stateCheckNonAir = world.func_180495_p(posCheckNonAir);
        int depth = 0;
        while (stateCheckNonAir.func_185904_a() == Material.field_151579_a) {
            posCheckNonAir = posCheckNonAir.func_177982_a(0, -1, 0);
            stateCheckNonAir = world.func_180495_p(posCheckNonAir);
            if (++depth <= maxDropAllowed) continue;
            return amount;
        }
        BlockPos posCheckPlaceable = new BlockPos((Vec3i)posCheckNonAir);
        IBlockState stateCheckPlaceable = world.func_180495_p(posCheckPlaceable);
        for (distForPlaceableBlocks = 0; distForPlaceableBlocks < 10; ++distForPlaceableBlocks) {
            AxisAlignedBB aabbCompare = new AxisAlignedBB(posCheckPlaceable);
            ArrayList listAABBCollision = new ArrayList();
            stateCheckPlaceable.func_185908_a(world, posCheckPlaceable, aabbCompare, listAABBCollision, null, false);
            if (stateCheckPlaceable.func_177230_c() != blockLayerable && stateCheckPlaceable.func_177230_c().func_176200_f((IBlockAccess)world, posCheckPlaceable) && listAABBCollision.isEmpty()) {
                posCheckPlaceable = posCheckPlaceable.func_177982_a(0, -1, 0);
                stateCheckPlaceable = world.func_180495_p(posCheckPlaceable);
                continue;
            }
            if (stateCheckPlaceable.isSideSolid((IBlockAccess)world, posCheckPlaceable, EnumFacing.UP) || stateCheckPlaceable.func_177230_c() == blockLayerable) break;
            return amount;
        }
        if (distForPlaceableBlocks >= 10) {
            return amount;
        }
        if (!stateCheckPlaceable.isSideSolid((IBlockAccess)world, posCheckPlaceable, EnumFacing.UP) && stateCheckPlaceable.func_177230_c() != blockLayerable) {
            System.out.println("shouldnt be, failed a check somewhere!");
            return amount;
        }
        for (int i = 0; i < distForPlaceableBlocks; ++i) {
            world.func_175656_a(posCheckNonAir.func_177982_a(0, -i, 0), Blocks.field_150350_a.func_176223_P());
        }
        BlockPos posPlaceLayerable = new BlockPos((Vec3i)posCheckPlaceable);
        IBlockState statePlaceLayerable = world.func_180495_p(posPlaceLayerable);
        int amountToAdd = amountAllowedToAdd;
        while (amountAllowedToAdd > 0 && world.func_180495_p(posPlaceLayerable.func_177982_a(0, 1, 0)).func_185904_a() == Material.field_151579_a && amountAllowedToAdd > 0) {
            int height;
            if (statePlaceLayerable.func_177230_c() == blockLayerable && WeatherUtilBlock.getHeightForLayeredBlock(statePlaceLayerable) < layerableHeightPropMax) {
                height = WeatherUtilBlock.getHeightForLayeredBlock(statePlaceLayerable);
                if ((height += amountAllowedToAdd) > layerableHeightPropMax) {
                    amountAllowedToAdd = height - layerableHeightPropMax;
                    height = layerableHeightPropMax;
                } else {
                    amountAllowedToAdd = 0;
                }
                try {
                    world.func_175656_a(posPlaceLayerable, WeatherUtilBlock.setBlockWithLayerState(blockLayerable, height));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (height != layerableHeightPropMax) continue;
                posPlaceLayerable = posPlaceLayerable.func_177982_a(0, 1, 0);
                statePlaceLayerable = world.func_180495_p(posPlaceLayerable);
                continue;
            }
            if (statePlaceLayerable.isSideSolid((IBlockAccess)world, posPlaceLayerable, EnumFacing.UP)) {
                posPlaceLayerable = posPlaceLayerable.func_177982_a(0, 1, 0);
                statePlaceLayerable = world.func_180495_p(posPlaceLayerable);
                continue;
            }
            if (statePlaceLayerable.func_185904_a() == Material.field_151579_a) {
                height = amountAllowedToAdd;
                if (height > layerableHeightPropMax) {
                    amountAllowedToAdd = height - layerableHeightPropMax;
                    height = layerableHeightPropMax;
                } else {
                    amountAllowedToAdd = 0;
                }
                try {
                    world.func_175656_a(posPlaceLayerable, WeatherUtilBlock.setBlockWithLayerState(blockLayerable, height));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (height != layerableHeightPropMax) continue;
                posPlaceLayerable = posPlaceLayerable.func_177982_a(0, 1, 0);
                statePlaceLayerable = world.func_180495_p(posPlaceLayerable);
                continue;
            }
            System.out.println("wat! - " + statePlaceLayerable);
        }
        if (amountAllowedToAdd < 0) {
            System.out.println("wat");
        }
        int amountAdded = amountToAdd - amountAllowedToAdd;
        return amount -= amountAdded;
    }

    public static boolean isLayeredOrVanillaVersionOfBlock(IBlockState state, Block blockLayerable) {
        Block block = state.func_177230_c();
        if (block == blockLayerable) {
            return true;
        }
        if (blockLayerable == CommonProxy.blockSandLayer && block == Blocks.field_150354_m) {
            return true;
        }
        return blockLayerable == Blocks.field_150431_aC && block == Blocks.field_150433_aE;
    }

    public static int getHeightForAnyBlock(IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150431_aC) {
            return (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
        }
        if (block == CommonProxy.blockSandLayer) {
            return (Integer)state.func_177229_b((IProperty)BlockSandLayer.LAYERS);
        }
        if (block == Blocks.field_150354_m || block == Blocks.field_150433_aE) {
            return 8;
        }
        if (block instanceof BlockSlab) {
            return 4;
        }
        if (block == Blocks.field_150350_a) {
            return 0;
        }
        return 8;
    }

    public static int getHeightForLayeredBlock(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150431_aC) {
            return (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
        }
        if (state.func_177230_c() == CommonProxy.blockSandLayer) {
            return (Integer)state.func_177229_b((IProperty)BlockSandLayer.LAYERS);
        }
        if (state.func_177230_c() == Blocks.field_150354_m || state.func_177230_c() == Blocks.field_150433_aE) {
            return 8;
        }
        return 0;
    }

    public static IBlockState setBlockWithLayerState(Block block, int height) {
        boolean solidBlockUnderMode = true;
        if (block == Blocks.field_150431_aC) {
            if (height == layerableHeightPropMax && solidBlockUnderMode) {
                return Blocks.field_150433_aE.func_176223_P();
            }
            return block.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(height));
        }
        if (block == CommonProxy.blockSandLayer) {
            if (height == layerableHeightPropMax && solidBlockUnderMode) {
                return Blocks.field_150354_m.func_176223_P();
            }
            return block.func_176223_P().func_177226_a((IProperty)BlockSandLayer.LAYERS, (Comparable)Integer.valueOf(height));
        }
        return null;
    }

    public static boolean divideToNeighborCheck(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        boolean foundSpotToSpread = false;
        int heightToUse = WeatherUtilBlock.getHeightForLayeredBlock(state);
        System.out.println("try smooth out");
        if (heightToUse > 2) {
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                int heightCheck;
                if (heightToUse <= 2) continue;
                BlockPos posCheck = pos.func_177972_a(enumfacing);
                IBlockState stateCheck = worldIn.func_180495_p(posCheck);
                int addAmount = 1;
                if (stateCheck.func_177230_c() != state.func_177230_c() || (heightCheck = WeatherUtilBlock.getHeightForLayeredBlock(stateCheck)) + 2 > heightToUse) continue;
                heightToUse -= addAmount;
                WeatherUtilBlock.addHeightToLayerableBLock(worldIn, posCheck, stateCheck.func_177230_c(), heightCheck, addAmount);
                foundSpotToSpread = true;
            }
        }
        if (foundSpotToSpread) {
            worldIn.func_175656_a(pos, WeatherUtilBlock.setBlockWithLayerState(state.func_177230_c(), heightToUse));
        }
        return foundSpotToSpread;
    }

    public static int addHeightToLayerableBLock(World world, BlockPos pos, Block block, int sourceAmount, int amount) {
        IBlockState state = world.func_180495_p(pos);
        int curAmount = sourceAmount;
        int leftOver = 0;
        if ((curAmount += amount) > layerableHeightPropMax) {
            leftOver = curAmount - layerableHeightPropMax;
            curAmount = layerableHeightPropMax;
        } else {
            leftOver = 0;
        }
        try {
            world.func_175656_a(pos, WeatherUtilBlock.setBlockWithLayerState(block, curAmount));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return leftOver;
    }

    public static int takeHeightFromLayerableBlock(World world, BlockPos pos, Block block, int amount) {
        IBlockState state = world.func_180495_p(pos);
        int height = WeatherUtilBlock.getHeightForLayeredBlock(state);
        int amountReceived = 0;
        int newHeight = 0;
        if (height <= amount) {
            newHeight = 0;
            amountReceived = height;
        } else {
            newHeight = height - amount;
            amountReceived = amount;
        }
        if (newHeight > 0) {
            try {
                world.func_175656_a(pos, WeatherUtilBlock.setBlockWithLayerState(block, newHeight));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            world.func_175698_g(pos);
        }
        return amountReceived;
    }

    public static BlockPos getPrecipitationHeightSafe(World world, BlockPos pos) {
        if (world.func_175667_e(pos)) {
            return world.func_175725_q(pos);
        }
        return new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
    }
}

