/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import CoroUtil.util.CoroUtilCompatibility;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import weather2.CommonProxy;
import weather2.config.ConfigTornado;

public class WeatherUtil {
    public static HashMap<Block, Boolean> blockIDToUseMapping = new HashMap();

    public static boolean isPaused() {
        return FMLClientHandler.instance().getClient().func_147113_T();
    }

    public static boolean isPausedSideSafe(World world) {
        if (!world.field_72995_K) {
            return false;
        }
        return WeatherUtil.isPausedForClient();
    }

    public static boolean isPausedForClient() {
        return FMLClientHandler.instance().getClient().func_147113_T();
    }

    public static boolean shouldGrabBlock(World parWorld, IBlockState state) {
        try {
            ItemStack itemStr = new ItemStack(Items.field_151056_x);
            Block block = state.func_177230_c();
            boolean result = true;
            if (ConfigTornado.Storm_Tornado_GrabCond_List) {
                try {
                    if (!ConfigTornado.Storm_Tornado_GrabListBlacklistMode) {
                        if (!blockIDToUseMapping.get(block).booleanValue()) {
                            result = false;
                        }
                    } else if (blockIDToUseMapping.get(block).booleanValue()) {
                        result = false;
                    }
                }
                catch (Exception e) {
                    result = false;
                }
            } else {
                if (ConfigTornado.Storm_Tornado_GrabCond_StrengthGrabbing) {
                    float strMin = 0.0f;
                    float strMax = 0.74f;
                    if (block == null) {
                        result = false;
                        return result;
                    }
                    float strVsBlock = block.func_176195_g(block.func_176223_P(), parWorld, new BlockPos(0, 0, 0)) - (itemStr.func_150997_a(block.func_176223_P()) - 1.0f) / 4.0f;
                    if (strVsBlock <= strMax && strVsBlock >= strMin || block.func_149688_o(block.func_176223_P()) == Material.field_151575_d || block.func_149688_o(block.func_176223_P()) == Material.field_151580_n || block.func_149688_o(block.func_176223_P()) == Material.field_151585_k || block.func_149688_o(block.func_176223_P()) == Material.field_151582_l || block instanceof BlockTallGrass) {
                        if (!WeatherUtil.safetyCheck(block)) {
                            result = false;
                        }
                    } else {
                        result = false;
                    }
                }
                if (ConfigTornado.Storm_Tornado_RefinedGrabRules) {
                    if (block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150354_m || block instanceof BlockLog) {
                        result = false;
                    }
                    if (!CoroUtilCompatibility.canTornadoGrabBlockRefinedRules((IBlockState)state)) {
                        result = false;
                    }
                }
            }
            if (block == CommonProxy.blockWeatherMachine) {
                result = false;
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean safetyCheck(Block id) {
        return id != Blocks.field_150357_h && id != Blocks.field_150364_r && id != Blocks.field_150486_ae && id != Blocks.field_150421_aI;
    }

    public static boolean shouldRemoveBlock(Block blockID) {
        return blockID.func_149688_o(blockID.func_176223_P()) != Material.field_151586_h;
    }

    public static boolean isOceanBlock(Block blockID) {
        return false;
    }

    public static boolean isSolidBlock(Block id) {
        return id == Blocks.field_150348_b || id == Blocks.field_150347_e || id == Blocks.field_150322_A;
    }

    public static void doBlockList() {
        blockIDToUseMapping.clear();
        String[] splEnts = ConfigTornado.Storm_Tornado_GrabList.split(",");
        if (splEnts.length > 0) {
            for (int i = 0; i < splEnts.length; ++i) {
                splEnts[i] = splEnts[i].trim();
            }
        }
        boolean dbgShow = false;
        String dbg = "block list: ";
        blockIDToUseMapping.put(Blocks.field_150350_a, false);
        Set set = Block.field_149771_c.func_148742_b();
        for (Object obj : set) {
            ResourceLocation tagName = (ResourceLocation)obj;
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)tagName);
            if (block == null) continue;
            boolean foundEnt = false;
            for (int j = 0; j < splEnts.length; ++j) {
                if (ConfigTornado.Storm_Tornado_GrabCond_List_PartialMatches) {
                    if (!tagName.toString().contains(splEnts[j])) continue;
                    dbg = dbg + Block.field_149771_c.func_177774_c((Object)block) + ", ";
                    foundEnt = true;
                    break;
                }
                Block blockEntry = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(splEnts[j]));
                if (blockEntry == null || block != blockEntry) continue;
                foundEnt = true;
                dbg = dbg + Block.field_149771_c.func_177774_c((Object)block) + ", ";
                break;
            }
            blockIDToUseMapping.put(block, foundEnt);
        }
        if (dbgShow) {
            System.out.println(dbg);
        }
    }

    public static boolean isAprilFoolsDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return calendar.get(2) == 3 && calendar.get(5) == 1;
    }
}

