/*
 * Decompiled with CFR 0.152.
 */
package weather2.client.tornado;

import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.entity.ParticleCustomMatrix;
import extendedrenderer.shader.Matrix4fe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector4f;

public class TornadoFunnel {
    public Vec3d pos = new Vec3d(0.0, 0.0, 0.0);
    public LinkedList<FunnelPiece> listFunnel = new LinkedList();
    public int amountPerLayer = 30;
    public int particleCount = this.amountPerLayer * 50;
    public int funnelPieces = 2;

    public void tickGame() {
        this.amountPerLayer = 30;
        this.particleCount = this.amountPerLayer * 50;
        this.funnelPieces = 2;
        this.tickGameTestCreate();
        this.tickUpdateFunnel();
    }

    private void tickGameTestCreate() {
        EntityPlayerSP entP = Minecraft.func_71410_x().field_71439_g;
        Random rand = new Random();
        while (this.listFunnel.size() < this.funnelPieces) {
            this.addPieceToEnd(new FunnelPiece());
        }
        for (int i = 0; i < this.listFunnel.size(); ++i) {
            FunnelPiece piece = this.listFunnel.get(i);
            if (piece.needInit) {
                piece.needInit = false;
                int height = 10;
                if (i == 0) {
                    piece.posStart = new Vec3d(entP.field_70165_t, entP.field_70163_u, entP.field_70161_v);
                    piece.posEnd = new Vec3d(entP.field_70165_t, entP.field_70163_u + (double)height, entP.field_70161_v);
                } else {
                    Vec3d prev = this.listFunnel.get((int)(i - 1)).posEnd;
                    piece.posStart = new Vec3d(prev.field_72450_a, prev.field_72448_b, prev.field_72449_c);
                    piece.posEnd = new Vec3d(piece.posStart.field_72450_a, piece.posStart.field_72448_b + (double)height, piece.posStart.field_72449_c);
                }
                if (i == this.funnelPieces - 1) {
                    piece.posEnd = new Vec3d(piece.posStart.field_72450_a, piece.posStart.field_72448_b + (double)height, piece.posStart.field_72449_c);
                }
                piece.vecDirX = rand.nextBoolean() ? 1.0f : -1.0f;
                piece.vecDirZ = rand.nextBoolean() ? 1.0f : -1.0f;
            }
            double dist = piece.posStart.func_72438_d(piece.posEnd);
            double sizeXYParticle = 1.0;
            double funnelRadius = 3.0;
            double circumference = funnelRadius * 2.0 * Math.PI;
            this.amountPerLayer = (int)(circumference / sizeXYParticle);
            int layers = (int)(dist / sizeXYParticle);
            this.particleCount = layers * this.amountPerLayer;
            while (piece.listParticles.size() > this.particleCount) {
                piece.listParticles.get(piece.listParticles.size() - 1).func_187112_i();
                piece.listParticles.remove(piece.listParticles.size() - 1);
            }
            while (piece.listParticles.size() < this.particleCount) {
                BlockPos pos = new BlockPos(piece.posEnd.field_72450_a, piece.posEnd.field_72448_b, piece.posEnd.field_72449_c);
                ParticleCustomMatrix rain = new ParticleCustomMatrix(entP.field_70170_p, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, ParticleRegistry.white_square);
                rain.setSlantParticleToWind(false);
                rain.setDontRenderUnderTopmostBlock(false);
                boolean upward = rand.nextBoolean();
                rain.windWeight = 999999.0f;
                rain.setFacePlayer(false);
                rain.setScale(90.0f + rand.nextFloat() * 3.0f);
                rain.setScale(5.0f);
                rain.func_187114_a(100);
                rain.setGravity(0.0f);
                rain.setTicksFadeInMax(0.0f);
                rain.func_82338_g(1.0f);
                rain.setTicksFadeOutMax(0.0f);
                rain.rotationYaw = 0.0f;
                rain.rotationPitch = 90.0f;
                rain.setMotionY(-0.0);
                rain.setMotionX((double)((rand.nextFloat() - 0.5f) * 0.01f));
                rain.setMotionZ((double)((rand.nextFloat() - 0.5f) * 0.01f));
                rain.spawnAsWeatherEffect();
                rain.weatherEffect = false;
                rain.isTransparent = false;
                rain.quatControl = true;
                rain.useRotationAroundCenter = true;
                piece.listParticles.add(rain);
            }
        }
    }

    private void tickUpdateFunnel() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        for (int ii = 0; ii < this.listFunnel.size(); ++ii) {
            FunnelPiece piece = this.listFunnel.get(ii);
            double rate = 0.5;
            double distMax = 20.0;
            Random rand = new Random();
            int offset = 360 / this.listFunnel.size();
            long timeC = (world.func_82737_E() * (long)(ii + 1) + (long)(offset * ii)) * 1L;
            float range = 35.0f;
            double xx = piece.posEnd.field_72450_a - piece.posStart.field_72450_a;
            double zz = piece.posEnd.field_72449_c - piece.posStart.field_72449_c;
            double xzDist2 = MathHelper.func_76133_a((double)(xx * xx + zz * zz));
            if (xzDist2 > distMax) {
                if (piece.posEnd.field_72450_a - piece.posStart.field_72450_a > 0.0) {
                    piece.vecDirX = -1.0f;
                }
                if (piece.posEnd.field_72450_a - piece.posStart.field_72450_a < 0.0) {
                    piece.vecDirX = 1.0f;
                }
                if (piece.posEnd.field_72449_c - piece.posStart.field_72449_c > 0.0) {
                    piece.vecDirZ = -1.0f;
                }
                if (piece.posEnd.field_72449_c - piece.posStart.field_72449_c < 0.0) {
                    piece.vecDirZ = 1.0f;
                }
            }
            if (ii > 0) {
                Vec3d prev = this.listFunnel.get((int)(ii - 1)).posEnd;
                piece.posStart = new Vec3d(prev.field_72450_a, prev.field_72448_b, prev.field_72449_c);
            }
            double dist = piece.posStart.func_72438_d(piece.posEnd);
            double x = piece.posEnd.field_72450_a - piece.posStart.field_72450_a;
            double y = piece.posEnd.field_72448_b - piece.posStart.field_72448_b;
            double z = piece.posEnd.field_72449_c - piece.posStart.field_72449_c;
            Vec3d vec = new Vec3d(x / dist, y / dist, z / dist);
            double sizeXYParticle = 1.0;
            double funnelRadius = 3.0;
            double circumference = funnelRadius * 2.0 * Math.PI;
            this.amountPerLayer = (int)(circumference / sizeXYParticle);
            int layers = (int)(dist / sizeXYParticle);
            this.particleCount = layers * this.amountPerLayer;
            Iterator<ParticleCustomMatrix> it = piece.listParticles.iterator();
            int i = 0;
            while (it.hasNext()) {
                ParticleCustomMatrix part = it.next();
                if (part.field_187133_m) {
                    it.remove();
                } else {
                    int yIndex = i / this.amountPerLayer;
                    int rotIndex = i % this.amountPerLayer;
                    int yCount = this.particleCount / this.amountPerLayer;
                    long time = world.func_82737_E();
                    long time2 = world.func_82737_E() * 2L;
                    long time3 = world.func_82737_E() * 3L;
                    float speed = 1.0f;
                    float angleY = -((float)(Math.atan2(vec.field_72449_c, vec.field_72450_a) - Math.toRadians(90.0)));
                    float angleX = (float)Math.atan2(vec.field_72449_c, vec.field_72448_b);
                    float angleZ = 0.0f;
                    angleX = (float)Math.toRadians(90.0);
                    angleX = (float)Math.toRadians(time3 % 360L);
                    double xzDist = MathHelper.func_76133_a((double)(vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c));
                    angleX = (float)(-Math.atan2(vec.field_72448_b, xzDist) + Math.toRadians(90.0));
                    float spinAngle = 360.0f / (float)this.amountPerLayer * (float)rotIndex;
                    float radius = 3.0f;
                    spinAngle += (float)time3 * 12.0f;
                    float yy = yIndex;
                    part.rotationAroundCenterPrev = part.rotationAroundCenter;
                    part.rotationAroundCenter = spinAngle %= 360.0f;
                    part.rotationDistAroundCenter = radius;
                    part.yy = yy;
                    part.angleX = angleX;
                    part.angleY = angleY;
                    part.angleZ = angleZ;
                    part.func_187109_b(piece.posStart.field_72450_a, piece.posStart.field_72448_b, piece.posStart.field_72449_c);
                    Matrix4fe matrixSelf = new Matrix4fe();
                    angleY = (float)Math.atan2(vec.field_72449_c, vec.field_72450_a);
                    part.rotationPrev = new Quaternion((ReadableVector4f)part.rotation);
                    Quaternion qY = new Quaternion();
                    Quaternion qX = new Quaternion();
                    Quaternion qZ = new Quaternion();
                    qY.setFromAxisAngle(new Vector4f(0.0f, 1.0f, 0.0f, -angleY));
                    qZ.setFromAxisAngle(new Vector4f(0.0f, 0.0f, 1.0f, -angleX));
                    Quaternion.mul((Quaternion)qY, (Quaternion)qZ, (Quaternion)part.rotation);
                    angleZ = (float)Math.toRadians(90.0f + spinAngle);
                    qX.setFromAxisAngle(new Vector4f(0.0f, 1.0f, 0.0f, angleZ));
                    Quaternion.mul((Quaternion)part.rotation, (Quaternion)qX, (Quaternion)part.rotation);
                    part.setAge(40);
                    float r = 1.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    float stages = 100.0f;
                    r = (float)(time + (long)(i * 1)) % stages * (1.0f / stages);
                    g = (float)(time2 + (long)(i * 1)) % stages * (1.0f / stages);
                    b = (float)(time3 + (long)(i * 1)) % stages * (1.0f / stages);
                    part.func_70538_b(0.0f, 0.0f, 0.0f);
                    part.func_70538_b(r, g, b);
                    if (ii == 0) {
                        // empty if block
                    }
                }
                ++i;
            }
        }
    }

    public void addPieceToEnd(FunnelPiece piece) {
        this.listFunnel.addLast(piece);
    }

    public static Vec3d rotateVectorCC(Vec3d vec, Vec3d axis, double theta) {
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        double u = axis.field_72450_a;
        double v = axis.field_72448_b;
        double w = axis.field_72449_c;
        double xPrime = u * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + x * Math.cos(theta) + (-w * y + v * z) * Math.sin(theta);
        double yPrime = v * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + y * Math.cos(theta) + (w * x - u * z) * Math.sin(theta);
        double zPrime = w * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + z * Math.cos(theta) + (-v * x + u * y) * Math.sin(theta);
        return new Vec3d(xPrime, yPrime, zPrime);
    }

    public Quaternion setEulerAnglesRad(float yaw, float pitch, float roll) {
        float hr = roll * 0.5f;
        float shr = (float)Math.sin(hr);
        float chr = (float)Math.cos(hr);
        float hp = pitch * 0.5f;
        float shp = (float)Math.sin(hp);
        float chp = (float)Math.cos(hp);
        float hy = yaw * 0.5f;
        float shy = (float)Math.sin(hy);
        float chy = (float)Math.cos(hy);
        float chy_shp = chy * shp;
        float shy_chp = shy * chp;
        float chy_chp = chy * chp;
        float shy_shp = shy * shp;
        Quaternion q = new Quaternion();
        q.x = chy_shp * chr + shy_chp * shr;
        q.y = shy_chp * chr - chy_shp * shr;
        q.z = chy_chp * shr - shy_shp * chr;
        q.w = chy_chp * chr + shy_shp * shr;
        return q;
    }

    static class FunnelPiece {
        public List<ParticleCustomMatrix> listParticles = new ArrayList<ParticleCustomMatrix>();
        public Vec3d posStart = new Vec3d(0.0, 0.0, 0.0);
        public Vec3d posEnd = new Vec3d(0.0, 20.0, 0.0);
        public float vecDirX = 0.0f;
        public float vecDirZ = 0.0f;
        public boolean needInit = true;

        FunnelPiece() {
        }
    }
}

