/*
 * Decompiled with CFR 0.152.
 */
package weather2.block;

import CoroUtil.util.Vec3;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import weather2.ServerTickHandler;
import weather2.config.ConfigStorm;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;

public class TileEntityWeatherDeflector
extends TileEntity
implements ITickable {
    public int mode = 0;
    public static int MODE_KILLSTORMS = 0;
    public static int MODE_NOBLOCKDAMAGE = 1;

    public void onLoad() {
        super.onLoad();
        this.maintainBlockDamageDeflect();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            WeatherManagerServer wm;
            if (this.mode == MODE_KILLSTORMS && this.field_145850_b.func_82737_E() % 100L == 0L && (wm = ServerTickHandler.lookupDimToWeatherMan.get(this.field_145850_b.field_73011_w.getDimension())) != null) {
                List<WeatherObject> storms = wm.getStormsAroundForDeflector(new Vec3((double)this.func_174877_v().func_177958_n(), (double)StormObject.layers.get(0).intValue(), (double)this.func_174877_v().func_177952_p()), ConfigStorm.Storm_Deflector_RadiusOfStormRemoval);
                for (int i = 0; i < storms.size(); ++i) {
                    WeatherObject storm = storms.get(i);
                    if (storm == null) continue;
                    wm.removeStormObject(storm.ID);
                    wm.syncStormRemove(storm);
                }
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.maintainBlockDamageDeflect();
            }
        }
    }

    public void maintainBlockDamageDeflect() {
        WeatherManagerServer wm = ServerTickHandler.lookupDimToWeatherMan.get(this.field_145850_b.field_73011_w.getDimension());
        if (wm != null) {
            if (this.mode == MODE_KILLSTORMS) {
                if (wm.getListWeatherBlockDamageDeflector().contains(this.func_174877_v().func_177986_g())) {
                    wm.getListWeatherBlockDamageDeflector().remove(this.func_174877_v().func_177986_g());
                }
            } else if (this.mode == MODE_NOBLOCKDAMAGE && !wm.getListWeatherBlockDamageDeflector().contains(this.func_174877_v().func_177986_g())) {
                wm.getListWeatherBlockDamageDeflector().add(this.func_174877_v().func_177986_g());
            }
        }
    }

    public void rightClicked(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.cycleMode();
        String modeMsg = "";
        if (this.mode == MODE_KILLSTORMS) {
            modeMsg = "Kill thunderstorms and deadlier";
        } else if (this.mode == MODE_NOBLOCKDAMAGE) {
            modeMsg = "Prevent block damage only";
            this.maintainBlockDamageDeflect();
        }
        playerIn.func_145747_a((ITextComponent)new TextComponentString("Weather Deflector set to mode: " + modeMsg));
    }

    public void cycleMode() {
        ++this.mode;
        if (this.mode > MODE_NOBLOCKDAMAGE) {
            this.mode = 0;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound var1) {
        var1.func_74768_a("mode", this.mode);
        return super.func_189515_b(var1);
    }

    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        this.mode = var1.func_74762_e("mode");
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            WeatherManagerServer wm = ServerTickHandler.lookupDimToWeatherMan.get(this.field_145850_b.field_73011_w.getDimension());
            wm.getListWeatherBlockDamageDeflector().remove(this.func_174877_v().func_177986_g());
        }
    }
}

