/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import CoroUtil.packet.PacketHelper;
import CoroUtil.util.CoroUtilEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.ClientTickHandler;
import weather2.ServerTickHandler;
import weather2.Weather;
import weather2.item.ItemPocketSand;
import weather2.util.WeatherUtilConfig;

public class EventHandlerPacket {
    @SubscribeEvent
    public void onPacketFromServer(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound((ByteBuf)event.getPacket().payload());
            String packetCommand = nbt.func_74779_i("packetCommand");
            String command = nbt.func_74779_i("command");
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (packetCommand.equals("WeatherData")) {
                    ClientTickHandler.checkClientWeather();
                    ClientTickHandler.weatherManager.nbtSyncFromServer(nbt);
                } else if (packetCommand.equals("EZGuiData")) {
                    Weather.dbg("receiving GUI data for client, command: " + command);
                    if (command.equals("syncUpdate")) {
                        WeatherUtilConfig.nbtReceiveServerDataForCache(nbt);
                    }
                } else if (packetCommand.equals("PocketSandData")) {
                    if (command.equals("create")) {
                        ItemPocketSand.particulateFromServer(nbt.func_74779_i("playerName"));
                    }
                } else if (packetCommand.equals("ClientConfigData") && command.equals("syncUpdate")) {
                    ClientTickHandler.clientConfigData.readNBT(nbt);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPacketFromClient(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP entP = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound((ByteBuf)event.getPacket().payload());
            String packetCommand = nbt.func_74779_i("packetCommand");
            String command = nbt.func_74779_i("command");
            Weather.dbg("Weather2 packet command from client: " + packetCommand + " - " + command);
            entP.field_71133_b.func_152344_a(() -> {
                if (packetCommand.equals("WeatherData")) {
                    if (command.equals("syncFull")) {
                        ServerTickHandler.playerClientRequestsFullSync(entP);
                    }
                } else if (packetCommand.equals("EZGuiData")) {
                    Weather.dbg("packet handling command: " + command);
                    if (command.equals("syncRequest")) {
                        Weather.dbg("EZGUI syncRequest");
                        NBTTagCompound sendNBT = new NBTTagCompound();
                        sendNBT.func_74778_a("packetCommand", "EZGuiData");
                        sendNBT.func_74778_a("command", "syncUpdate");
                        sendNBT.func_74757_a("markUpdated", true);
                        sendNBT.func_74757_a("isPlayerOP", FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H() || FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(entP.func_146103_bH()));
                        sendNBT.func_74782_a("data", (NBTBase)WeatherUtilConfig.nbtServerData);
                        sendNBT.func_74782_a("dimListing", (NBTBase)WeatherUtilConfig.createNBTDimensionListing());
                        Weather.eventChannel.sendTo(PacketHelper.getNBTPacket((NBTTagCompound)sendNBT, (String)Weather.eventChannelName), entP);
                    } else if (command.equals("applySettings") && (FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H() || FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(entP.func_146103_bH()))) {
                        WeatherUtilConfig.nbtReceiveClientData(nbt.func_74775_l("guiData"));
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getSelfUsername() {
        return CoroUtilEntity.getName((Entity)Minecraft.func_71410_x().field_71439_g);
    }
}

