/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import extendedrenderer.render.FoliageRenderer;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.ClientProxy;
import weather2.ClientTickHandler;
import weather2.ServerTickHandler;
import weather2.Weather;
import weather2.api.WeatherUtilData;
import weather2.client.SceneEnhancer;
import weather2.client.foliage.FoliageEnhancerShader;
import weather2.config.ConfigFoliage;
import weather2.config.ConfigMisc;
import weather2.entity.AI.EntityAIMoveIndoorsStorm;
import weather2.util.UtilEntityBuffsMini;
import weather2.weathersystem.storm.TornadoHelper;
import weather2.weathersystem.wind.WindManager;

public class EventHandlerForge {
    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        Weather.writeOutData(false);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void worldRender(RenderWorldLastEvent event) {
        if (ConfigMisc.Client_PotatoPC_Mode) {
            return;
        }
        ClientTickHandler.checkClientWeather();
        ClientTickHandler.weatherManager.tickRender(event.getPartialTicks());
        SceneEnhancer.renderWorldLast(event);
        FoliageRenderer.radialRange = ConfigFoliage.foliageShaderRange;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureStitchEvent.Pre event) {
        ClientProxy.radarIconRain = event.getMap().func_174942_a(new ResourceLocation("weather2:radar/radar_icon_rain"));
        ClientProxy.radarIconLightning = event.getMap().func_174942_a(new ResourceLocation("weather2:radar/radar_icon_lightning"));
        ClientProxy.radarIconWind = event.getMap().func_174942_a(new ResourceLocation("weather2:radar/radar_icon_wind"));
        ClientProxy.radarIconHail = event.getMap().func_174942_a(new ResourceLocation("weather2:radar/radar_icon_hail"));
        ClientProxy.radarIconTornado = event.getMap().func_174942_a(new ResourceLocation("weather2:radar/radar_icon_tornado"));
        ClientProxy.radarIconCyclone = event.getMap().func_174942_a(new ResourceLocation("weather2:radar/radar_icon_cyclone"));
        ClientProxy.radarIconSandstorm = event.getMap().func_174942_a(new ResourceLocation("weather2:radar/radar_icon_sandstorm"));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        boolean test2;
        if (ConfigMisc.Client_PotatoPC_Mode) {
            return;
        }
        float fogDensity = 0.0f;
        int delay = 5000;
        long time = System.currentTimeMillis() % (long)delay;
        fogDensity = (float)time / (float)delay;
        boolean test = false;
        if (test) {
            event.setCanceled(true);
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            GlStateManager.func_179102_b((float)0.0f);
            GlStateManager.func_179153_c((float)400.0f);
            event.setDensity(fogDensity);
            event.setDensity(0.5f);
        }
        if (test2 = false) {
            GlStateManager.func_179102_b((float)0.0f);
            GlStateManager.func_179153_c((float)7.0f);
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            event.setDensity(1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onFogColors(EntityViewRenderEvent.FogColors event) {
        if (ConfigMisc.Client_PotatoPC_Mode) {
            return;
        }
        if (SceneEnhancer.isFogOverridding()) {
            SceneEnhancer.stormFogRedOrig = event.getRed();
            SceneEnhancer.stormFogGreenOrig = event.getGreen();
            SceneEnhancer.stormFogBlueOrig = event.getBlue();
            event.setRed(SceneEnhancer.stormFogRed);
            event.setGreen(SceneEnhancer.stormFogGreen);
            event.setBlue(SceneEnhancer.stormFogBlue);
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onFogRender(EntityViewRenderEvent.RenderFogEvent event) {
        if (ConfigMisc.Client_PotatoPC_Mode) {
            return;
        }
        if (SceneEnhancer.isFogOverridding()) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            if (event.getFogMode() == -1) {
                GlStateManager.func_179102_b((float)SceneEnhancer.stormFogStartClouds);
                GlStateManager.func_179153_c((float)SceneEnhancer.stormFogEndClouds);
            } else {
                GlStateManager.func_179102_b((float)SceneEnhancer.stormFogStart);
                GlStateManager.func_179153_c((float)SceneEnhancer.stormFogEnd);
            }
        }
    }

    private FloatBuffer setFogColorBuffer(float red, float green, float blue, float alpha) {
        FloatBuffer buff = GLAllocation.func_74529_h((int)16);
        buff.clear();
        buff.put(red).put(green).put(blue).put(alpha);
        buff.flip();
        return buff;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onScreenEvent(RenderGameOverlayEvent.Pre event) {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        SceneEnhancer.renderTick(event);
    }

    @SubscribeEvent
    public void onEntityCreatedOrLoaded(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (ConfigMisc.Villager_MoveInsideForStorms && event.getEntity() instanceof EntityVillager) {
            EntityVillager ent = (EntityVillager)event.getEntity();
            UtilEntityBuffsMini.replaceTaskIfMissing((EntityCreature)ent, EntityAIMoveIndoors.class, EntityAIMoveIndoorsStorm.class, 2);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureStitchEvent.Post event) {
        FoliageEnhancerShader.setupReplacers();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void modelBake(ModelBakeEvent event) {
        FoliageEnhancerShader.modelBakeEvent(event);
    }

    @SubscribeEvent
    public void onBlockBreakTry(BlockEvent.BreakEvent event) {
        boolean testBreakCancel = false;
        if (testBreakCancel && event.getPlayer().func_70005_c_().equals(TornadoHelper.fakePlayerProfile.getName())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Entity ent = event.getEntity();
        if (!ent.field_70170_p.field_72995_K && WeatherUtilData.isWindAffected(ent)) {
            WindManager windMan = ServerTickHandler.getWeatherSystemForDim((int)ent.field_70170_p.field_73011_w.getDimension()).windMan;
            windMan.applyWindForceNew(ent, 0.05f, 0.5f);
        }
    }
}

