/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.itemphysic.physics;

import com.creativemd.itemphysic.ItemDummyContainer;
import com.creativemd.itemphysic.physics.CommonPhysic;
import com.google.common.base.Optional;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ServerPhysic {
    public static Random rand = new Random();
    public static DataParameter<Optional<ItemStack>> ITEM = null;
    public static ThreadLocal<Fluid> fluid = new ThreadLocal();
    private static Method markVelocityChanged = ReflectionHelper.findMethod(Entity.class, (String)"markVelocityChanged", (String)"func_70018_K", (Class[])new Class[0]);
    private static Field health = ReflectionHelper.findField(EntityItem.class, (String[])new String[]{"health", "field_70291_e"});
    private static Field fire = ReflectionHelper.findField(Entity.class, (String[])new String[]{"fire", "field_190534_ay"});
    public static Field age = ReflectionHelper.findField(EntityItem.class, (String[])new String[]{"age", "field_70292_b"});
    private static Method getFlag = ReflectionHelper.findMethod(Entity.class, (String)"getFlag", (String)"func_70083_f", (Class[])new Class[]{Integer.TYPE});

    public static boolean updatePre(EntityItem item) {
        double maxSpeedReduction;
        double speedreduction;
        ItemStack stack = item.func_92059_d();
        float f = 0.98f;
        fluid.set(CommonPhysic.getFluid(item));
        if (fluid.get() == null) {
            return item.func_189652_ae();
        }
        double density = (double)fluid.get().getDensity() / 1000.0;
        double speed = -1.0 / density * 0.01;
        if (ItemDummyContainer.CONFIG.general.swimmingItems.canPass(stack)) {
            speed = 0.05;
        }
        if ((speedreduction = (speed - item.field_70181_x) / 2.0) < -(maxSpeedReduction = 0.05)) {
            speedreduction = -maxSpeedReduction;
        }
        if (speedreduction > maxSpeedReduction) {
            speedreduction = maxSpeedReduction;
        }
        item.field_70181_x += speedreduction;
        f = (float)(1.0 / density / 1.2);
        return true;
    }

    public static void updateBurn(EntityItem item) {
        IBlockState state;
        if (item.field_70170_p.func_180495_p(new BlockPos((Entity)item)).func_185904_a() == Material.field_151587_i && ItemDummyContainer.CONFIG.general.burningItems.canPass(item.func_92059_d())) {
            item.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + rand.nextFloat() * 0.4f);
            for (int i = 0; i < 100; ++i) {
                item.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, item.field_70165_t, item.field_70163_u, item.field_70161_v, (double)rand.nextFloat() * 0.1 - 0.05, 0.2 * rand.nextDouble(), (double)rand.nextFloat() * 0.1 - 0.05, new int[0]);
            }
        }
        if (ItemDummyContainer.CONFIG.general.enableIgniting && !item.field_70170_p.field_72995_K && item.field_70122_E && Math.random() <= 0.1 && ItemDummyContainer.CONFIG.general.ignitingItems.canPass(item.func_92059_d()) && (state = item.field_70170_p.func_180495_p(new BlockPos((Entity)item).func_177977_b())).func_185904_a().func_76217_h() && item.field_70170_p.func_180495_p(new BlockPos((Entity)item)).func_185904_a().func_76222_j()) {
            item.field_70170_p.func_175656_a(new BlockPos((Entity)item), Blocks.field_150480_ab.func_176223_P());
        }
    }

    public static void updatePost(EntityItem item) {
        if (ItemDummyContainer.CONFIG.general.swimmingItems.canPass(item.func_92059_d())) {
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)item.field_70165_t);
            BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)item.field_70163_u), k = MathHelper.func_76128_c((double)item.field_70161_v));
            IBlockState state = item.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
            if (fluid == null && block instanceof IFluidBlock) {
                fluid = ((IFluidBlock)block).getFluid();
            } else if (block instanceof BlockLiquid) {
                fluid = FluidRegistry.WATER;
            }
            if (fluid != null) {
                item.field_70159_w /= (double)fluid.getDensity() / 950.0 * 1.5;
                item.field_70179_y /= (double)fluid.getDensity() / 950.0 * 1.5;
            }
        }
        if (fluid.get() == null) {
            item.field_70181_x *= 0.98;
            if (item.field_70122_E) {
                item.field_70181_x *= -0.5;
            }
        } else {
            item.field_70159_w /= (double)fluid.get().getDensity() / 950.0;
            item.field_70179_y /= (double)fluid.get().getDensity() / 950.0;
        }
        if (ItemDummyContainer.CONFIG.general.despawnItem != -1 && item.lifespan == 6000 && item.lifespan != ItemDummyContainer.CONFIG.general.despawnItem) {
            item.lifespan = ItemDummyContainer.CONFIG.general.despawnItem;
        }
    }

    public static void updateFallState(EntityItem item, double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (onGroundIn && item.field_70143_R > 0.0f && ItemDummyContainer.CONFIG.general.fallSounds) {
            item.func_184185_a(SoundEvents.field_187548_af, Math.min(1.0f, item.field_70143_R / 10.0f), (float)Math.random() * 1.0f + 1.0f);
        }
    }

    public static boolean onCollideWithPlayer(EntityItem item, EntityPlayer par1EntityPlayer) {
        if (!(!ItemDummyContainer.CONFIG.pickup.customPickup || par1EntityPlayer.func_70093_af() && ItemDummyContainer.CONFIG.pickup.pickupWhenSneaking)) {
            return true;
        }
        return item.field_70170_p.field_72995_K || item.func_174874_s();
    }

    public static void onCollideWithPlayer(EntityItem item, EntityPlayer player, boolean needsSneak) {
        if (ItemDummyContainer.CONFIG.pickup.customPickup && needsSneak && (!player.func_70093_af() || !ItemDummyContainer.CONFIG.pickup.pickupWhenSneaking)) {
            return;
        }
        if (!item.field_70170_p.field_72995_K) {
            if (!ItemDummyContainer.CONFIG.pickup.customPickup && item.func_174874_s()) {
                return;
            }
            ItemStack itemstack = item.func_92059_d();
            int i = itemstack.func_190916_E();
            int hook = ForgeEventFactory.onItemPickup((EntityItem)item, (EntityPlayer)player);
            if (hook < 0) {
                return;
            }
            ItemStack clone = itemstack.func_77946_l();
            if (!(item.func_174874_s() && !ItemDummyContainer.CONFIG.pickup.customPickup || item.func_145798_i() != null && item.lifespan - item.func_174872_o() > 200 && !item.func_145798_i().equals(player.func_70005_c_()) || hook != 1 && i > 0 && !player.field_71071_by.func_70441_a(itemstack) && clone.func_190916_E() <= item.func_92059_d().func_190916_E())) {
                clone.func_190920_e(clone.func_190916_E() - item.func_92059_d().func_190916_E());
                FMLCommonHandler.instance().firePlayerItemPickupEvent(player, item, clone);
                if (itemstack.func_190926_b()) {
                    player.func_71001_a((Entity)item, i);
                    item.func_70106_y();
                    itemstack.func_190920_e(i);
                }
                player.func_71064_a(StatList.func_188056_d((Item)itemstack.func_77973_b()), i);
            }
        }
    }

    public static boolean processInitialInteract(EntityItem item, EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (ItemDummyContainer.CONFIG.pickup.customPickup) {
            ServerPhysic.onCollideWithPlayer(item, player, false);
            return true;
        }
        return false;
    }

    public static boolean attackEntityFrom(EntityItem item, DamageSource source, float amount) {
        if (item.func_180431_b(source)) {
            return false;
        }
        if (!item.func_92059_d().func_190926_b() && ItemDummyContainer.CONFIG.general.undestroyableItems.canPass(item.func_92059_d())) {
            return false;
        }
        if (source == DamageSource.field_76371_c | source == DamageSource.field_76370_b | source == DamageSource.field_76372_a && !ItemDummyContainer.CONFIG.general.burningItems.canPass(item.func_92059_d())) {
            return false;
        }
        if (source == DamageSource.field_76367_g) {
            return false;
        }
        try {
            markVelocityChanged.invoke((Object)item, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            health.setInt(item, (int)((float)health.getInt(item) - amount));
            if (health.getInt(item) <= 0) {
                item.func_70106_y();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isItemBurning(EntityItem item) {
        boolean flag = item.field_70170_p != null && item.field_70170_p.field_72995_K;
        try {
            if (item.func_70045_F() || fire.getInt(item) <= 0 && (!flag || !((Boolean)getFlag.invoke((Object)item, 0)).booleanValue())) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ItemDummyContainer.CONFIG.general.burningItems.canPass(item.func_92059_d());
    }
}

