/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabmod.vanilla;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockButtonStone;
import net.minecraft.block.BlockButtonWood;
import net.minecraft.block.BlockEndRod;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTorchSlab
extends BlockTorch {
    public static final PropertyEnum<EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumBlockHalf.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing p_apply_1_) {
            return p_apply_1_ != EnumFacing.DOWN;
        }
    });
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB((double)0.4f, -0.5, (double)0.4f, (double)0.6f, 0.2000000238418579, (double)0.6f);
    protected static final AxisAlignedBB TORCH_BOTTOM_NORTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, (double)0.7f, (double)0.65f, (double)0.8f, 1.0);
    protected static final AxisAlignedBB TORCH_BOTTOM_SOUTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, 0.0, (double)0.65f, (double)0.8f, (double)0.3f);
    protected static final AxisAlignedBB TORCH_BOTTOM_WEST_AABB = new AxisAlignedBB((double)0.7f, (double)0.2f, (double)0.35f, 1.0, (double)0.8f, (double)0.65f);
    protected static final AxisAlignedBB TORCH_BOTTOM_EAST_AABB = new AxisAlignedBB(0.0, (double)0.2f, (double)0.35f, (double)0.3f, (double)0.8f, (double)0.65f);
    protected static final AxisAlignedBB TORCH_TOP_NORTH_AABB = new AxisAlignedBB((double)0.35f, 0.7000000029802322, (double)0.7f, (double)0.65f, 1.300000011920929, 1.0);
    protected static final AxisAlignedBB TORCH_TOP_SOUTH_AABB = new AxisAlignedBB((double)0.35f, 0.7000000029802322, 0.0, (double)0.65f, 1.300000011920929, (double)0.3f);
    protected static final AxisAlignedBB TORCH_TOP_WEST_AABB = new AxisAlignedBB((double)0.7f, 0.7000000029802322, (double)0.35f, 1.0, 1.300000011920929, (double)0.65f);
    protected static final AxisAlignedBB TORCH_TOP_EAST_AABB = new AxisAlignedBB(0.0, 0.7000000029802322, (double)0.35f, (double)0.3f, 1.300000011920929, (double)0.65f);

    public BlockTorchSlab() {
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.BOTTOM)));
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(0.0f);
        this.func_149715_a(0.9375f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(HALF) == EnumBlockHalf.BOTTOM) {
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                case EAST: {
                    return TORCH_BOTTOM_EAST_AABB;
                }
                case WEST: {
                    return TORCH_BOTTOM_WEST_AABB;
                }
                case SOUTH: {
                    return TORCH_BOTTOM_SOUTH_AABB;
                }
                case NORTH: {
                    return TORCH_BOTTOM_NORTH_AABB;
                }
            }
            return STANDING_AABB;
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return TORCH_TOP_EAST_AABB;
            }
            case WEST: {
                return TORCH_TOP_WEST_AABB;
            }
            case SOUTH: {
                return TORCH_TOP_SOUTH_AABB;
            }
            case NORTH: {
                return TORCH_TOP_NORTH_AABB;
            }
        }
        return STANDING_AABB;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!BlockTorchSlab.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public static boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        return true;
    }

    private static boolean canPlaceOn(World worldIn, BlockPos pos) {
        return true;
    }

    protected boolean func_176593_f(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    static boolean validTop(IBlockState state, IBlockState torchState) {
        return state.func_177230_c() instanceof BlockAir || state.func_177230_c() instanceof BlockFluidBase || state.func_177230_c() instanceof BlockSlab && state.func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.TOP) || state.func_177230_c() instanceof BlockStairs && state.func_177228_b().containsValue((Object)BlockStairs.EnumHalf.TOP) && state.func_177228_b().containsValue((Object)BlockHorizontal.field_185512_D) == torchState.func_177228_b().containsValue((Object)BlockHorizontal.field_185512_D) || state.func_177230_c() instanceof BlockEndRod || state.func_177230_c() instanceof BlockTorch || state.func_177230_c() instanceof BlockWallSign || state.func_177230_c() instanceof BlockLadder || state.func_177230_c() instanceof BlockWeb || state.func_177230_c() instanceof BlockVine || state.func_177230_c() instanceof BlockRedstoneTorch || state.func_177230_c() instanceof BlockButtonStone || state.func_177230_c() instanceof BlockButtonWood || state.func_177230_c() instanceof BlockButton;
    }

    protected boolean func_176592_e(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
        if (state == this.func_176223_P() ? worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockSlab && worldIn.func_180495_p(pos.func_177977_b()).func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.BOTTOM) : (state.func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.BOTTOM) ? worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() instanceof BlockSlab && worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.BOTTOM) || worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() instanceof BlockStairs && worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177228_b().containsValue((Object)BlockStairs.EnumHalf.BOTTOM) || worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().isSideSolid(worldIn.func_180495_p(pos.func_177972_a(enumfacing)), (IBlockAccess)worldIn, pos, enumfacing) : state.func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.TOP) && BlockTorchSlab.validTop(worldIn.func_180495_p(pos.func_177984_a()), state) && (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() instanceof BlockSlab && worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.TOP) || worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() instanceof BlockStairs && worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177228_b().containsValue((Object)BlockStairs.EnumHalf.TOP) || worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().isSideSolid(worldIn.func_180495_p(pos.func_177972_a(enumfacing)), (IBlockAccess)worldIn, pos, enumfacing)))) {
            return false;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        if (enumfacing.func_176740_k().func_176722_c()) {
            if (stateIn.func_177229_b(HALF) == EnumBlockHalf.TOP) {
                d1 += 0.5;
            }
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.27 * (double)enumfacing1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.27 * (double)enumfacing1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
        } else {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1 -= 0.5, d2, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        switch (meta) {
            case 1: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.BOTTOM));
                break;
            }
            case 2: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.BOTTOM));
                break;
            }
            case 3: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.BOTTOM));
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.BOTTOM));
                break;
            }
            case 5: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.TOP));
                break;
            }
            case 6: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.TOP));
                break;
            }
            case 7: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.TOP));
                break;
            }
            case 8: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.TOP));
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.BOTTOM));
            }
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(HALF) == EnumBlockHalf.BOTTOM) {
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                case EAST: {
                    i |= 1;
                    break;
                }
                case WEST: {
                    i |= 2;
                    break;
                }
                case SOUTH: {
                    i |= 3;
                    break;
                }
                case NORTH: {
                    i |= 4;
                    break;
                }
                default: {
                    i |= 9;
                    break;
                }
            }
        } else {
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                case EAST: {
                    i |= 5;
                    break;
                }
                case WEST: {
                    i |= 6;
                    break;
                }
                case SOUTH: {
                    i |= 7;
                    break;
                }
                case NORTH: {
                    i |= 8;
                    break;
                }
                default: {
                    i |= 9;
                }
            }
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HALF});
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150478_aa);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Blocks.field_150478_aa);
    }

    public static enum EnumBlockHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private EnumBlockHalf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

