/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabmod;

import com.endlesnights.torchslabmod.config.Config;
import com.endlesnights.torchslabmod.vanilla.BlockTorchSlab;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockButtonStone;
import net.minecraft.block.BlockButtonWood;
import net.minecraft.block.BlockEndRod;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="torchslabmod")
public class PlaceHandlerTorch {
    private static final HashMap<ResourceLocation, IBlockState> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        ResourceLocation rl = held.func_77973_b().getRegistryName();
        if (PLACE_ENTRIES.containsKey(rl)) {
            PlaceHandlerTorch.placeTorch(event, held, PLACE_ENTRIES.get(rl));
        }
    }

    private static void placeTorch(PlayerInteractEvent.RightClickBlock event, ItemStack held, IBlockState state) {
        BlockPos pos = event.getPos();
        EnumFacing face = event.getFace();
        BlockPos placeAt = pos.func_177972_a(face);
        World world = event.getWorld();
        EntityPlayer playerIn = event.getEntityPlayer();
        if (!playerIn.func_70093_af() && Config.InteractiveBlockCheckList.contains(world.func_180495_p(pos).func_177230_c().getRegistryName().toString())) {
            return;
        }
        if (face == EnumFacing.UP && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150358_i) && world.func_180495_p(pos).func_177230_c() instanceof BlockSlab && world.func_180495_p(pos).func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.BOTTOM)) {
            world.func_175656_a(placeAt, state);
            SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)playerIn);
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b() - 0.2f);
            playerIn.func_184609_a(event.getHand());
            if (!playerIn.func_184812_l_()) {
                held.func_190918_g(1);
            }
            event.setCanceled(true);
        } else if (face.func_176740_k().func_176722_c()) {
            if (world.func_180495_p(pos).func_177230_c().isSideSolid(world.func_180495_p(pos), (IBlockAccess)world, pos, face) && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150358_i)) {
                if (PlaceHandlerTorch.blockHalf(playerIn, pos, face) >= 0.0 && PlaceHandlerTorch.validTop(world.func_180495_p(placeAt.func_177984_a()), state.func_177226_a((IProperty)BlockTorchSlab.FACING, (Comparable)face).func_177226_a(BlockTorchSlab.HALF, (Comparable)((Object)BlockTorchSlab.EnumBlockHalf.TOP)))) {
                    if (!Config.UpperBlockCheck) {
                        return;
                    }
                    world.func_175656_a(placeAt, state.func_177226_a((IProperty)BlockTorchSlab.FACING, (Comparable)face).func_177226_a(BlockTorchSlab.HALF, (Comparable)((Object)BlockTorchSlab.EnumBlockHalf.TOP)));
                } else {
                    world.func_175656_a(placeAt, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)face));
                }
                SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)playerIn);
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b() - 0.2f);
                playerIn.func_184609_a(event.getHand());
                if (!playerIn.func_184812_l_()) {
                    held.func_190918_g(1);
                }
                event.setCanceled(true);
            } else if ((world.func_180495_p(pos).func_177230_c() instanceof BlockSlab && world.func_180495_p(pos).func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.BOTTOM) || world.func_180495_p(pos).func_177230_c() instanceof BlockStairs && world.func_180495_p(pos).func_177228_b().containsValue((Object)BlockStairs.EnumHalf.BOTTOM)) && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150358_i)) {
                SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)playerIn);
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b() - 0.2f);
                playerIn.func_184609_a(event.getHand());
                world.func_175656_a(placeAt, state.func_177226_a((IProperty)BlockTorchSlab.FACING, (Comparable)face).func_177226_a(BlockTorchSlab.HALF, (Comparable)((Object)BlockTorchSlab.EnumBlockHalf.BOTTOM)));
                if (!playerIn.func_184812_l_()) {
                    held.func_190918_g(1);
                }
                event.setCanceled(true);
            } else if ((world.func_180495_p(pos).func_177230_c() instanceof BlockSlab && world.func_180495_p(pos).func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.TOP) || world.func_180495_p(pos).func_177230_c() instanceof BlockStairs && world.func_180495_p(pos).func_177228_b().containsValue((Object)BlockStairs.EnumHalf.TOP)) && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150358_i) && PlaceHandlerTorch.validTop(world.func_180495_p(placeAt.func_177984_a()), state.func_177226_a((IProperty)BlockTorchSlab.FACING, (Comparable)face).func_177226_a(BlockTorchSlab.HALF, (Comparable)((Object)BlockTorchSlab.EnumBlockHalf.TOP)))) {
                SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)playerIn);
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b() - 0.2f);
                playerIn.func_184609_a(event.getHand());
                world.func_175656_a(placeAt, state.func_177226_a((IProperty)BlockTorchSlab.FACING, (Comparable)face).func_177226_a(BlockTorchSlab.HALF, (Comparable)((Object)BlockTorchSlab.EnumBlockHalf.TOP)));
                if (!playerIn.func_184812_l_()) {
                    held.func_190918_g(1);
                }
                event.setCanceled(true);
            }
        }
    }

    static boolean validTop(IBlockState state, IBlockState torchState) {
        return state.func_177230_c() instanceof BlockAir || state.func_177230_c() instanceof BlockFluidBase || state.func_177230_c() instanceof BlockSlab && state.func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.TOP) || state.func_177230_c() instanceof BlockStairs && state.func_177228_b().containsValue((Object)BlockStairs.EnumHalf.TOP) && state.func_177228_b().containsValue((Object)BlockHorizontal.field_185512_D) == torchState.func_177228_b().containsValue((Object)BlockHorizontal.field_185512_D) || state.func_177230_c() instanceof BlockEndRod || state.func_177230_c() instanceof BlockTorch || state.func_177230_c() instanceof BlockWallSign || state.func_177230_c() instanceof BlockLadder || state.func_177230_c() instanceof BlockWeb || state.func_177230_c() instanceof BlockVine || state.func_177230_c() instanceof BlockRedstoneTorch || state.func_177230_c() instanceof BlockButtonStone || state.func_177230_c() instanceof BlockButtonWood || state.func_177230_c() instanceof BlockButton;
    }

    static double blockHalf(EntityPlayer playerIn, BlockPos pos, EnumFacing face) {
        double angleX = Math.toRadians(playerIn.field_70177_z);
        double angleY = Math.toRadians(playerIn.field_70125_A);
        double sinYaw = Math.sin(angleX);
        double cosYaw = Math.cos(angleX);
        double sinPitch = Math.sin(angleY);
        double cosPitch = Math.cos(angleY);
        Vec3d directionAngle = new Vec3d(cosPitch * cosYaw, sinPitch, cosPitch * sinYaw);
        Double yOffset = playerIn.func_174824_e((float)0.0f).field_72448_b - ((double)pos.func_177956_o() + 0.5);
        if (face == EnumFacing.NORTH) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72449_c - (double)pos.func_177952_p()) / directionAngle.field_72450_a;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        if (face == EnumFacing.SOUTH) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72449_c - (double)(pos.func_177952_p() + 1)) / directionAngle.field_72450_a;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        if (face == EnumFacing.WEST) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72450_a - (double)pos.func_177958_n()) / -directionAngle.field_72449_c;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        if (face == EnumFacing.EAST) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72450_a - (double)(pos.func_177958_n() + 1)) / -directionAngle.field_72449_c;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        return 0.0;
    }

    public static void registerPlaceEntry(ResourceLocation itemName, IBlockState blockState) {
        if (!PLACE_ENTRIES.containsKey(itemName)) {
            PLACE_ENTRIES.put(itemName, blockState);
        }
    }

    public static Collection<IBlockState> getPlaceEntryBlocks() {
        return PLACE_ENTRIES.values();
    }
}

