/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabmod;

import com.endlesnights.torchslabmod.config.Config;
import com.endlesnights.torchslabmod.futuremc.BlockLanternWall;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="torchslabmod")
public class PlaceHandlerLanternWall {
    private static final HashMap<ResourceLocation, IBlockState> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        ResourceLocation rl = held.func_77973_b().getRegistryName();
        if (PLACE_ENTRIES.containsKey(rl)) {
            PlaceHandlerLanternWall.placeLantern(event, held, PLACE_ENTRIES.get(rl));
        }
    }

    private static void placeLantern(PlayerInteractEvent.RightClickBlock event, ItemStack held, IBlockState state) {
        BlockPos pos = event.getPos();
        EnumFacing face = event.getFace();
        BlockPos placeAt = pos.func_177972_a(face);
        World world = event.getWorld();
        EntityPlayer playerIn = event.getEntityPlayer();
        if (face == EnumFacing.UP || face == EnumFacing.DOWN || !playerIn.func_70093_af() && Config.InteractiveBlockCheckList.contains(world.func_180495_p(pos).func_177230_c().getRegistryName().toString())) {
            return;
        }
        if ((world.func_180495_p(pos).func_177230_c().isSideSolid(world.func_180495_p(pos), (IBlockAccess)world, pos, face) || world.func_180495_p(pos).func_177230_c() instanceof BlockFence) && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150358_i)) {
            if (!(Config.UpperBlockCheck && !(PlaceHandlerLanternWall.blockHalf(playerIn, pos, face) <= 0.0) || world.func_180495_p(placeAt.func_177977_b()).func_177230_c().isSideSolid(world.func_180495_p(placeAt.func_177977_b()), (IBlockAccess)world, placeAt.func_177977_b(), face.func_176734_d()))) {
                world.func_175656_a(placeAt, state.func_177226_a((IProperty)BlockLanternWall.FACING, (Comparable)face).func_177226_a((IProperty)BlockLanternWall.TOP, (Comparable)Boolean.valueOf(false)));
            } else {
                world.func_175656_a(placeAt, state.func_177226_a((IProperty)BlockLanternWall.FACING, (Comparable)face).func_177226_a((IProperty)BlockLanternWall.TOP, (Comparable)Boolean.valueOf(true)));
            }
            SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)playerIn);
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b() - 0.2f);
            playerIn.func_184609_a(event.getHand());
            if (!playerIn.func_184812_l_()) {
                held.func_190918_g(1);
            }
            event.setCanceled(true);
        } else if ((world.func_180495_p(pos).func_177230_c() instanceof BlockSlab && world.func_180495_p(pos).func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.BOTTOM) || world.func_180495_p(pos).func_177230_c() instanceof BlockStairs && world.func_180495_p(pos).func_177228_b().containsValue((Object)BlockStairs.EnumHalf.BOTTOM)) && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150358_i) && !world.func_180495_p(placeAt.func_177977_b()).func_177230_c().isSideSolid(world.func_180495_p(placeAt.func_177977_b()), (IBlockAccess)world, placeAt.func_177977_b(), face.func_176734_d())) {
            SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)playerIn);
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b() - 0.2f);
            playerIn.func_184609_a(event.getHand());
            world.func_175656_a(placeAt, state.func_177226_a((IProperty)BlockLanternWall.FACING, (Comparable)face).func_177226_a((IProperty)BlockLanternWall.TOP, (Comparable)Boolean.valueOf(false)));
            if (!playerIn.func_184812_l_()) {
                held.func_190918_g(1);
            }
            event.setCanceled(true);
        } else if ((world.func_180495_p(pos).func_177230_c() instanceof BlockSlab && world.func_180495_p(pos).func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.TOP) || world.func_180495_p(pos).func_177230_c() instanceof BlockStairs && world.func_180495_p(pos).func_177228_b().containsValue((Object)BlockStairs.EnumHalf.TOP)) && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150358_i)) {
            SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)playerIn);
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b() - 0.2f);
            playerIn.func_184609_a(event.getHand());
            world.func_175656_a(placeAt, state.func_177226_a((IProperty)BlockLanternWall.FACING, (Comparable)face).func_177226_a((IProperty)BlockLanternWall.TOP, (Comparable)Boolean.valueOf(true)));
            if (!playerIn.func_184812_l_()) {
                held.func_190918_g(1);
            }
            event.setCanceled(true);
        }
    }

    static double blockHalf(EntityPlayer playerIn, BlockPos pos, EnumFacing face) {
        double angleX = Math.toRadians(playerIn.field_70177_z);
        double angleY = Math.toRadians(playerIn.field_70125_A);
        double sinYaw = Math.sin(angleX);
        double cosYaw = Math.cos(angleX);
        double sinPitch = Math.sin(angleY);
        double cosPitch = Math.cos(angleY);
        Vec3d directionAngle = new Vec3d(cosPitch * cosYaw, sinPitch, cosPitch * sinYaw);
        Double yOffset = playerIn.func_174824_e((float)0.0f).field_72448_b - ((double)pos.func_177956_o() + 0.5);
        if (face == EnumFacing.NORTH) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72449_c - (double)pos.func_177952_p()) / directionAngle.field_72450_a;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        if (face == EnumFacing.SOUTH) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72449_c - (double)(pos.func_177952_p() + 1)) / directionAngle.field_72450_a;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        if (face == EnumFacing.WEST) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72450_a - (double)pos.func_177958_n()) / -directionAngle.field_72449_c;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        if (face == EnumFacing.EAST) {
            double magnatude = (playerIn.func_174824_e((float)1.0f).field_72450_a - (double)(pos.func_177958_n() + 1)) / -directionAngle.field_72449_c;
            return magnatude * directionAngle.field_72448_b + yOffset;
        }
        return 0.0;
    }

    public static void registerPlaceEntry(ResourceLocation itemName, IBlockState blockState) {
        if (!PLACE_ENTRIES.containsKey(itemName)) {
            PLACE_ENTRIES.put(itemName, blockState);
        }
    }

    public static Collection<IBlockState> getPlaceEntryBlocks() {
        return PLACE_ENTRIES.values();
    }
}

