/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabmod;

import com.endlesnights.torchslabmod.config.Config;
import com.endlesnights.torchslabmod.futuremc.BlockLanternSlab;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="torchslabmod")
public class PlaceHandlerLanternSlab {
    private static final HashMap<ResourceLocation, IBlockState> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        ResourceLocation rl = held.func_77973_b().getRegistryName();
        if (PLACE_ENTRIES.containsKey(rl)) {
            PlaceHandlerLanternSlab.placeLantern(event, held, PLACE_ENTRIES.get(rl));
        }
    }

    private static void placeLantern(PlayerInteractEvent.RightClickBlock event, ItemStack held, IBlockState state) {
        BlockPos pos = event.getPos();
        EnumFacing face = event.getFace();
        BlockPos placeAt = pos.func_177972_a(face);
        World world = event.getWorld();
        EntityPlayer playerIn = event.getEntityPlayer();
        if (!playerIn.func_70093_af() && Config.InteractiveBlockCheckList.contains(world.func_180495_p(pos).func_177230_c().getRegistryName().toString())) {
            return;
        }
        if (face == EnumFacing.UP && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150358_i) && world.func_180495_p(pos).func_177230_c() instanceof BlockSlab && world.func_180495_p(pos).func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.BOTTOM)) {
            world.func_175656_a(placeAt, state);
            SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)playerIn);
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b() - 0.2f);
            playerIn.func_184609_a(event.getHand());
            if (!playerIn.func_184812_l_()) {
                held.func_190918_g(1);
            }
            event.setCanceled(true);
        } else if (face == EnumFacing.DOWN && (world.func_175623_d(placeAt) || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(placeAt).func_177230_c() == Blocks.field_150358_i) && world.func_180495_p(pos).func_177230_c() instanceof BlockSlab && world.func_180495_p(pos).func_177228_b().containsValue((Object)BlockSlab.EnumBlockHalf.TOP)) {
            world.func_175656_a(placeAt, state.func_177226_a((IProperty)BlockLanternSlab.HANGING, (Comparable)Boolean.valueOf(true)));
            SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)playerIn);
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b() - 0.2f);
            playerIn.func_184609_a(event.getHand());
            if (!playerIn.func_184812_l_()) {
                held.func_190918_g(1);
            }
            event.setCanceled(true);
        }
    }

    public static void registerPlaceEntry(ResourceLocation itemName, IBlockState blockState) {
        if (!PLACE_ENTRIES.containsKey(itemName)) {
            PLACE_ENTRIES.put(itemName, blockState);
        }
    }

    public static Collection<IBlockState> getPlaceEntryBlocks() {
        return PLACE_ENTRIES.values();
    }
}

