/*
 * Decompiled with CFR 0.152.
 */
package com.pyraliron.advancedtfctech.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ListUtils;
import com.google.common.collect.Lists;
import com.pyraliron.advancedtfctech.client.gui.MultiblockRecipe;
import com.pyraliron.advancedtfctech.init.ModItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class PowerLoomRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final IngredientStack input;
    public final IngredientStack secondaryInput;
    public final String oreInputString;
    public final ItemStack output;
    public final ItemStack secondaryOutput;
    public final EnumPowerLoomProcessType processType;
    public String specialRecipeType;
    public static ArrayList<String> specialRecipeTypes = new ArrayList();
    public static ArrayList<PowerLoomRecipe> recipeList = new ArrayList();

    public PowerLoomRecipe(ItemStack output, Object input, Object secondaryInput, ItemStack secondaryOutput, int time, int energyPerTick) {
        this.output = output;
        this.input = ApiUtils.createIngredientStack((Object)input);
        this.secondaryInput = ApiUtils.createIngredientStack((Object)secondaryInput);
        this.processType = this.input.equals((Object)new IngredientStack(new ItemStack(ModItems.SILK_WINDED_PIRN, 1))) ? EnumPowerLoomProcessType.SILK_CLOTH : (this.input.equals((Object)new IngredientStack(new ItemStack(ModItems.WOOL_WINDED_PIRN, 1))) ? EnumPowerLoomProcessType.WOOL_CLOTH : (this.input.equals((Object)new IngredientStack(new ItemStack(ModItems.FIBER_WINDED_PIRN, 1))) ? EnumPowerLoomProcessType.BURLAP : EnumPowerLoomProcessType.SILK_CLOTH));
        this.secondaryOutput = secondaryOutput;
        this.oreInputString = input instanceof String ? (String)input : null;
        this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
        this.totalProcessEnergy = (int)Math.floor((float)energyPerTick * energyModifier) * this.totalProcessTime;
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.input});
        this.outputList = ListUtils.fromItem((ItemStack)this.output);
    }

    @Override
    public void setupJEI() {
        super.setupJEI();
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static PowerLoomRecipe loadFromNBT(NBTTagCompound nbt) {
        IngredientStack input = IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("input"));
        for (PowerLoomRecipe recipe : recipeList) {
            if (!recipe.input.equals((Object)input)) continue;
            return recipe;
        }
        return null;
    }

    public NonNullList<ItemStack> getOutputs(ItemStack input) {
        NonNullList outputs = NonNullList.func_191196_a();
        outputs.add((Object)this.output);
        return outputs;
    }

    public boolean matches(ItemStack input) {
        return this.input != null && this.input.matches((Object)input);
    }

    public boolean isValidInput(ItemStack stack) {
        return this.input != null && this.input.matches((Object)stack);
    }

    public boolean isValidSecondary(ItemStack stack) {
        return this.secondaryInput != null && this.secondaryInput.matches((Object)stack);
    }

    public PowerLoomRecipe setSpecialRecipeType(String type) {
        this.specialRecipeType = type;
        if (!specialRecipeTypes.contains(type)) {
            specialRecipeTypes.add(type);
        }
        return this;
    }

    public static PowerLoomRecipe addRecipe(ItemStack output, Object input, Object secondaryInput, ItemStack secondaryOutput, int time, int energyPerTick) {
        PowerLoomRecipe recipe = new PowerLoomRecipe(output, input, secondaryInput, secondaryOutput, time, energyPerTick);
        if (recipe.input != null) {
            recipeList.add(recipe);
        }
        return recipe;
    }

    public static PowerLoomRecipe findRecipe(ItemStack input, ItemStack secondary) {
        for (PowerLoomRecipe recipe : recipeList) {
            if (recipe == null || !recipe.matches(input) || !recipe.secondaryInput.matchesItemStackIgnoringSize(secondary)) continue;
            return recipe;
        }
        return null;
    }

    public static List<PowerLoomRecipe> removeRecipes(ItemStack stack) {
        ArrayList<PowerLoomRecipe> list = new ArrayList<PowerLoomRecipe>();
        Iterator<PowerLoomRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            PowerLoomRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static boolean isValidRecipeInput(ItemStack stack) {
        for (PowerLoomRecipe recipe : recipeList) {
            if (recipe == null || !recipe.isValidInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidRecipeSecondary(ItemStack stack) {
        for (PowerLoomRecipe recipe : recipeList) {
            if (recipe == null || !recipe.isValidSecondary(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean inputMatchesSecondary(ItemStack input, ItemStack secondary, boolean allowEmpty) {
        if (input.func_190926_b() || secondary.func_190926_b()) {
            return allowEmpty;
        }
        if (input.func_77973_b().equals(ModItems.FIBER_WINDED_PIRN) && (secondary.func_77973_b().equals(IEContent.itemMaterial) && secondary.func_77960_j() == 4 || secondary.func_77973_b().equals(ItemsTFC.JUTE_FIBER))) {
            return true;
        }
        if (input.func_77973_b().equals(ModItems.WOOL_WINDED_PIRN) && secondary.func_77973_b().equals(ItemsTFC.WOOL_YARN)) {
            return true;
        }
        return input.func_77973_b().equals(ModItems.SILK_WINDED_PIRN) && secondary.func_77973_b().equals(Items.field_151007_F);
    }

    public static enum EnumPowerLoomProcessType {
        WOOL_CLOTH,
        SILK_CLOTH,
        BURLAP,
        BURLAP_HEMP;


        public ItemStack getPirnFromType() {
            return this.ordinal() == WOOL_CLOTH.ordinal() ? new ItemStack(ModItems.WOOL_WINDED_PIRN) : (this.ordinal() == SILK_CLOTH.ordinal() ? new ItemStack(ModItems.SILK_WINDED_PIRN) : new ItemStack(ModItems.FIBER_WINDED_PIRN));
        }

        public ItemStack getSecondaryFromType() {
            return this.ordinal() == WOOL_CLOTH.ordinal() ? new ItemStack((Item)ItemsTFC.WOOL_YARN) : (this.ordinal() == SILK_CLOTH.ordinal() ? new ItemStack(Items.field_151007_F) : (this.ordinal() == BURLAP.ordinal() ? new ItemStack((Item)ItemsTFC.JUTE_FIBER) : new ItemStack((Item)IEContent.itemMaterial, 1, 4)));
        }

        public ItemStack getOutputFromType() {
            return this.ordinal() == WOOL_CLOTH.ordinal() ? new ItemStack((Item)ItemsTFC.WOOL_CLOTH) : (this.ordinal() == SILK_CLOTH.ordinal() ? new ItemStack((Item)ItemsTFC.SILK_CLOTH) : new ItemStack((Item)ItemsTFC.BURLAP_CLOTH));
        }

        public static EnumPowerLoomProcessType getTypeFromStack(ItemStack stack) {
            if (stack.func_77973_b().equals(ItemsTFC.JUTE_FIBER) || stack.func_77973_b().equals(IEContent.itemMaterial) && stack.func_77960_j() == 4 || stack.func_77973_b().equals(ModItems.FIBER_WINDED_PIRN)) {
                return BURLAP;
            }
            if (stack.func_77973_b().equals(ItemsTFC.WOOL_YARN) || stack.func_77973_b().equals(ModItems.WOOL_WINDED_PIRN)) {
                return WOOL_CLOTH;
            }
            return SILK_CLOTH;
        }
    }
}

