/*
 * Decompiled with CFR 0.152.
 */
package brightspark.pollutantpump.tiles;

import brightspark.pollutantpump.PPConfig;
import brightspark.pollutantpump.blocks.BlockPipe;
import com.endertech.minecraft.forge.api.IPollutant;
import com.endertech.minecraft.mods.adpother.blocks.Filter;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;

public class TilePump
extends TileEntity
implements ITickable {
    private final EnergyStorage energy = new EnergyStorage(PPConfig.pumpMaxEnergyStorage, Integer.MAX_VALUE);
    private boolean checkForPipes = true;
    private BlockPos topPipe;
    private long lastWork;

    public void func_73660_a() {
        if (this.checkForPipes) {
            this.topPipe = BlockPipe.findTop(this.field_145850_b, this.field_174879_c);
            this.checkForPipes = false;
        }
        if (this.topPipe == null) {
            return;
        }
        if (this.field_145850_b.func_82737_E() - this.lastWork >= (long)PPConfig.pumpWorkRate && this.energy.getEnergyStored() >= PPConfig.pumpEnergyUse) {
            this.lastWork = this.field_145850_b.func_82737_E();
            List<BlockPos> positions = this.getAllPositionsInRange();
            for (BlockPos position : positions) {
                int pollutantAmount;
                Pollutant pollutant;
                IBlockState state = this.field_145850_b.func_180495_p(position);
                Block block = state.func_177230_c();
                if (!(block instanceof Pollutant) || ((IPollutant)block).getPollutantType() != IPollutant.Type.AIR || !this.tryPumpPollutant(state, pollutant = (Pollutant)block, pollutantAmount = pollutant.getCarriedPollutionAmount(state))) continue;
                this.field_145850_b.func_175698_g(position);
                break;
            }
            this.energy.extractEnergy(PPConfig.pumpEnergyUse, false);
        }
    }

    private List<BlockPos> getAllPositionsInRange() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = this.topPipe.func_177958_n() - PPConfig.pumpRange; x <= this.topPipe.func_177958_n() + PPConfig.pumpRange; ++x) {
            for (int y = this.topPipe.func_177956_o() - PPConfig.pumpRange; y <= this.topPipe.func_177956_o() + PPConfig.pumpRange; ++y) {
                for (int z = this.topPipe.func_177952_p() - PPConfig.pumpRange; z <= this.topPipe.func_177952_p() + PPConfig.pumpRange; ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        Collections.shuffle(positions);
        return positions;
    }

    private boolean tryPumpPollutant(IBlockState pollutantState, Pollutant<?> pollutantBlock, int pollutantAmount) {
        BlockPos sidePos;
        ArrayList horizontals = Lists.newArrayList((Object[])EnumFacing.field_176754_o);
        Collections.shuffle(horizontals);
        for (EnumFacing side : horizontals) {
            int freeSpace;
            Filter filter;
            Filter.BlockTile filterTE;
            sidePos = this.field_174879_c.func_177972_a(side);
            IBlockState sideState = this.field_145850_b.func_180495_p(sidePos);
            Block sideBlock = sideState.func_177230_c();
            if (!(sideBlock instanceof Filter) || (filterTE = (filter = (Filter)sideBlock).getBlockTile((IBlockAccess)this.field_145850_b, sidePos)) == null || (freeSpace = filter.getContent(filterTE).getFreeSpaceFor(pollutantBlock)) < pollutantAmount) continue;
            filter.fill(filterTE, pollutantBlock, pollutantAmount);
            return true;
        }
        for (EnumFacing side : horizontals) {
            sidePos = this.field_174879_c.func_177972_a(side);
            if (!this.field_145850_b.func_175623_d(sidePos)) continue;
            this.field_145850_b.func_175656_a(sidePos, pollutantState);
            return true;
        }
        return false;
    }

    public void onLoad() {
        this.lastWork = this.field_145850_b.func_82737_E();
    }

    public void clearPipe() {
        this.checkForPipes = true;
        this.topPipe = null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }
}

