/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.mixin.core;

import java.util.Arrays;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import org.dimdev.jeid.INewChunk;
import org.dimdev.jeid.JEID;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Chunk.class})
public class MixinChunk
implements INewChunk {
    private static final byte errorBiomeID = (byte)Biome.field_185377_q.func_148757_b((Object)JEID.errorBiome);
    private final int[] intBiomeArray = MixinChunk.generateIntBiomeArray();

    private static int[] generateIntBiomeArray() {
        int[] arr = new int[256];
        Arrays.fill(arr, -1);
        return arr;
    }

    @Override
    public int[] getIntBiomeArray() {
        return this.intBiomeArray;
    }

    @Override
    public void setIntBiomeArray(int[] intBiomeArray) {
        System.arraycopy(intBiomeArray, 0, this.intBiomeArray, 0, this.intBiomeArray.length);
    }

    @Overwrite
    public byte[] func_76605_m() {
        byte[] arr = new byte[256];
        Arrays.fill(arr, errorBiomeID);
        return arr;
    }

    @Redirect(method={"getBiome"}, at=@At(value="FIELD", target="Lnet/minecraft/world/chunk/Chunk;blockBiomeArray:[B", args={"array=get"}))
    private int getIntBiomeIdFromArray(byte[] array, int index) {
        return this.intBiomeArray[index];
    }

    @Inject(method={"getBiome"}, at={@At(value="FIELD", target="Lnet/minecraft/world/chunk/Chunk;blockBiomeArray:[B", args={"array=set"})}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void setIntBiomeIdInArray(BlockPos pos, BiomeProvider provider, CallbackInfoReturnable<Biome> cir, int i, int j, int k, Biome biome) {
        this.intBiomeArray[j << 4 | i] = k;
    }

    @ModifyConstant(method={"getBiome"}, constant={@Constant(intValue=255)})
    private int getBiomeBitmask(int oldValue) {
        return -1;
    }
}

