/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.common;

import com.parachute.client.ClientConfiguration;
import com.parachute.common.ConfigHandler;
import com.parachute.common.Parachute;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityParachute
extends Entity {
    private double maxAltitude;
    private boolean allowThermals;
    private boolean lavaThermals;
    private double lavaDistance;
    private double maxLavaDistance;
    private double curLavaDistance;
    private boolean allowTurbulence = ConfigHandler.getAllowturbulence();
    private boolean showContrails = ConfigHandler.getShowContrails();
    private boolean dismountInWater;
    private double deltaRotation;
    private double forwardMomentum;
    private double backMomentum;
    private double rotationMomentum;
    private double slideMomentum;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private static final double DRIFT = 0.004;
    private static final double ASCEND = -0.04;
    private static final double OFFSET = 2.5;
    private static final float HEAD_TURN_ANGLE = 120.0f;
    private static final double DECAY_MOMENTUM = 0.97;
    private static boolean ascendMode;

    public EntityParachute(World world) {
        super(world);
        this.lavaDistance = ConfigHandler.getMinLavaDistance();
        this.allowThermals = ConfigHandler.getAllowThermals();
        this.maxAltitude = ConfigHandler.getMaxAltitude();
        this.lavaThermals = ConfigHandler.getAllowLavaThermals();
        this.dismountInWater = ConfigHandler.getDismountInWater();
        this.maxLavaDistance = ConfigHandler.getMaxLavaDistance();
        this.forwardMomentum = ConfigHandler.getForwardMomentum();
        this.backMomentum = ConfigHandler.getBackMomentum();
        this.rotationMomentum = ConfigHandler.getRotationMomentum();
        this.slideMomentum = ConfigHandler.getSlideMomentum();
        this.curLavaDistance = this.lavaDistance;
        this.field_70170_p = world;
        this.field_70156_m = true;
        float SCALE = 0.0625f;
        this.func_70105_a(3.25f, SCALE);
        ascendMode = false;
        this.updateBlocked = false;
        this.func_174810_b(false);
    }

    public EntityParachute(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public boolean canRiderInteract() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity != this.func_184179_bs() && entity.func_184187_bx() != this) {
            return entity.func_174813_aQ();
        }
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean shouldRiderSit() {
        Entity skyDiver = this.func_184179_bs();
        boolean sitting = false;
        if (skyDiver != null) {
            BlockPos bp = new BlockPos(skyDiver.field_70165_t, skyDiver.func_174813_aQ().field_72338_b - 3.0, skyDiver.field_70161_v);
            sitting = this.field_70170_p.func_180495_p(bp).func_177230_c() != Blocks.field_150350_a;
        }
        return sitting;
    }

    @Nonnull
    public EnumFacing func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    public boolean func_184186_bw() {
        return true;
    }

    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean shouldDismountInWater(Entity pilot) {
        return this.dismountInWater;
    }

    public double func_70042_X() {
        return -2.5;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int inc, boolean teleport) {
        double deltaX = x - this.field_70165_t;
        double deltaY = y - this.field_70163_u;
        double deltaZ = z - this.field_70161_v;
        double magnitude = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        if (magnitude <= 1.0) {
            return;
        }
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        this.velocityX = this.field_70159_w;
        this.velocityY = this.field_70181_x;
        this.velocityZ = this.field_70179_y;
    }

    public void updateInputs(MovementInput input) {
        if (this.func_184207_aI() && this.field_70170_p.field_72995_K) {
            double motionFactor = 0.0;
            String steeringControl = ConfigHandler.getSteeringControl();
            if (input.field_187255_c) {
                motionFactor += this.forwardMomentum;
            }
            if (input.field_187256_d) {
                motionFactor -= this.backMomentum;
            }
            if (steeringControl.equals("WASD")) {
                if (input.field_187257_e) {
                    this.deltaRotation += -this.rotationMomentum;
                }
                if (input.field_187258_f) {
                    this.deltaRotation += this.rotationMomentum;
                }
                if (input.field_187258_f != input.field_187257_e && !input.field_187255_c && !input.field_187256_d) {
                    motionFactor += this.slideMomentum;
                }
            }
            ascendMode = input.field_78901_c;
            this.field_70181_x -= this.currentDescentRate();
            if (steeringControl.equals("WASD")) {
                this.field_70177_z = (float)((double)this.field_70177_z + this.deltaRotation);
            } else {
                Entity skyDiver = this.func_184179_bs();
                if (skyDiver instanceof EntityLivingBase) {
                    EntityLivingBase pilot = (EntityLivingBase)skyDiver;
                    this.field_70177_z = (float)((double)pilot.field_70177_z + (double)(-pilot.field_70702_br) * 90.0);
                }
            }
            this.field_70159_w += (double)MathHelper.func_76126_a((float)((float)Math.toRadians(-this.field_70177_z))) * motionFactor;
            this.field_70179_y += (double)MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z))) * motionFactor;
            if ((ConfigHandler.getWeatherAffectsDrift() && this.isBadWeather() || this.allowTurbulence) && this.field_70146_Z.nextBoolean()) {
                this.applyTurbulence(this.field_70170_p.func_72911_I());
            }
        }
    }

    public void func_70071_h_() {
        Entity skyDiver = this.func_184179_bs();
        if (skyDiver == null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            return;
        }
        if (this.showContrails && skyDiver != null) {
            this.generateContrails(ascendMode);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        super.func_70071_h_();
        if (this.allowThermals && ascendMode && skyDiver != null) {
            skyDiver.func_184185_a(Parachute.LIFTCHUTE, ClientConfiguration.getBurnVolume(), 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }
        this.field_70159_w *= 0.97;
        this.field_70181_x *= this.field_70181_x < 0.0 ? 0.96 : 0.98;
        this.field_70179_y *= 0.97;
        this.deltaRotation *= 0.9;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K && skyDiver != null && skyDiver.field_70128_L) {
            skyDiver.func_184210_p();
        }
        if (skyDiver != null) {
            double dX = this.field_70165_t - this.field_70169_q;
            double dZ = this.field_70161_v - this.field_70166_s;
            int distance = Math.round(MathHelper.func_76133_a((double)(dX * dX + dZ * dZ)) * 100.0f);
            if (skyDiver instanceof EntityPlayer) {
                ((EntityPlayer)skyDiver).func_71064_a((StatBase)Parachute.parachuteDistance, distance);
            }
        }
        this.func_145775_I();
    }

    private boolean isBadWeather() {
        BlockPos bp = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Chunk chunk = this.field_70170_p.func_175726_f(bp);
        boolean canSnow = chunk.func_177411_a(bp, this.field_70170_p.field_73011_w.func_177499_m()).func_76746_c();
        boolean canRain = chunk.func_177411_a(bp, this.field_70170_p.field_73011_w.func_177499_m()).func_76727_i() > 0.0f;
        return !(!canRain && !canSnow || !this.field_70170_p.func_72896_J() && !this.field_70170_p.func_72911_I());
    }

    private double currentDescentRate() {
        double descentRate = 0.004;
        if (ConfigHandler.getWeatherAffectsDrift()) {
            if (this.field_70170_p.func_72896_J()) {
                descentRate += 0.002;
            }
            if (this.field_70170_p.func_72911_I()) {
                descentRate += 0.004;
            }
        }
        if (this.lavaThermals) {
            descentRate = this.doHeatSourceThermals();
            if (!this.allowThermals) {
                return descentRate;
            }
        }
        if (this.allowThermals && ascendMode) {
            descentRate = -0.04;
        }
        if (this.maxAltitude > 0.0 && this.field_70163_u >= this.maxAltitude) {
            descentRate = 0.004;
        }
        return descentRate;
    }

    private boolean isHeatSource(BlockPos bp) {
        return this.field_70170_p.func_147470_e(new AxisAlignedBB(bp).func_72321_a(0.0, 1.0, 0.0));
    }

    private boolean isHeatSourceInRange(BlockPos bp) {
        Vec3d v1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d v2 = new Vec3d((double)bp.func_177958_n(), (double)bp.func_177956_o(), (double)bp.func_177952_p());
        RayTraceResult mop = this.field_70170_p.func_72901_a(v1, v2, true);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = mop.func_178782_a();
            return this.isHeatSource(blockpos);
        }
        return false;
    }

    private double doHeatSourceThermals() {
        double thermals = 0.004;
        double inc = 0.5;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.field_70163_u - 2.5 - this.maxLavaDistance, this.field_70161_v);
        if (this.isHeatSourceInRange(blockPos)) {
            this.curLavaDistance += 0.5;
            thermals = -0.04;
            if (this.curLavaDistance >= this.maxLavaDistance) {
                this.curLavaDistance = this.lavaDistance;
                thermals = 0.004;
            }
        } else {
            this.curLavaDistance = this.lavaDistance;
        }
        return thermals;
    }

    private void applyTurbulence(boolean roughWeather) {
        double rmin = 0.1;
        double deltaPos = rmin + 0.9 * this.field_70146_Z.nextDouble();
        if (deltaPos >= 0.2) {
            double rmax = roughWeather ? 0.8 : 0.5;
            rmax = this.field_70146_Z.nextInt(5) == 0 ? 1.0 : rmax;
            double deltaX = rmin + (rmax - rmin) * this.field_70146_Z.nextDouble();
            double deltaY = rmin + 0.2 * this.field_70146_Z.nextDouble();
            double deltaZ = rmin + (rmax - rmin) * this.field_70146_Z.nextDouble();
            deltaPos = MathHelper.func_76133_a((double)deltaPos);
            double deltaInv = 1.0 / deltaPos;
            deltaX /= deltaPos;
            deltaY /= deltaPos;
            deltaZ /= deltaPos;
            deltaInv = deltaInv > 1.0 ? 1.0 : deltaInv;
            deltaX *= deltaInv;
            deltaY *= deltaInv;
            deltaZ *= deltaInv;
            deltaX *= 0.05;
            deltaY *= 0.05;
            deltaZ *= 0.05;
            if (this.field_70146_Z.nextBoolean()) {
                this.func_70024_g(-deltaX, -deltaY, -deltaZ);
            } else {
                this.func_70024_g(deltaX, deltaY, deltaZ);
            }
        }
    }

    private void generateContrails(boolean ascending) {
        double velocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        double cosYaw = 2.25 * Math.cos(Math.toRadians(90.0 + (double)this.field_70177_z));
        double sinYaw = 2.25 * Math.sin(Math.toRadians(90.0 + (double)this.field_70177_z));
        int k = 0;
        while ((double)k < 1.0 + velocity) {
            double sign = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
            double x = this.field_70165_t + (this.field_70165_t - this.field_70169_q) + cosYaw * -0.45 + sinYaw * sign;
            double y = this.field_70163_u - 0.25;
            double z = this.field_70161_v + (this.field_70161_v - this.field_70166_s) + sinYaw * -0.45 - cosYaw * sign;
            if (ascending) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, x, y, z, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            if (!ascending && velocity > 0.01) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, x, y, z, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            ++k;
        }
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float offset = (float)((this.field_70128_L ? 0.01 : this.func_70042_X()) + passenger.func_70033_W());
            Vec3d vec3d = new Vec3d(0.0, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)offset, this.field_70161_v + vec3d.field_72449_c);
            passenger.field_70177_z = (float)((double)passenger.field_70177_z + this.deltaRotation);
            passenger.func_70034_d(passenger.func_70079_am() + (float)this.deltaRotation);
            this.applyYawToEntity(passenger);
            AxisAlignedBB bb = passenger.func_174813_aQ();
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72829_c(bb)) {
                if (this.field_70170_p.func_72875_a(bb, Material.field_151586_h)) {
                    if (ConfigHandler.getDismountInWater()) {
                        passenger.func_184210_p();
                    } else {
                        BlockPos bp = new BlockPos(passenger.field_70165_t, passenger.field_70163_u, passenger.field_70161_v);
                        bp.func_177979_c(Math.round((float)bb.field_72338_b));
                        if (!this.field_70170_p.func_180495_p(bp).isSideSolid((IBlockAccess)this.field_70170_p, bp, EnumFacing.UP)) {
                            return;
                        }
                    }
                } else {
                    if (this.field_70170_p.func_72875_a(bb, Material.field_151584_j)) {
                        return;
                    }
                    if (this.field_70170_p.func_72875_a(bb, Material.field_151582_l)) {
                        BlockPos bp = new BlockPos(passenger.field_70165_t, passenger.field_70163_u, passenger.field_70161_v);
                        bp.func_177979_c(Math.round((float)bb.field_72338_b));
                        if (!this.field_70170_p.func_180495_p(bp).isSideSolid((IBlockAccess)this.field_70170_p, bp, EnumFacing.UP)) {
                            return;
                        }
                    }
                }
                passenger.func_184210_p();
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float yaw = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float yawClamp = MathHelper.func_76131_a((float)yaw, (float)-120.0f, (float)120.0f);
        entityToUpdate.field_70126_B += yawClamp - yaw;
        entityToUpdate.field_70177_z += yawClamp - yaw;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
    }

    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
    }
}

