/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.client;

import com.parachute.client.ClientConfiguration;
import com.parachute.common.EntityParachute;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HudCompassRenderer
extends Gui {
    protected static final ResourceLocation COMPASS_TEXTURE = new ResourceLocation("parachutemod:textures/gui/hud-compass.png");
    protected static final ResourceLocation HOME_TEXTURE = new ResourceLocation("parachutemod:textures/gui/hud-home.png");
    protected static final ResourceLocation RETICULE2_TEXTURE = new ResourceLocation("parachutemod:textures/gui/hud-reticule2.png");
    protected static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("parachutemod:textures/gui/hud-background.png");
    protected static final ResourceLocation NIGHT_TEXTURE = new ResourceLocation("parachutemod:textures/gui/hud-night.png");
    private static final int MOON_RISE = 12600;
    private static final int SUN_RISE = 22900;
    private static final int MAX_TICKS = 24000;
    private static final int COLOR_RED = -65536;
    private static final int COLOR_GREEN = -16711936;
    private static final int COLOR_YELLOW = -256;
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private static FontRenderer fontRenderer = HudCompassRenderer.MINECRAFT.field_71466_p;
    public static double altitude;
    private static boolean isVisible;
    private static int count;
    private static final int HUD_WIDTH = 256;
    private static final int HUD_HEIGHT = 256;
    private static final int Y_PADDING = 120;
    private static final int X_PADDING = 20;
    double compassHeading;
    private String alt;
    private String compass;
    private String dist;

    @SubscribeEvent
    public void drawCompassHUD(RenderGameOverlayEvent.Post event) {
        if (event.isCancelable() || HudCompassRenderer.MINECRAFT.field_71474_y.field_74330_P || HudCompassRenderer.MINECRAFT.field_71439_g.field_70122_E) {
            return;
        }
        if (!isVisible || !HudCompassRenderer.MINECRAFT.field_71474_y.field_74353_u) {
            return;
        }
        if (HudCompassRenderer.MINECRAFT.field_71415_G && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ScaledResolution sr = new ScaledResolution(MINECRAFT);
            int width = sr.func_78326_a() * sr.func_78325_e();
            String position = ClientConfiguration.getHudPosition();
            if (position == null) {
                return;
            }
            int hudX = position.equals("left") ? 20 : (position.equals("center") ? (width - 256) / 2 : width - 256 - 20);
            int textX = hudX + 128;
            int textY = 248;
            if (HudCompassRenderer.MINECRAFT.field_71439_g.func_184187_bx() instanceof EntityParachute) {
                EntityParachute chute = (EntityParachute)HudCompassRenderer.MINECRAFT.field_71439_g.func_184187_bx();
                if (chute == null) {
                    return;
                }
                boolean unicodeFlag = fontRenderer.func_82883_a();
                fontRenderer.func_78264_a(true);
                BlockPos entityPos = new BlockPos(HudCompassRenderer.MINECRAFT.field_71439_g.field_70165_t, HudCompassRenderer.MINECRAFT.field_71439_g.func_174813_aQ().field_72338_b, HudCompassRenderer.MINECRAFT.field_71439_g.field_70161_v);
                altitude = this.getCurrentAltitude(entityPos);
                double homeDir = this.getHomeDirection(chute.field_70177_z);
                double distance = this.getHomeDistance();
                this.compassHeading = this.calcCompassHeading(chute.field_70177_z);
                boolean aadActive = ClientConfiguration.getAADState();
                GlStateManager.func_179094_E();
                GlStateManager.func_179091_B();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
                if (this.isNightTime()) {
                    this.drawTextureFixed(NIGHT_TEXTURE, hudX);
                }
                this.drawTextureFixed(BACKGROUND_TEXTURE, hudX);
                this.drawTextureWithRotation((float)(-this.compassHeading), COMPASS_TEXTURE, hudX);
                this.drawTextureWithRotation((float)homeDir, HOME_TEXTURE, hudX);
                this.drawTextureFixed(RETICULE2_TEXTURE, hudX);
                if (count % 10 == 0) {
                    this.alt = this.formatBold(altitude);
                    this.compass = this.formatBold(this.compassHeading);
                    this.dist = this.formatBold(distance);
                }
                ++count;
                GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
                int hFont = HudCompassRenderer.fontRenderer.field_78288_b;
                this.func_73732_a(fontRenderer, this.compass, textX /= 2, (textY /= 2) - hFont * 2 - 2, -16711936);
                this.func_73732_a(fontRenderer, this.alt, textX, textY - hFont, this.colorAltitude());
                this.func_73732_a(fontRenderer, this.dist, textX, textY + 2, -16711936);
                this.func_73732_a(fontRenderer, "\u00a7lAUTO", textX, textY + hFont + 4, aadActive ? -16711936 : -65536);
                GlStateManager.func_179101_C();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
                fontRenderer.func_78264_a(unicodeFlag);
            }
        }
    }

    private boolean isNightTime() {
        long ticks = HudCompassRenderer.MINECRAFT.field_71441_e.func_72820_D() % 24000L;
        return ticks > 12600L && ticks < 22900L;
    }

    private void drawTextureFixed(ResourceLocation texture, int screenX) {
        GlStateManager.func_179094_E();
        MINECRAFT.func_110434_K().func_110577_a(texture);
        this.func_73729_b(screenX, 120, 0, 0, 256, 256);
        GlStateManager.func_179121_F();
    }

    private void drawTextureWithRotation(float degrees, ResourceLocation texture, int screenX) {
        GlStateManager.func_179094_E();
        float tx = (float)screenX + 128.0f;
        float ty = 248.0f;
        GlStateManager.func_179109_b((float)tx, (float)ty, (float)0.0f);
        GlStateManager.func_179114_b((float)degrees, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-tx), (float)(-ty), (float)0.0f);
        MINECRAFT.func_110434_K().func_110577_a(texture);
        this.func_73729_b(screenX, 120, 0, 0, 256, 256);
        GlStateManager.func_179121_F();
    }

    private String formatBold(double d) {
        return String.format("\u00a7l%.1f", d);
    }

    private double calcCompassHeading(double yaw) {
        return ((yaw + 180.0) % 360.0 + 360.0) % 360.0;
    }

    private double getHomeDirection(double yaw) {
        BlockPos blockpos = HudCompassRenderer.MINECRAFT.field_71441_e.func_175694_M();
        double delta = Math.atan2((double)blockpos.func_177952_p() - HudCompassRenderer.MINECRAFT.field_71439_g.field_70161_v, (double)blockpos.func_177958_n() - HudCompassRenderer.MINECRAFT.field_71439_g.field_70165_t);
        double relAngle = delta - Math.toRadians(yaw);
        return MathHelper.func_76138_g((double)(Math.toDegrees(relAngle) - 90.0));
    }

    private double getHomeDistance() {
        BlockPos blockpos = HudCompassRenderer.MINECRAFT.field_71441_e.func_175694_M();
        double a = Math.pow((double)blockpos.func_177952_p() - HudCompassRenderer.MINECRAFT.field_71439_g.field_70161_v, 2.0);
        double b = Math.pow((double)blockpos.func_177958_n() - HudCompassRenderer.MINECRAFT.field_71439_g.field_70165_t, 2.0);
        return Math.sqrt(a + b);
    }

    private int colorAltitude() {
        return altitude <= 10.0 ? -65536 : (altitude <= 15.0 ? -256 : -16711936);
    }

    private double getCurrentAltitude(BlockPos entityPos) {
        if (HudCompassRenderer.MINECRAFT.field_71441_e.field_73011_w.func_76569_d()) {
            BlockPos blockPos = new BlockPos(entityPos.func_177958_n(), entityPos.func_177956_o(), entityPos.func_177952_p());
            while (HudCompassRenderer.MINECRAFT.field_71441_e.func_175623_d(blockPos.func_177977_b())) {
                blockPos = blockPos.func_177977_b();
            }
            return entityPos.func_177956_o() - blockPos.func_177956_o();
        }
        return 1000.0 * HudCompassRenderer.MINECRAFT.field_71441_e.field_73012_v.nextGaussian();
    }

    public static void toggleHUDVisibility() {
        isVisible = !isVisible;
    }

    static {
        isVisible = true;
        count = 0;
    }
}

