/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.worldgen;

import com.cout970.magneticraft.misc.vector.Vec2d;
import com.cout970.magneticraft.systems.config.OreConfig;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ@\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015J&\u0010 \u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/cout970/magneticraft/systems/worldgen/OreGenerator;", "Lnet/minecraftforge/fml/common/IWorldGenerator;", "ore", "Lnet/minecraft/block/state/IBlockState;", "config", "Lcom/cout970/magneticraft/systems/config/OreConfig;", "(Lnet/minecraft/block/state/IBlockState;Lcom/cout970/magneticraft/systems/config/OreConfig;)V", "predicate", "Lcom/google/common/base/Predicate;", "(Lnet/minecraft/block/state/IBlockState;Lcom/google/common/base/Predicate;Lcom/cout970/magneticraft/systems/config/OreConfig;)V", "getConfig", "()Lcom/cout970/magneticraft/systems/config/OreConfig;", "getOre", "()Lnet/minecraft/block/state/IBlockState;", "getPredicate", "()Lcom/google/common/base/Predicate;", "generate", "", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "x", "y", "z", "generateChunkOres", "pos", "Lcom/cout970/magneticraft/misc/vector/Vec2d;", "chunkAmount", "Companion", "Magneticraft_1.12"})
public class OreGenerator
implements IWorldGenerator {
    @NotNull
    private final IBlockState ore;
    @NotNull
    private final Predicate<IBlockState> predicate;
    @NotNull
    private final OreConfig config;
    public static final Companion Companion = new Companion(null);

    public void generate(@Nullable Random random, int chunkX, int chunkZ, @Nullable World world, @Nullable IChunkGenerator chunkGenerator, @Nullable IChunkProvider chunkProvider) {
        if (world == null || random == null) {
            return;
        }
        List list = CollectionsKt.listOf((Object[])new Integer[]{1, -1});
        WorldProvider worldProvider = world.field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
        if (list.contains(worldProvider.getDimension())) {
            return;
        }
        if (this.config.getActive()) {
            this.generateChunkOres(world, new Vec2d((Number)chunkX, (Number)chunkZ), random, this.config.getChunkAmount());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void generateChunkOres(@NotNull World world, @NotNull Vec2d pos, @NotNull Random random, int chunkAmount) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        int n = 0;
        int n2 = chunkAmount;
        while (n < n2) {
            void k;
            int x = pos.getXi() * 16 + random.nextInt(16);
            int y = this.config.getMinLevel() + random.nextInt(this.config.getMaxLevel() - this.config.getMinLevel());
            int z = pos.getYi() * 16 + random.nextInt(16);
            this.generate(world, random, x, y, z);
            ++k;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void generate(@NotNull World world, @NotNull Random random, int x, int y, int z) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        float angle = random.nextFloat() * (float)Math.PI;
        double posX = (double)(x + 8) + Math.sin(angle) * (double)this.config.getVeinAmount() / (double)8.0f;
        double negX = (double)(x + 8) - Math.sin(angle) * (double)this.config.getVeinAmount() / (double)8.0f;
        double posZ = (double)(z + 8) + Math.cos(angle) * (double)this.config.getVeinAmount() / (double)8.0f;
        double negZ = (double)(z + 8) - Math.cos(angle) * (double)this.config.getVeinAmount() / (double)8.0f;
        double y1 = y + random.nextInt(3) - 2;
        double y2 = y + random.nextInt(3) - 2;
        int n = 0;
        int n2 = this.config.getVeinAmount();
        while (n < n2) {
            void n3;
            double xPlace = posX + (negX - posX) * (double)n3 / (double)this.config.getVeinAmount();
            double yPlace = y1 + (y2 - y1) * (double)n3 / (double)this.config.getVeinAmount();
            double zPlace = posZ + (negZ - posZ) * (double)n3 / (double)this.config.getVeinAmount();
            double scale = random.nextDouble() * (double)this.config.getVeinAmount() / 16.0;
            double desp = (Math.sin((double)n3 * Math.PI / (double)this.config.getVeinAmount()) + (double)1.0f) * scale + 1.0;
            int minX = Companion.floorDouble(xPlace - desp / 2.0);
            int minY = Companion.floorDouble(yPlace - desp / 2.0);
            int minZ = Companion.floorDouble(zPlace - desp / 2.0);
            int maxX = Companion.floorDouble(xPlace + desp / 2.0);
            int maxY = Companion.floorDouble(yPlace + desp / 2.0);
            int maxZ = Companion.floorDouble(zPlace + desp / 2.0);
            int n4 = minX;
            int n5 = maxX;
            while (n4 < n5) {
                void i;
                double xDistance = ((double)i + 0.5 - xPlace) / (desp / 2.0);
                if (xDistance * xDistance < 1.0) {
                    int n6 = minY;
                    int n7 = maxY;
                    while (n6 < n7) {
                        void j;
                        double yDistance = ((double)j + 0.5 - yPlace) / (desp / 2.0);
                        if (xDistance * xDistance + yDistance * yDistance < 1.0) {
                            int n8 = minZ;
                            int n9 = maxZ;
                            while (n8 < n9) {
                                void k;
                                double zDistance = ((double)k + 0.5 - zPlace) / (desp / 2.0);
                                BlockPos blockPos = new BlockPos((int)i, (int)j, (int)k);
                                if (xDistance * xDistance + yDistance * yDistance + zDistance * zDistance < 1.0) {
                                    IBlockState state;
                                    IBlockState iBlockState = state = world.func_180495_p(blockPos);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
                                    if (iBlockState.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, blockPos, this.predicate)) {
                                        world.func_180501_a(blockPos, this.ore, 2);
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++n3;
        }
    }

    @NotNull
    public final IBlockState getOre() {
        return this.ore;
    }

    @NotNull
    public final Predicate<IBlockState> getPredicate() {
        return this.predicate;
    }

    @NotNull
    public final OreConfig getConfig() {
        return this.config;
    }

    public OreGenerator(@NotNull IBlockState ore, @NotNull Predicate<IBlockState> predicate, @NotNull OreConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)ore, (String)"ore");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.ore = ore;
        this.predicate = predicate;
        this.config = config;
    }

    public OreGenerator(@NotNull IBlockState ore, @NotNull OreConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)ore, (String)"ore");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this(ore, (Predicate<IBlockState>)((Predicate)1.INSTANCE), config);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cout970/magneticraft/systems/worldgen/OreGenerator$Companion;", "", "()V", "floorDouble", "", "value", "", "Magneticraft_1.12"})
    public static final class Companion {
        public final int floorDouble(double value2) {
            int i = (int)value2;
            return value2 < (double)i ? i - 1 : i;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

