/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules.pipe;

import com.cout970.magneticraft.systems.tilemodules.pipe.INetworkNode;
import com.cout970.magneticraft.systems.tilemodules.pipe.IPathFindingNode;
import com.cout970.magneticraft.systems.tilemodules.pipe.Network;
import com.cout970.magneticraft.systems.tilemodules.pipe.PathFinderKt;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u0000 \u001f*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001fBK\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\"\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006j\u0002`\u000b\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\r\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0018H&J\u0006\u0010\u001c\u001a\u00020\u0018J\u0013\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aR#\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R-\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006j\u0002`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/pipe/Network;", "T", "Lcom/cout970/magneticraft/systems/tilemodules/pipe/INetworkNode;", "", "mainNode", "inspectFunc", "Lkotlin/Function2;", "Lnet/minecraft/tileentity/TileEntity;", "Lnet/minecraft/util/EnumFacing;", "", "Lcom/cout970/magneticraft/systems/tilemodules/pipe/IPathFindingNode;", "Lcom/cout970/magneticraft/systems/tilemodules/pipe/InspectFunc;", "factory", "Lkotlin/Function1;", "(Lcom/cout970/magneticraft/systems/tilemodules/pipe/INetworkNode;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "getFactory", "()Lkotlin/jvm/functions/Function1;", "getInspectFunc", "()Lkotlin/jvm/functions/Function2;", "members", "", "getMembers", "()Ljava/util/Set;", "add", "", "node", "(Lcom/cout970/magneticraft/systems/tilemodules/pipe/INetworkNode;)V", "clearCache", "expand", "remove", "split", "Companion", "Magneticraft_1.12"})
public abstract class Network<T extends INetworkNode> {
    @NotNull
    private final Set<T> members;
    @NotNull
    private final Function2<TileEntity, EnumFacing, List<IPathFindingNode>> inspectFunc;
    @NotNull
    private final Function1<T, Network<T>> factory;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Set<T> getMembers() {
        return this.members;
    }

    public final void add(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        Companion.setNetwork(node, this);
        this.members.add(node);
        this.clearCache();
    }

    public final void remove(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        this.members.remove(node);
        this.clearCache();
    }

    public final void split(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        this.clearCache();
        List remaining = CollectionsKt.toMutableList((Collection)SetsKt.minus(this.members, node));
        Iterable $this$forEach$iv = remaining;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            INetworkNode it = (INetworkNode)element$iv;
            boolean bl = false;
            it.setNetwork(null);
        }
        while ((INetworkNode)CollectionsKt.firstOrNull((List)remaining) != null) {
            INetworkNode it;
            Network net = (Network)this.factory.invoke((Object)it);
            Companion.setNetwork(node, net);
            net.expand();
            CollectionsKt.removeAll((List)remaining, (Function1)split.2.INSTANCE);
        }
        return;
    }

    public final void expand() {
        this.clearCache();
        INetworkNode iNetworkNode = (INetworkNode)CollectionsKt.firstOrNull((Iterable)this.members);
        if (iNetworkNode == null) {
            return;
        }
        INetworkNode first = iNetworkNode;
        List<IPathFindingNode> results = PathFinderKt.nearestFirstSearch(first, this.inspectFunc);
        Iterable $this$forEach$iv = results;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPathFindingNode it = (IPathFindingNode)element$iv;
            boolean bl = false;
            IPathFindingNode iPathFindingNode = it;
            if (iPathFindingNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            this.add((INetworkNode)iPathFindingNode);
        }
    }

    public abstract void clearCache();

    @NotNull
    public final Function2<TileEntity, EnumFacing, List<IPathFindingNode>> getInspectFunc() {
        return this.inspectFunc;
    }

    @NotNull
    public final Function1<T, Network<T>> getFactory() {
        return this.factory;
    }

    public Network(@NotNull T mainNode, @NotNull Function2<? super TileEntity, ? super EnumFacing, ? extends List<? extends IPathFindingNode>> inspectFunc, @NotNull Function1<? super T, ? extends Network<T>> factory) {
        Intrinsics.checkParameterIsNotNull(mainNode, (String)"mainNode");
        Intrinsics.checkParameterIsNotNull(inspectFunc, (String)"inspectFunc");
        Intrinsics.checkParameterIsNotNull(factory, (String)"factory");
        this.inspectFunc = inspectFunc;
        this.factory = factory;
        this.members = SetsKt.mutableSetOf((Object[])new INetworkNode[]{mainNode});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/pipe/Network$Companion;", "", "()V", "setNetwork", "", "T", "Lcom/cout970/magneticraft/systems/tilemodules/pipe/INetworkNode;", "node", "net", "Lcom/cout970/magneticraft/systems/tilemodules/pipe/Network;", "(Lcom/cout970/magneticraft/systems/tilemodules/pipe/INetworkNode;Lcom/cout970/magneticraft/systems/tilemodules/pipe/Network;)V", "Magneticraft_1.12"})
    public static final class Companion {
        public final <T extends INetworkNode> void setNetwork(@NotNull T node, @Nullable Network<T> net) {
            Intrinsics.checkParameterIsNotNull(node, (String)"node");
            if (Intrinsics.areEqual(node.getNetwork(), net) ^ true) {
                Network<?> network = node.getNetwork();
                if (!(network instanceof Network)) {
                    network = null;
                }
                if (network != null) {
                    network.remove(node);
                }
            }
            node.setNetwork(net);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

