/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.features.electric_machines.Blocks;
import com.cout970.magneticraft.features.electric_machines.TileWindTurbineGap;
import com.cout970.magneticraft.misc.NBTKt;
import com.cout970.magneticraft.misc.gui.ValueAverage;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import com.cout970.magneticraft.misc.vector.EnumFacingKt;
import com.cout970.magneticraft.systems.config.Config;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 P2\u00020\u0001:\u0001PB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u00106\u001a\u00020!J\u0006\u00107\u001a\u00020!J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0016J\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020!2\u0006\u0010B\u001a\u00020CJ\u001d\u0010D\u001a\u0002092\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u0002090FH\u0086\bJ\b\u0010G\u001a\u000209H\u0016J\u0006\u0010H\u001a\u000209J\u0010\u0010I\u001a\u0002092\b\b\u0002\u0010J\u001a\u00020!J\b\u0010K\u001a\u00020;H\u0016J\b\u0010L\u001a\u000209H\u0016J\u0006\u0010M\u001a\u000209J\u0006\u0010N\u001a\u000209J\u0006\u0010O\u001a\u000209R\u001a\u0010\n\u001a\u00020\u000bX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010)\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0016R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0016\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0016\"\u0004\b5\u00102\u00a8\u0006Q"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleWindTurbine;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "electricNode", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "facingGetter", "Lkotlin/Function0;", "Lnet/minecraft/util/EnumFacing;", "name", "", "(Lcom/cout970/magneticraft/api/energy/IElectricNode;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "counter", "", "<set-?>", "", "currentWind", "getCurrentWind", "()F", "getElectricNode", "()Lcom/cout970/magneticraft/api/energy/IElectricNode;", "facingCache", "getFacingCache", "()Lnet/minecraft/util/EnumFacing;", "setFacingCache", "(Lnet/minecraft/util/EnumFacing;)V", "getFacingGetter", "()Lkotlin/jvm/functions/Function0;", "hasTurbineHitbox", "", "getHasTurbineHitbox", "()Z", "setHasTurbineHitbox", "(Z)V", "getName", "()Ljava/lang/String;", "nextWind", "openSpace", "getOpenSpace", "production", "Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "getProduction", "()Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "rotation", "getRotation", "setRotation", "(F)V", "rotationSpeed", "getRotationSpeed", "setRotationSpeed", "canPlaceTurbineHitbox", "checkTurbineHitbox", "deserializeNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "getGuiSyncVariables", "", "Lcom/cout970/magneticraft/misc/network/SyncVariable;", "getReplaceBlock", "Lnet/minecraft/block/state/IBlockState;", "isBlockValid", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "iterateHitbox", "func", "Lkotlin/Function1;", "onBreak", "placeTurbineHitbox", "removeTurbineHitbox", "centerBreaking", "serializeNBT", "update", "updateNextWind", "updateOpenSpace", "updateWind", "Companion", "Magneticraft_1.12"})
public final class ModuleWindTurbine
implements IModule {
    @NotNull
    public IModuleContainer container;
    private float openSpace;
    private float currentWind;
    @NotNull
    private EnumFacing facingCache;
    @NotNull
    private final ValueAverage production;
    private float nextWind;
    private int counter;
    private boolean hasTurbineHitbox;
    private float rotation;
    private float rotationSpeed;
    @NotNull
    private final IElectricNode electricNode;
    @NotNull
    private final Function0<EnumFacing> facingGetter;
    @NotNull
    private final String name;
    @NotNull
    private static final NoiseGeneratorPerlin windNoise;
    public static final Companion Companion;

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    public final float getOpenSpace() {
        return this.openSpace;
    }

    public final float getCurrentWind() {
        return this.currentWind;
    }

    @NotNull
    public final EnumFacing getFacingCache() {
        return this.facingCache;
    }

    public final void setFacingCache(@NotNull EnumFacing enumFacing) {
        Intrinsics.checkParameterIsNotNull((Object)enumFacing, (String)"<set-?>");
        this.facingCache = enumFacing;
    }

    @NotNull
    public final ValueAverage getProduction() {
        return this.production;
    }

    public final boolean getHasTurbineHitbox() {
        return this.hasTurbineHitbox;
    }

    public final void setHasTurbineHitbox(boolean bl) {
        this.hasTurbineHitbox = bl;
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final void setRotation(float f) {
        this.rotation = f;
    }

    public final float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public final void setRotationSpeed(float f) {
        this.rotationSpeed = f;
    }

    @Override
    public void update() {
        if (this.facingCache == EnumFacing.UP) {
            this.facingCache = (EnumFacing)this.facingGetter.invoke();
        }
        int n = this.counter;
        this.counter = n + 1;
        if (this.counter > 200) {
            this.counter = 0;
            this.updateOpenSpace();
            this.updateNextWind();
            World $this$isServer$iv = this.getWorld();
            boolean $i$f$isServer = false;
            if (!$this$isServer$iv.field_72995_K) {
                this.hasTurbineHitbox = this.checkTurbineHitbox();
                if (!this.hasTurbineHitbox && this.canPlaceTurbineHitbox()) {
                    this.placeTurbineHitbox();
                    this.hasTurbineHitbox = true;
                }
                this.getContainer().sendUpdateToNearPlayers();
            }
        }
        this.updateWind();
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            return;
        }
        if (this.hasTurbineHitbox && this.electricNode.getVoltage() < 125.0) {
            double power = Config.INSTANCE.getWindTurbineMaxProduction() * (double)this.openSpace * (double)this.currentWind * ((double)this.getPos().func_177956_o() / 256.0);
            this.electricNode.applyPower(power, false);
            this.production.plusAssign(power);
        }
        this.production.tick();
    }

    @NotNull
    public final IBlockState getReplaceBlock() {
        IBlockState iBlockState = Blocks.INSTANCE.getWindTurbineGap().func_176223_P();
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"Blocks.windTurbineGap.defaultState");
        return iBlockState;
    }

    public final boolean isBlockValid(@NotNull BlockPos blockPos) {
        TileWindTurbineGap tile;
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"blockPos");
        IBlockState state = this.getWorld().func_180495_p(blockPos);
        if (Intrinsics.areEqual((Object)state, (Object)this.getReplaceBlock()) ^ true) {
            return false;
        }
        World $this$getTile$iv = this.getWorld();
        boolean $i$f$getTile = false;
        TileEntity tile$iv = $this$getTile$iv.func_175625_s(blockPos);
        TileEntity tileEntity = tile$iv;
        if (!(tileEntity instanceof TileWindTurbineGap)) {
            tileEntity = null;
        }
        return (tile = (TileWindTurbineGap)tileEntity) != null && !(Intrinsics.areEqual((Object)tile.getCenterPos(), (Object)this.getPos()) ^ true);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkTurbineHitbox() {
        boolean formed = true;
        ModuleWindTurbine this_$iv = this;
        boolean $i$f$iterateHitbox = false;
        EnumFacing facing$iv = this_$iv.getFacingCache();
        int n = -5;
        int n2 = 5;
        while (n <= n2) {
            void i$iv;
            int n3 = -5;
            int n4 = 5;
            while (n3 <= n4) {
                void j$iv;
                void dist$iv = i$iv * i$iv + j$iv * j$iv;
                if (dist$iv < 35) {
                    BlockPos offset$iv;
                    BlockPos base = offset$iv = EnumFacingKt.rotatePoint$default(facing$iv, null, new BlockPos((int)i$iv, (int)j$iv, -1), 1, null);
                    boolean bl = false;
                    BlockPos blockPos = BlockPosKt.plus(this.getPos(), base);
                    if (!this.isBlockValid(blockPos)) {
                        formed = false;
                    }
                }
                ++j$iv;
            }
            ++i$iv;
        }
        return formed;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean canPlaceTurbineHitbox() {
        boolean canPlace = true;
        ModuleWindTurbine this_$iv = this;
        boolean $i$f$iterateHitbox = false;
        EnumFacing facing$iv = this_$iv.getFacingCache();
        int n = -5;
        int n2 = 5;
        while (n <= n2) {
            void i$iv;
            int n3 = -5;
            int n4 = 5;
            while (n3 <= n4) {
                void j$iv;
                void dist$iv = i$iv * i$iv + j$iv * j$iv;
                if (dist$iv < 35) {
                    IBlockState state;
                    BlockPos offset$iv;
                    BlockPos base = offset$iv = EnumFacingKt.rotatePoint$default(facing$iv, null, new BlockPos((int)i$iv, (int)j$iv, -1), 1, null);
                    boolean bl = false;
                    BlockPos blockPos = BlockPosKt.plus(this.getPos(), base);
                    IBlockState iBlockState = state = this.getWorld().func_180495_p(blockPos);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
                    boolean replaceable2 = iBlockState.func_177230_c().func_176200_f((IBlockAccess)this.getWorld(), blockPos);
                    if (!replaceable2 && !this.isBlockValid(blockPos)) {
                        canPlace = false;
                    }
                }
                ++j$iv;
            }
            ++i$iv;
        }
        return canPlace;
    }

    /*
     * WARNING - void declaration
     */
    public final void placeTurbineHitbox() {
        ModuleWindTurbine this_$iv = this;
        boolean $i$f$iterateHitbox = false;
        EnumFacing facing$iv = this_$iv.getFacingCache();
        int n = -5;
        int n2 = 5;
        while (n <= n2) {
            void i$iv;
            int n3 = -5;
            int n4 = 5;
            while (n3 <= n4) {
                void j$iv;
                void dist$iv = i$iv * i$iv + j$iv * j$iv;
                if (dist$iv < 35) {
                    TileWindTurbineGap tile;
                    BlockPos offset$iv;
                    BlockPos base = offset$iv = EnumFacingKt.rotatePoint$default(facing$iv, null, new BlockPos((int)i$iv, (int)j$iv, -1), 1, null);
                    boolean bl = false;
                    BlockPos blockPos = BlockPosKt.plus(this.getPos(), base);
                    this.getWorld().func_175656_a(blockPos, this.getReplaceBlock());
                    World $this$getTile$iv = this.getWorld();
                    boolean $i$f$getTile = false;
                    TileEntity tile$iv = $this$getTile$iv.func_175625_s(blockPos);
                    TileEntity tileEntity = tile$iv;
                    if (!(tileEntity instanceof TileWindTurbineGap)) {
                        tileEntity = null;
                    }
                    TileWindTurbineGap tileWindTurbineGap = tile = (TileWindTurbineGap)tileEntity;
                    if (tileWindTurbineGap != null) {
                        tileWindTurbineGap.setCenterPos(this.getPos());
                    }
                }
                ++j$iv;
            }
            ++i$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeTurbineHitbox(boolean centerBreaking) {
        this.hasTurbineHitbox = false;
        ModuleWindTurbine this_$iv = this;
        boolean $i$f$iterateHitbox = false;
        EnumFacing facing$iv = this_$iv.getFacingCache();
        int n = -5;
        int n2 = 5;
        while (n <= n2) {
            void i$iv;
            int n3 = -5;
            int n4 = 5;
            while (n3 <= n4) {
                void j$iv;
                void dist$iv = i$iv * i$iv + j$iv * j$iv;
                if (dist$iv < 35) {
                    BlockPos offset$iv;
                    BlockPos base = offset$iv = EnumFacingKt.rotatePoint$default(facing$iv, null, new BlockPos((int)i$iv, (int)j$iv, -1), 1, null);
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)this.getWorld().func_180495_p(BlockPosKt.plus(this.getPos(), base)), (Object)this.getReplaceBlock())) {
                        this.getWorld().func_175698_g(BlockPosKt.plus(this.getPos(), base));
                    }
                }
                ++j$iv;
            }
            ++i$iv;
        }
        if (!centerBreaking) {
            this.getContainer().sendUpdateToNearPlayers();
        }
    }

    public static /* synthetic */ void removeTurbineHitbox$default(ModuleWindTurbine moduleWindTurbine, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        moduleWindTurbine.removeTurbineHitbox(bl);
    }

    public final void updateWind() {
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K && this.hasTurbineHitbox) {
            this.rotationSpeed = this.openSpace * this.currentWind * 5.0f;
            this.rotation += this.rotationSpeed;
        }
        if (this.currentWind != this.nextWind) {
            float diff = this.nextWind - this.currentWind;
            this.currentWind += diff * 0.01f;
        }
    }

    public final void updateNextWind() {
        double posNoise = windNoise.func_151601_a(BlockPosKt.getXd(this.getPos()) / 16.0, BlockPosKt.getZd(this.getPos()) / 16.0);
        double timeNoise = windNoise.func_151601_a((double)this.getWorld().func_82737_E(), BlockPosKt.getYd(this.getPos()));
        float noise = (float)(posNoise + timeNoise);
        this.nextWind = noise * 0.25f + 0.5f;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateOpenSpace() {
        int total = 0;
        int open = 0;
        EnumFacing facing = (EnumFacing)this.facingGetter.invoke();
        ModuleWindTurbine this_$iv = this;
        boolean $i$f$iterateHitbox = false;
        EnumFacing facing$iv = this_$iv.getFacingCache();
        int n = -5;
        int n2 = 5;
        while (n <= n2) {
            void i$iv;
            int n3 = -5;
            int n4 = 5;
            while (n3 <= n4) {
                void j$iv;
                void dist$iv = i$iv * i$iv + j$iv * j$iv;
                if (dist$iv < 35) {
                    BlockPos offset$iv;
                    BlockPos base = offset$iv = EnumFacingKt.rotatePoint$default(facing$iv, null, new BlockPos((int)i$iv, (int)j$iv, -1), 1, null);
                    boolean bl = false;
                    int dist = 0;
                    int n5 = 1;
                    int n6 = 16;
                    while (n5 <= n6) {
                        IBlockState state;
                        void k;
                        BlockPos offset = BlockPosKt.plus(EnumFacingKt.rotatePoint$default(facing, null, new BlockPos(0, 0, (int)(-k)), 1, null), base);
                        BlockPos worldPos = BlockPosKt.plus(this.getPos(), offset);
                        IBlockState iBlockState = state = this.getWorld().func_180495_p(worldPos);
                        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
                        if (iBlockState.func_185904_a().func_76230_c()) break;
                        dist = k++;
                    }
                    open += dist;
                    total += 16;
                }
                ++j$iv;
            }
            ++i$iv;
        }
        this.openSpace = (float)open / (float)total;
    }

    /*
     * WARNING - void declaration
     */
    public final void iterateHitbox(@NotNull Function1<? super BlockPos, Unit> func) {
        int $i$f$iterateHitbox = 0;
        Intrinsics.checkParameterIsNotNull(func, (String)"func");
        EnumFacing facing = this.getFacingCache();
        int n = -5;
        int n2 = 5;
        while (n <= n2) {
            void i;
            int n3 = -5;
            int n4 = 5;
            while (n3 <= n4) {
                void j;
                void dist = i * i + j * j;
                if (dist < 35) {
                    BlockPos offset = EnumFacingKt.rotatePoint$default(facing, null, new BlockPos((int)i, (int)j, -1), 1, null);
                    func.invoke((Object)offset);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void onBreak() {
        World $this$isServer$iv = this.getWorld();
        boolean $i$f$isServer = false;
        if (!$this$isServer$iv.field_72995_K) {
            this.removeTurbineHitbox(true);
        }
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return NBTKt.newNbt((Function1<? super NBTTagCompound, Unit>)((Function1)new Function1<NBTTagCompound, Unit>(this){
            final /* synthetic */ ModuleWindTurbine this$0;

            public final void invoke(@NotNull NBTTagCompound $this$newNbt) {
                Intrinsics.checkParameterIsNotNull((Object)$this$newNbt, (String)"$receiver");
                NBTKt.add($this$newNbt, "hasTurbine", this.this$0.getHasTurbineHitbox());
            }
            {
                this.this$0 = moduleWindTurbine;
                super(1);
            }
        }));
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        this.hasTurbineHitbox = nbt2.func_74767_n("hasTurbine");
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return CollectionsKt.listOf((Object)this.production.toSyncVariable(5));
    }

    @NotNull
    public final IElectricNode getElectricNode() {
        return this.electricNode;
    }

    @NotNull
    public final Function0<EnumFacing> getFacingGetter() {
        return this.facingGetter;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleWindTurbine(@NotNull IElectricNode electricNode, @NotNull Function0<? extends EnumFacing> facingGetter, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)electricNode, (String)"electricNode");
        Intrinsics.checkParameterIsNotNull(facingGetter, (String)"facingGetter");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.electricNode = electricNode;
        this.facingGetter = facingGetter;
        this.name = name;
        this.facingCache = EnumFacing.UP;
        this.production = new ValueAverage(0, 1, null);
        this.counter = 150;
    }

    public /* synthetic */ ModuleWindTurbine(IElectricNode iElectricNode, Function0 function0, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "module_steam_generator";
        }
        this(iElectricNode, (Function0<? extends EnumFacing>)function0, string);
    }

    static {
        Companion = new Companion(null);
        windNoise = new NoiseGeneratorPerlin(new Random(1234L), 1);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleWindTurbine$Companion;", "", "()V", "windNoise", "Lnet/minecraft/world/gen/NoiseGeneratorPerlin;", "getWindNoise", "()Lnet/minecraft/world/gen/NoiseGeneratorPerlin;", "Magneticraft_1.12"})
    public static final class Companion {
        @NotNull
        public final NoiseGeneratorPerlin getWindNoise() {
            return windNoise;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

