/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.api.core.INode;
import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.api.heat.IHeatNode;
import com.cout970.magneticraft.api.heat.IHeatNodeHandler;
import com.cout970.magneticraft.api.internal.registries.generators.thermopile.ThermopileRecipeManager;
import com.cout970.magneticraft.api.registries.generators.thermopile.IThermopileRecipe;
import com.cout970.magneticraft.misc.HeatKt;
import com.cout970.magneticraft.misc.NBTKt;
import com.cout970.magneticraft.misc.gui.ValueAverage;
import com.cout970.magneticraft.misc.network.AverageSyncVariable;
import com.cout970.magneticraft.misc.network.FloatSyncVariable;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.misc.tileentity.TileEntityKt;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.systems.config.Config;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u000201B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!J\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\u0016\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020\u001eH\u0016J\b\u0010.\u001a\u00020\u001cH\u0016J\u0006\u0010/\u001a\u00020\u001cR\u001a\u0010\u0007\u001a\u00020\bX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00062"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleThermopile;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "node", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "name", "", "(Lcom/cout970/magneticraft/api/energy/IElectricNode;Ljava/lang/String;)V", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "getName", "()Ljava/lang/String;", "getNode", "()Lcom/cout970/magneticraft/api/energy/IElectricNode;", "production", "Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "getProduction", "()Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "totalFlux", "", "getTotalFlux", "()F", "setTotalFlux", "(F)V", "deserializeNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "getFlux", "a", "Lcom/cout970/magneticraft/systems/tilemodules/ModuleThermopile$HeatSource;", "b", "getGeneratedPower", "", "getGuiSyncVariables", "", "Lcom/cout970/magneticraft/misc/network/SyncVariable;", "getSource", "pos", "Lnet/minecraft/util/math/BlockPos;", "side", "Lnet/minecraft/util/EnumFacing;", "serializeNBT", "update", "updateFlux", "DefaultHeatSource", "HeatSource", "Magneticraft_1.12"})
public final class ModuleThermopile
implements IModule {
    @NotNull
    public IModuleContainer container;
    private float totalFlux;
    @NotNull
    private final ValueAverage production;
    @NotNull
    private final IElectricNode node;
    @NotNull
    private final String name;

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    public final float getTotalFlux() {
        return this.totalFlux;
    }

    public final void setTotalFlux(float f) {
        this.totalFlux = f;
    }

    @NotNull
    public final ValueAverage getProduction() {
        return this.production;
    }

    @Override
    public void update() {
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            return;
        }
        if (TileEntityKt.shouldTick(this.getContainer(), 20)) {
            this.updateFlux();
        }
        if (this.node.getVoltage() < 125.0) {
            double energy = this.getGeneratedPower();
            this.node.applyPower(energy, false);
            this.production.plusAssign(energy);
        }
        this.production.tick();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateFlux() {
        void $this$mapTo$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)EnumFacing.field_82609_l, (String)"EnumFacing.VALUES");
        EnumFacing[] $this$map$iv = EnumFacing.field_82609_l;
        boolean $i$f$map = false;
        EnumFacing[] enumFacingArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_6 = $this$mapTo$iv$iv;
        int n = ((void)var7_6).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_10 = item$iv$iv = var7_6[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BlockPos blockPos = this.getPos();
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            BlockPos blockPos2 = BlockPosKt.plus(blockPos, (EnumFacing)v1);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos + it");
            Pair pair = TuplesKt.to((Object)it, (Object)this.getSource(blockPos2, (EnumFacing)it));
            collection.add(pair);
        }
        Map sources = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Object[] objectArray = new Float[15];
        Object v = sources.get(EnumFacing.DOWN);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource = (HeatSource)v;
        Object v2 = sources.get(EnumFacing.UP);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[0] = Float.valueOf(this.getFlux(heatSource, (HeatSource)v2));
        Object v3 = sources.get(EnumFacing.DOWN);
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource2 = (HeatSource)v3;
        Object v4 = sources.get(EnumFacing.NORTH);
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[1] = Float.valueOf(this.getFlux(heatSource2, (HeatSource)v4));
        Object v5 = sources.get(EnumFacing.DOWN);
        if (v5 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource3 = (HeatSource)v5;
        Object v6 = sources.get(EnumFacing.SOUTH);
        if (v6 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[2] = Float.valueOf(this.getFlux(heatSource3, (HeatSource)v6));
        Object v7 = sources.get(EnumFacing.DOWN);
        if (v7 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource4 = (HeatSource)v7;
        Object v8 = sources.get(EnumFacing.WEST);
        if (v8 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[3] = Float.valueOf(this.getFlux(heatSource4, (HeatSource)v8));
        Object v9 = sources.get(EnumFacing.DOWN);
        if (v9 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource5 = (HeatSource)v9;
        Object v10 = sources.get(EnumFacing.EAST);
        if (v10 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[4] = Float.valueOf(this.getFlux(heatSource5, (HeatSource)v10));
        Object v11 = sources.get(EnumFacing.UP);
        if (v11 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource6 = (HeatSource)v11;
        Object v12 = sources.get(EnumFacing.NORTH);
        if (v12 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[5] = Float.valueOf(this.getFlux(heatSource6, (HeatSource)v12));
        Object v13 = sources.get(EnumFacing.UP);
        if (v13 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource7 = (HeatSource)v13;
        Object v14 = sources.get(EnumFacing.SOUTH);
        if (v14 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[6] = Float.valueOf(this.getFlux(heatSource7, (HeatSource)v14));
        Object v15 = sources.get(EnumFacing.UP);
        if (v15 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource8 = (HeatSource)v15;
        Object v16 = sources.get(EnumFacing.WEST);
        if (v16 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[7] = Float.valueOf(this.getFlux(heatSource8, (HeatSource)v16));
        Object v17 = sources.get(EnumFacing.UP);
        if (v17 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource9 = (HeatSource)v17;
        Object v18 = sources.get(EnumFacing.EAST);
        if (v18 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[8] = Float.valueOf(this.getFlux(heatSource9, (HeatSource)v18));
        Object v19 = sources.get(EnumFacing.NORTH);
        if (v19 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource10 = (HeatSource)v19;
        Object v20 = sources.get(EnumFacing.SOUTH);
        if (v20 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[9] = Float.valueOf(this.getFlux(heatSource10, (HeatSource)v20));
        Object v21 = sources.get(EnumFacing.NORTH);
        if (v21 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource11 = (HeatSource)v21;
        Object v22 = sources.get(EnumFacing.WEST);
        if (v22 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[10] = Float.valueOf(this.getFlux(heatSource11, (HeatSource)v22));
        Object v23 = sources.get(EnumFacing.NORTH);
        if (v23 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource12 = (HeatSource)v23;
        Object v24 = sources.get(EnumFacing.EAST);
        if (v24 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[11] = Float.valueOf(this.getFlux(heatSource12, (HeatSource)v24));
        Object v25 = sources.get(EnumFacing.SOUTH);
        if (v25 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource13 = (HeatSource)v25;
        Object v26 = sources.get(EnumFacing.EAST);
        if (v26 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[12] = Float.valueOf(this.getFlux(heatSource13, (HeatSource)v26));
        Object v27 = sources.get(EnumFacing.SOUTH);
        if (v27 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource14 = (HeatSource)v27;
        Object v28 = sources.get(EnumFacing.WEST);
        if (v28 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[13] = Float.valueOf(this.getFlux(heatSource14, (HeatSource)v28));
        Object v29 = sources.get(EnumFacing.WEST);
        if (v29 == null) {
            Intrinsics.throwNpe();
        }
        HeatSource heatSource15 = (HeatSource)v29;
        Object v30 = sources.get(EnumFacing.EAST);
        if (v30 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[14] = Float.valueOf(this.getFlux(heatSource15, (HeatSource)v30));
        this.totalFlux = CollectionsKt.sumOfFloat((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    public final double getGeneratedPower() {
        return (double)(this.totalFlux / (float)10000) * Config.INSTANCE.getThermopileProduction();
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return NBTKt.newNbt((Function1<? super NBTTagCompound, Unit>)((Function1)new Function1<NBTTagCompound, Unit>(this){
            final /* synthetic */ ModuleThermopile this$0;

            public final void invoke(@NotNull NBTTagCompound $this$newNbt) {
                Intrinsics.checkParameterIsNotNull((Object)$this$newNbt, (String)"$receiver");
                NBTKt.add($this$newNbt, "totalFlux", this.this$0.getTotalFlux());
            }
            {
                this.this$0 = moduleThermopile;
                super(1);
            }
        }));
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        this.totalFlux = nbt2.func_74760_g("totalFlux");
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return CollectionsKt.listOf((Object[])new SyncVariable[]{new FloatSyncVariable(30, (Function0<Float>)((Function0)new Function0<Float>(this){
            final /* synthetic */ ModuleThermopile this$0;

            public final float invoke() {
                return this.this$0.getTotalFlux();
            }
            {
                this.this$0 = moduleThermopile;
                super(0);
            }
        }), (Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>(this){
            final /* synthetic */ ModuleThermopile this$0;

            public final void invoke(float it) {
                this.this$0.setTotalFlux(it);
            }
            {
                this.this$0 = moduleThermopile;
                super(1);
            }
        })), new AverageSyncVariable(32, this.production)});
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HeatSource getSource(@NotNull BlockPos pos, @NotNull EnumFacing side) {
        IHeatNodeHandler handler;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        IBlockState state = this.getWorld().func_180495_p(pos);
        IThermopileRecipe recipe = ThermopileRecipeManager.INSTANCE.findRecipe(state);
        if (recipe != null) {
            return new HeatSource(recipe.getTemperature(), recipe.getConductivity());
        }
        TileEntity tileEntity = this.getWorld().func_175625_s(pos);
        IHeatNodeHandler iHeatNodeHandler = handler = tileEntity != null ? CapabilitiesKt.getOrNull(tileEntity, CapabilitiesKt.getHEAT_NODE_HANDLER(), side.func_176734_d()) : null;
        if (handler != null) {
            void $this$filterIsInstanceTo$iv$iv;
            List<INode> list = handler.getNodes();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"handler.nodes");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IHeatNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            IHeatNode node = (IHeatNode)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (node != null) {
                return new HeatSource((float)node.getTemperature(), (float)node.getConductivity() * 0.01f);
            }
        }
        return DefaultHeatSource.INSTANCE;
    }

    public final float getFlux(@NotNull HeatSource a, @NotNull HeatSource b) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        float conductivity = 1.0f / (1.0f / a.getConductivity() + 1.0f / b.getConductivity());
        float tempDiff = a.getTemperature() - b.getTemperature();
        float f = conductivity * tempDiff;
        boolean bl = false;
        return Math.abs(f);
    }

    @NotNull
    public final IElectricNode getNode() {
        return this.node;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleThermopile(@NotNull IElectricNode node, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.node = node;
        this.name = name;
        this.production = new ValueAverage(0, 1, null);
    }

    public /* synthetic */ ModuleThermopile(IElectricNode iElectricNode, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "module_thermopile";
        }
        this(iElectricNode, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleThermopile$HeatSource;", "", "temperature", "", "conductivity", "(FF)V", "getConductivity", "()F", "getTemperature", "Magneticraft_1.12"})
    public static class HeatSource {
        private final float temperature;
        private final float conductivity;

        public final float getTemperature() {
            return this.temperature;
        }

        public final float getConductivity() {
            return this.conductivity;
        }

        public HeatSource(float temperature, float conductivity) {
            this.temperature = temperature;
            this.conductivity = conductivity;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleThermopile$DefaultHeatSource;", "Lcom/cout970/magneticraft/systems/tilemodules/ModuleThermopile$HeatSource;", "()V", "Magneticraft_1.12"})
    public static final class DefaultHeatSource
    extends HeatSource {
        public static final DefaultHeatSource INSTANCE;

        private DefaultHeatSource() {
            super((float)HeatKt.getSTANDARD_AMBIENT_TEMPERATURE(), 1.0f);
        }

        static {
            DefaultHeatSource defaultHeatSource;
            INSTANCE = defaultHeatSource = new DefaultHeatSource();
        }
    }
}

