/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.misc.NBTKt;
import com.cout970.magneticraft.misc.inventory.InventoriesKt;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.IntSyncVariable;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.misc.world.WorldKt;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.systems.config.Config;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J-\u0010\u001f\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%J\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\b\u0010+\u001a\u00020\u001cH\u0016J\b\u0010,\u001a\u00020\u001eH\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleStackInventory;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "maxItems", "", "name", "", "(ILjava/lang/String;)V", "amount", "getAmount", "()I", "setAmount", "(I)V", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "getMaxItems", "getName", "()Ljava/lang/String;", "stackType", "Lnet/minecraft/item/ItemStack;", "getStackType", "()Lnet/minecraft/item/ItemStack;", "setStackType", "(Lnet/minecraft/item/ItemStack;)V", "deserializeNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "getCapability", "T", "cap", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getGuiInventory", "Lnet/minecraftforge/items/IItemHandler;", "getGuiSyncVariables", "", "Lcom/cout970/magneticraft/misc/network/SyncVariable;", "onBreak", "serializeNBT", "ContainerCapabilityFilter", "Magneticraft_1.12"})
public final class ModuleStackInventory
implements IModule {
    @NotNull
    public IModuleContainer container;
    @NotNull
    private ItemStack stackType;
    private int amount;
    private final int maxItems;
    @NotNull
    private final String name;

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    @NotNull
    public final ItemStack getStackType() {
        return this.stackType;
    }

    public final void setStackType(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"<set-?>");
        this.stackType = itemStack;
    }

    public final int getAmount() {
        return this.amount;
    }

    public final void setAmount(int n) {
        this.amount = n;
    }

    @Override
    public void onBreak() {
        if (this.stackType.func_190926_b()) {
            return;
        }
        int n = this.amount;
        int n2 = Config.INSTANCE.getContainerMaxItemDrops();
        boolean bl = false;
        for (int items = Math.min(n, n2); items > 0; items -= this.stackType.func_77976_d()) {
            n2 = this.stackType.func_77976_d();
            bl = false;
            int stackSize = Math.min(items, n2);
            WorldKt.dropItem$default(this.getWorld(), InventoriesKt.withSize(this.stackType, stackSize), this.getPos(), false, null, 12, null);
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        this.stackType = itemStack;
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        if (Intrinsics.areEqual(cap, CapabilitiesKt.getITEM_HANDLER())) {
            return (T)new ContainerCapabilityFilter(this.getContainer().getTile());
        }
        return null;
    }

    @NotNull
    public final IItemHandler getGuiInventory() {
        return new IItemHandler(this){
            final /* synthetic */ ModuleStackInventory this$0;

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                if (slot != 0 || stack.func_190926_b()) {
                    return stack;
                }
                if (this.this$0.getStackType().func_190926_b()) {
                    if (!simulate) {
                        this.this$0.setStackType(InventoriesKt.withSize(stack, 1));
                        this.this$0.setAmount(stack.func_190916_E());
                        this.this$0.getContainer().sendUpdateToNearPlayers();
                    }
                    ItemStack itemStack = ItemStack.field_190927_a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
                    return itemStack;
                }
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.this$0.getStackType(), (ItemStack)stack)) {
                    ItemStack itemStack;
                    int space = this.this$0.getMaxItems() - this.this$0.getAmount();
                    int n = stack.func_190916_E();
                    boolean bl = false;
                    int toAdd = Math.min(space, n);
                    int itemsLeft = stack.func_190916_E() - toAdd;
                    if (!simulate) {
                        ModuleStackInventory moduleStackInventory = this.this$0;
                        moduleStackInventory.setAmount(moduleStackInventory.getAmount() + toAdd);
                    }
                    if (itemsLeft == 0) {
                        ItemStack itemStack2 = ItemStack.field_190927_a;
                        itemStack = itemStack2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemStack.EMPTY");
                    } else {
                        itemStack = InventoriesKt.withSize(stack, itemsLeft);
                    }
                    return itemStack;
                }
                return stack;
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                ItemStack itemStack;
                switch (slot) {
                    case 0: {
                        ItemStack itemStack2 = ItemStack.field_190927_a;
                        itemStack = itemStack2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemStack.EMPTY");
                        break;
                    }
                    default: {
                        int n = this.this$0.getAmount();
                        int n2 = 64;
                        ItemStack itemStack3 = this.this$0.getStackType();
                        boolean bl = false;
                        int n3 = Math.min(n, n2);
                        itemStack = InventoriesKt.withSize(itemStack3, n3);
                    }
                }
                return itemStack;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            public int getSlots() {
                return 2;
            }

            @NotNull
            public ItemStack extractItem(int slot, int count, boolean simulate) {
                if (slot != 1 || this.this$0.getStackType().func_190926_b() || this.this$0.getAmount() == 0) {
                    ItemStack itemStack = ItemStack.field_190927_a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
                    return itemStack;
                }
                int n = this.this$0.getAmount();
                int n2 = 0;
                n = Math.min(count, n);
                n2 = 64;
                boolean bl = false;
                int toExtract = Math.min(n, n2);
                if (toExtract <= 0) {
                    ItemStack itemStack = ItemStack.field_190927_a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
                    return itemStack;
                }
                ItemStack result = InventoriesKt.withSize(this.this$0.getStackType(), toExtract);
                if (!simulate) {
                    ModuleStackInventory moduleStackInventory = this.this$0;
                    moduleStackInventory.setAmount(moduleStackInventory.getAmount() - toExtract);
                    if (this.this$0.getAmount() <= 0) {
                        ItemStack itemStack = ItemStack.field_190927_a;
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
                        this.this$0.setStackType(itemStack);
                        this.this$0.getContainer().sendUpdateToNearPlayers();
                    }
                }
                return result;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return CollectionsKt.listOf((Object)new IntSyncVariable(38, (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ModuleStackInventory this$0;

            public final int invoke() {
                return this.this$0.getAmount();
            }
            {
                this.this$0 = moduleStackInventory;
                super(0);
            }
        }), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ModuleStackInventory this$0;

            public final void invoke(int it) {
                this.this$0.setAmount(it);
            }
            {
                this.this$0 = moduleStackInventory;
                super(1);
            }
        })));
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        if (nbt2.func_74764_b("amount")) {
            this.amount = nbt2.func_74762_e("amount");
            this.stackType = new ItemStack(nbt2.func_74775_l("stackType"));
        }
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return NBTKt.newNbt((Function1<? super NBTTagCompound, Unit>)((Function1)new Function1<NBTTagCompound, Unit>(this){
            final /* synthetic */ ModuleStackInventory this$0;

            public final void invoke(@NotNull NBTTagCompound $this$newNbt) {
                Intrinsics.checkParameterIsNotNull((Object)$this$newNbt, (String)"$receiver");
                NBTKt.add($this$newNbt, "amount", this.this$0.getAmount());
                NBTTagCompound nBTTagCompound = this.this$0.getStackType().serializeNBT();
                Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"stackType.serializeNBT()");
                NBTKt.add($this$newNbt, "stackType", nBTTagCompound);
            }
            {
                this.this$0 = moduleStackInventory;
                super(1);
            }
        }));
    }

    public final int getMaxItems() {
        return this.maxItems;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleStackInventory(int maxItems, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.maxItems = maxItems;
        this.name = name;
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        this.stackType = itemStack;
    }

    public /* synthetic */ ModuleStackInventory(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "module_stack_inventory";
        }
        this(n, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void update() {
        IModule.DefaultImpls.update(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleStackInventory$ContainerCapabilityFilter;", "Lnet/minecraftforge/items/IItemHandler;", "parent", "Lnet/minecraft/tileentity/TileEntity;", "(Lcom/cout970/magneticraft/systems/tilemodules/ModuleStackInventory;Lnet/minecraft/tileentity/TileEntity;)V", "getParent", "()Lnet/minecraft/tileentity/TileEntity;", "equals", "", "other", "", "extractItem", "Lnet/minecraft/item/ItemStack;", "slot", "", "count", "simulate", "getSlotLimit", "getSlots", "getStackInSlot", "hashCode", "insertItem", "stack", "Magneticraft_1.12"})
    public final class ContainerCapabilityFilter
    implements IItemHandler {
        @NotNull
        private final TileEntity parent;

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            if (ModuleStackInventory.this.getStackType().func_190926_b()) {
                if (!simulate) {
                    ModuleStackInventory.this.setStackType(InventoriesKt.withSize(stack, 1));
                    ModuleStackInventory.this.setAmount(stack.func_190916_E());
                    ModuleStackInventory.this.getContainer().sendUpdateToNearPlayers();
                }
                ItemStack itemStack = ItemStack.field_190927_a;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
                return itemStack;
            }
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)ModuleStackInventory.this.getStackType(), (ItemStack)stack)) {
                ItemStack itemStack;
                int space = ModuleStackInventory.this.getMaxItems() - ModuleStackInventory.this.getAmount();
                int n = stack.func_190916_E();
                boolean bl = false;
                int toAdd = Math.min(space, n);
                int itemsLeft = stack.func_190916_E() - toAdd;
                if (!simulate) {
                    ModuleStackInventory moduleStackInventory = ModuleStackInventory.this;
                    moduleStackInventory.setAmount(moduleStackInventory.getAmount() + toAdd);
                }
                if (itemsLeft == 0) {
                    ItemStack itemStack2 = ItemStack.field_190927_a;
                    itemStack = itemStack2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemStack.EMPTY");
                } else {
                    itemStack = InventoriesKt.withSize(stack, itemsLeft);
                }
                return itemStack;
            }
            return stack;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (ModuleStackInventory.this.getStackType().func_190926_b()) {
                ItemStack itemStack = ItemStack.field_190927_a;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
                return itemStack;
            }
            return InventoriesKt.withSize(ModuleStackInventory.this.getStackType(), ModuleStackInventory.this.getAmount());
        }

        public int getSlotLimit(int slot) {
            return ModuleStackInventory.this.getMaxItems();
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack extractItem(int slot, int count, boolean simulate) {
            if (ModuleStackInventory.this.getStackType().func_190926_b() || ModuleStackInventory.this.getAmount() == 0) {
                ItemStack itemStack = ItemStack.field_190927_a;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
                return itemStack;
            }
            int n = ModuleStackInventory.this.getAmount();
            int n2 = 0;
            n = Math.min(count, n);
            n2 = 64;
            boolean bl = false;
            int toExtract = Math.min(n, n2);
            if (toExtract <= 0) {
                ItemStack itemStack = ItemStack.field_190927_a;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
                return itemStack;
            }
            ItemStack result = InventoriesKt.withSize(ModuleStackInventory.this.getStackType(), toExtract);
            if (!simulate) {
                ModuleStackInventory moduleStackInventory = ModuleStackInventory.this;
                moduleStackInventory.setAmount(moduleStackInventory.getAmount() - toExtract);
                if (ModuleStackInventory.this.getAmount() <= 0) {
                    ItemStack itemStack = ItemStack.field_190927_a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
                    ModuleStackInventory.this.setStackType(itemStack);
                    ModuleStackInventory.this.getContainer().sendUpdateToNearPlayers();
                }
            }
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.systems.tilemodules.ModuleStackInventory.ContainerCapabilityFilter");
            }
            ContainerCapabilityFilter cfr_ignored_0 = (ContainerCapabilityFilter)object2;
            return !(Intrinsics.areEqual((Object)this.parent, (Object)((ContainerCapabilityFilter)other).parent) ^ true);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.parent.hashCode();
        }

        @NotNull
        public final TileEntity getParent() {
            return this.parent;
        }

        public ContainerCapabilityFilter(TileEntity parent) {
            Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
            this.parent = parent;
        }
    }
}

