/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.api.MagneticraftApi;
import com.cout970.magneticraft.api.registries.machines.sluicebox.ISluiceBoxRecipe;
import com.cout970.magneticraft.misc.NBTKt;
import com.cout970.magneticraft.misc.fluid.VoidFluidHandler;
import com.cout970.magneticraft.misc.inventory.InventoriesKt;
import com.cout970.magneticraft.misc.inventory.Inventory;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import com.cout970.magneticraft.misc.vector.EnumFacingKt;
import com.cout970.magneticraft.misc.world.WorldKt;
import com.cout970.magneticraft.registry.Sounds;
import com.cout970.magneticraft.systems.blocks.IOnActivated;
import com.cout970.magneticraft.systems.blocks.OnActivatedArgs;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import com.cout970.magneticraft.systems.tileentities.TileBase;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 82\u00020\u00012\u00020\u0002:\u00018B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020#J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u0004\u0018\u00010\u0000J\u0010\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010'\u001a\u00020(J\u000e\u00100\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0010\u00101\u001a\u00020&2\u0006\u00102\u001a\u000203H\u0016J\u0006\u00104\u001a\u00020#J\u000e\u00105\u001a\u00020(2\u0006\u0010'\u001a\u00020(J\b\u00106\u001a\u00020,H\u0016J\b\u00107\u001a\u00020#H\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000e\"\u0004\b!\u0010\u0010\u00a8\u00069"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleSluiceBox;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "Lcom/cout970/magneticraft/systems/blocks/IOnActivated;", "facingGetter", "Lkotlin/Function0;", "Lnet/minecraft/util/EnumFacing;", "inventory", "Lcom/cout970/magneticraft/misc/inventory/Inventory;", "name", "", "(Lkotlin/jvm/functions/Function0;Lcom/cout970/magneticraft/misc/inventory/Inventory;Ljava/lang/String;)V", "chainDelay", "", "getChainDelay", "()I", "setChainDelay", "(I)V", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "getFacingGetter", "()Lkotlin/jvm/functions/Function0;", "getInventory", "()Lcom/cout970/magneticraft/misc/inventory/Inventory;", "level", "getLevel", "getName", "()Ljava/lang/String;", "progressLeft", "getProgressLeft", "setProgressLeft", "activate", "", "activateChain", "canAccept", "", "stack", "Lnet/minecraft/item/ItemStack;", "craft", "deserializeNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "getNextSluice", "getRecipe", "Lcom/cout970/magneticraft/api/registries/machines/sluicebox/ISluiceBoxRecipe;", "isWaterContainer", "onActivated", "args", "Lcom/cout970/magneticraft/systems/blocks/OnActivatedArgs;", "playSounds", "removeWaterFromContainer", "serializeNBT", "update", "Companion", "Magneticraft_1.12"})
public final class ModuleSluiceBox
implements IModule,
IOnActivated {
    @NotNull
    public IModuleContainer container;
    private int progressLeft;
    private int chainDelay;
    @NotNull
    private final Function0<EnumFacing> facingGetter;
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final String name;
    private static final int MAX_ITEMS = 10;
    private static final int MAX_PROGRESS = 80;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    public final int getLevel() {
        return InventoriesKt.get((IItemHandler)this.inventory, 0).func_190916_E();
    }

    public final int getProgressLeft() {
        return this.progressLeft;
    }

    public final void setProgressLeft(int n) {
        this.progressLeft = n;
    }

    public final int getChainDelay() {
        return this.chainDelay;
    }

    public final void setChainDelay(int n) {
        this.chainDelay = n;
    }

    @Override
    public boolean onActivated(@NotNull OnActivatedArgs args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        ItemStack heldItem = args.getHeldItem();
        if (heldItem.func_190926_b()) {
            return false;
        }
        if (this.isWaterContainer(heldItem) && this.progressLeft == 0) {
            if (!args.getPlayerIn().func_184812_l_()) {
                args.getPlayerIn().func_184611_a(args.getHand(), this.removeWaterFromContainer(heldItem));
            }
            this.activateChain();
        } else if (this.canAccept(heldItem)) {
            ItemStack stack = InventoriesKt.get((IItemHandler)this.inventory, 0);
            if (stack.func_190926_b()) {
                ItemStack extracted;
                ItemStack itemStack = extracted = heldItem.func_77979_a(MAX_ITEMS);
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"extracted");
                if (InventoriesKt.isNotEmpty(itemStack)) {
                    InventoriesKt.set((IItemHandlerModifiable)this.inventory, 0, extracted);
                    this.getContainer().sendUpdateToNearPlayers();
                }
            } else if (stack.func_190916_E() < MAX_ITEMS && stack.func_77969_a(heldItem)) {
                ItemStack extracted;
                ItemStack itemStack = extracted = heldItem.func_77979_a(MAX_ITEMS - stack.func_190916_E());
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"extracted");
                if (InventoriesKt.isNotEmpty(itemStack)) {
                    ItemStack itemStack2 = stack;
                    itemStack2.func_190920_e(itemStack2.func_190916_E() + extracted.func_190916_E());
                    this.getContainer().sendUpdateToNearPlayers();
                }
            }
        }
        return true;
    }

    public final boolean isWaterContainer(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluidStack == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"FluidUtil.getFluidContained(stack) ?: return false");
        FluidStack fluidStack2 = fluidStack;
        return fluidStack2.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1000));
    }

    @NotNull
    public final ItemStack removeWaterFromContainer(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        FluidActionResult fluidActionResult = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)VoidFluidHandler.INSTANCE, (int)1000, null, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidActionResult, (String)"FluidUtil.tryEmptyContai\u2026andler, 1000, null, true)");
        FluidActionResult result = fluidActionResult;
        if (result.isSuccess()) {
            ItemStack itemStack = result.result;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"result.result");
            return itemStack;
        }
        return stack;
    }

    public final void activateChain() {
        this.activate();
        this.chainDelay = 20;
    }

    public final void activate() {
        this.progressLeft = MAX_PROGRESS;
        this.playSounds();
        this.getContainer().sendUpdateToNearPlayers();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ModuleSluiceBox getNextSluice() {
        ModuleSluiceBox moduleSluiceBox;
        TileBase tile$iv;
        void $this$getModule$iv;
        BlockPos otherPos = this.getPos().func_177967_a((EnumFacing)this.facingGetter.invoke(), 2).func_177977_b();
        IBlockAccess iBlockAccess = (IBlockAccess)this.getWorld();
        BlockPos blockPos = otherPos;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"otherPos");
        BlockPos pos$iv = blockPos;
        boolean $i$f$getModule = false;
        void $this$getTile$iv$iv = $this$getModule$iv;
        boolean $i$f$getTile = false;
        TileEntity tile$iv$iv = $this$getTile$iv$iv.func_175625_s(pos$iv);
        TileEntity tileEntity = tile$iv$iv;
        if (!(tileEntity instanceof TileBase)) {
            tileEntity = null;
        }
        TileBase tileBase = tile$iv = (TileBase)tileEntity;
        if (tileBase != null) {
            Object v4;
            Object v3;
            block5: {
                TileBase $this$getModule$iv$iv = tileBase;
                boolean $i$f$getModule2 = false;
                Iterable iterable = $this$getModule$iv$iv.getContainer().getModules();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    IModule it$iv$iv = (IModule)t;
                    boolean bl3 = false;
                    if (!(it$iv$iv instanceof ModuleSluiceBox)) continue;
                    v3 = t;
                    break block5;
                }
                v3 = v4 = null;
            }
            if (!(v3 instanceof ModuleSluiceBox)) {
                v4 = null;
            }
            moduleSluiceBox = v4;
        } else {
            moduleSluiceBox = null;
        }
        return moduleSluiceBox;
    }

    @Override
    public void update() {
        int n;
        if (this.chainDelay > 0) {
            n = this.chainDelay;
            this.chainDelay = n + -1;
            if (this.chainDelay == 0) {
                ModuleSluiceBox moduleSluiceBox = this.getNextSluice();
                if (moduleSluiceBox == null) {
                    return;
                }
                ModuleSluiceBox mod = moduleSluiceBox;
                mod.activateChain();
            }
        }
        if (this.progressLeft > 0) {
            n = this.progressLeft;
            this.progressLeft = n + -1;
            if (this.progressLeft == 0) {
                this.craft();
            }
        }
    }

    public final void craft() {
        ItemStack stack = InventoriesKt.get((IItemHandler)this.inventory, 0);
        if (stack.func_190926_b()) {
            return;
        }
        ISluiceBoxRecipe iSluiceBoxRecipe = this.getRecipe(stack);
        if (iSluiceBoxRecipe == null) {
            return;
        }
        ISluiceBoxRecipe recipe = iSluiceBoxRecipe;
        BlockPos pos = BlockPosKt.plus(this.getPos(), EnumFacingKt.toBlockPos((EnumFacing)this.facingGetter.invoke()));
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)stack.func_190916_E());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            List<Pair<ItemStack, Float>> list = recipe.getOutputs();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"recipe.outputs");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Pair $dstr$item$prob = (Pair)element$iv2;
                boolean bl2 = false;
                ItemStack item = (ItemStack)$dstr$item$prob.component1();
                Float prob = (Float)$dstr$item$prob.component2();
                ItemStack itemStack = item;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"item");
                if (!InventoriesKt.isNotEmpty(itemStack)) continue;
                float f = this.getWorld().field_73012_v.nextFloat();
                Float f2 = prob;
                Intrinsics.checkExpressionValueIsNotNull((Object)f2, (String)"prob");
                if (!(f < f2.floatValue())) continue;
                WorldKt.dropItem$default(this.getWorld(), item, pos, false, null, 8, null);
            }
        }
        IItemHandlerModifiable iItemHandlerModifiable = (IItemHandlerModifiable)this.inventory;
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        InventoriesKt.set(iItemHandlerModifiable, 0, itemStack);
        this.getContainer().sendUpdateToNearPlayers();
    }

    public final void playSounds() {
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            SoundEvent sound = this.getNextSluice() == null ? Sounds.WATER_FLOW_END.getSoundEvent() : Sounds.WATER_FLOW.getSoundEvent();
            this.getWorld().func_184134_a(BlockPosKt.getXd(this.getPos()), BlockPosKt.getYd(this.getPos()), BlockPosKt.getZd(this.getPos()), sound, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    @Nullable
    public final ISluiceBoxRecipe getRecipe(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return MagneticraftApi.getSluiceBoxRecipeManager().findRecipe(stack);
    }

    public final boolean canAccept(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return this.getRecipe(stack) != null;
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        this.progressLeft = nbt2.func_74762_e("progressLeft");
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return NBTKt.newNbt((Function1<? super NBTTagCompound, Unit>)((Function1)new Function1<NBTTagCompound, Unit>(this){
            final /* synthetic */ ModuleSluiceBox this$0;

            public final void invoke(@NotNull NBTTagCompound $this$newNbt) {
                Intrinsics.checkParameterIsNotNull((Object)$this$newNbt, (String)"$receiver");
                NBTKt.add($this$newNbt, "progressLeft", this.this$0.getProgressLeft());
            }
            {
                this.this$0 = moduleSluiceBox;
                super(1);
            }
        }));
    }

    @NotNull
    public final Function0<EnumFacing> getFacingGetter() {
        return this.facingGetter;
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleSluiceBox(@NotNull Function0<? extends EnumFacing> facingGetter, @NotNull Inventory inventory2, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull(facingGetter, (String)"facingGetter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)inventory2), (String)"inventory");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.facingGetter = facingGetter;
        this.inventory = inventory2;
        this.name = name;
    }

    public /* synthetic */ ModuleSluiceBox(Function0 function0, Inventory inventory2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "module_sluice_box";
        }
        this((Function0<? extends EnumFacing>)function0, inventory2, string);
    }

    static {
        MAX_ITEMS = 10;
        MAX_PROGRESS = 80;
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return IModule.DefaultImpls.getGuiSyncVariables(this);
    }

    public static final int getMAX_ITEMS() {
        Companion companion = Companion;
        return MAX_ITEMS;
    }

    public static final int getMAX_PROGRESS() {
        Companion companion = Companion;
        return MAX_PROGRESS;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleSluiceBox$Companion;", "", "()V", "MAX_ITEMS", "", "MAX_ITEMS$annotations", "getMAX_ITEMS", "()I", "MAX_PROGRESS", "MAX_PROGRESS$annotations", "getMAX_PROGRESS", "Magneticraft_1.12"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void MAX_ITEMS$annotations() {
        }

        public final int getMAX_ITEMS() {
            return MAX_ITEMS;
        }

        @JvmStatic
        public static /* synthetic */ void MAX_PROGRESS$annotations() {
        }

        public final int getMAX_PROGRESS() {
            return MAX_PROGRESS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

