/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.misc.NBTKt;
import com.cout970.magneticraft.misc.crafting.ICraftingProcess;
import com.cout970.magneticraft.misc.crafting.TimedCraftingProcess;
import com.cout970.magneticraft.misc.energy.IMachineEnergyInterface;
import com.cout970.magneticraft.misc.gui.ValueAverage;
import com.cout970.magneticraft.misc.network.FloatSyncVariable;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0016J\u000e\u00100\u001a\u00020*2\u0006\u00101\u001a\u00020\u0007J\b\u00102\u001a\u00020,H\u0016J\b\u00103\u001a\u00020*H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0017\u00a8\u00064"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleElectricProcessing;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "craftingProcess", "Lcom/cout970/magneticraft/misc/crafting/ICraftingProcess;", "storage", "Lcom/cout970/magneticraft/misc/energy/IMachineEnergyInterface;", "workingRate", "", "costPerTick", "name", "", "(Lcom/cout970/magneticraft/misc/crafting/ICraftingProcess;Lcom/cout970/magneticraft/misc/energy/IMachineEnergyInterface;FFLjava/lang/String;)V", "consumption", "Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "getConsumption", "()Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "getCostPerTick", "()F", "getCraftingProcess", "()Lcom/cout970/magneticraft/misc/crafting/ICraftingProcess;", "getName", "()Ljava/lang/String;", "getStorage", "()Lcom/cout970/magneticraft/misc/energy/IMachineEnergyInterface;", "timedProcess", "Lcom/cout970/magneticraft/misc/crafting/TimedCraftingProcess;", "getTimedProcess", "()Lcom/cout970/magneticraft/misc/crafting/TimedCraftingProcess;", "working", "", "getWorking", "()Z", "setWorking", "(Z)V", "getWorkingRate", "deserializeNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "getGuiSyncVariables", "", "Lcom/cout970/magneticraft/misc/network/SyncVariable;", "onWorkingTick", "speed", "serializeNBT", "update", "Magneticraft_1.12"})
public final class ModuleElectricProcessing
implements IModule {
    @NotNull
    public IModuleContainer container;
    @NotNull
    private final TimedCraftingProcess timedProcess;
    @NotNull
    private final ValueAverage consumption;
    private boolean working;
    @NotNull
    private final ICraftingProcess craftingProcess;
    @NotNull
    private final IMachineEnergyInterface storage;
    private final float workingRate;
    private final float costPerTick;
    @NotNull
    private final String name;

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    @NotNull
    public final TimedCraftingProcess getTimedProcess() {
        return this.timedProcess;
    }

    @NotNull
    public final ValueAverage getConsumption() {
        return this.consumption;
    }

    public final boolean getWorking() {
        return this.working;
    }

    public final void setWorking(boolean bl) {
        this.working = bl;
    }

    @Override
    public void update() {
        boolean isWorking;
        float unit;
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            return;
        }
        double rate = (double)this.workingRate * this.storage.getSpeed();
        float speed = (float)Math.floor(rate * (double)(unit = this.costPerTick / this.workingRate)) / unit;
        if (speed > 0.0f) {
            this.timedProcess.tick(this.getWorld(), speed);
        }
        if ((isWorking = this.timedProcess.isWorking(this.getWorld())) != this.working) {
            this.working = isWorking;
            this.getContainer().sendUpdateToNearPlayers();
        }
        this.consumption.tick();
    }

    public final void onWorkingTick(float speed) {
        float unit = this.costPerTick / this.workingRate;
        this.consumption.plusAssign(speed * unit);
        this.storage.useEnergy((double)speed * (double)unit);
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        NBTTagCompound nBTTagCompound = nbt2.func_74775_l("timedProcess");
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"nbt.getCompoundTag(\"timedProcess\")");
        this.timedProcess.deserializeNBT(nBTTagCompound);
        this.working = nbt2.func_74767_n("working");
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return NBTKt.newNbt((Function1<? super NBTTagCompound, Unit>)((Function1)new Function1<NBTTagCompound, Unit>(this){
            final /* synthetic */ ModuleElectricProcessing this$0;

            public final void invoke(@NotNull NBTTagCompound $this$newNbt) {
                Intrinsics.checkParameterIsNotNull((Object)$this$newNbt, (String)"$receiver");
                NBTKt.add($this$newNbt, "timedProcess", this.this$0.getTimedProcess().serializeNBT());
                NBTKt.add($this$newNbt, "working", this.this$0.getWorking());
            }
            {
                this.this$0 = moduleElectricProcessing;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return CollectionsKt.listOf((Object[])new FloatSyncVariable[]{new FloatSyncVariable(2, (Function0<Float>)((Function0)new Function0<Float>(this){
            final /* synthetic */ ModuleElectricProcessing this$0;

            public final float invoke() {
                return this.this$0.getTimedProcess().getTimer();
            }
            {
                this.this$0 = moduleElectricProcessing;
                super(0);
            }
        }), (Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>(this){
            final /* synthetic */ ModuleElectricProcessing this$0;

            public final void invoke(float it) {
                this.this$0.getTimedProcess().setTimer(it);
            }
            {
                this.this$0 = moduleElectricProcessing;
                super(1);
            }
        })), this.consumption.toSyncVariable(43)});
    }

    @NotNull
    public final ICraftingProcess getCraftingProcess() {
        return this.craftingProcess;
    }

    @NotNull
    public final IMachineEnergyInterface getStorage() {
        return this.storage;
    }

    public final float getWorkingRate() {
        return this.workingRate;
    }

    public final float getCostPerTick() {
        return this.costPerTick;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleElectricProcessing(@NotNull ICraftingProcess craftingProcess, @NotNull IMachineEnergyInterface storage, float workingRate, float costPerTick, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)craftingProcess, (String)"craftingProcess");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.craftingProcess = craftingProcess;
        this.storage = storage;
        this.workingRate = workingRate;
        this.costPerTick = costPerTick;
        this.name = name;
        this.timedProcess = new TimedCraftingProcess(this.craftingProcess, (Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>(this){

            public final void invoke(float p1) {
                ((ModuleElectricProcessing)this.receiver).onWorkingTick(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ModuleElectricProcessing.class);
            }

            public final String getName() {
                return "onWorkingTick";
            }

            public final String getSignature() {
                return "onWorkingTick(F)V";
            }
        }));
        this.consumption = new ValueAverage(0, 1, null);
    }

    public /* synthetic */ ModuleElectricProcessing(ICraftingProcess iCraftingProcess, IMachineEnergyInterface iMachineEnergyInterface, float f, float f2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string = "module_electric_processing";
        }
        this(iCraftingProcess, iMachineEnergyInterface, f, f2, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }
}

