/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.multiblocks;

import com.cout970.magneticraft.Debug;
import com.cout970.magneticraft.misc.ResourcesKt;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import com.cout970.magneticraft.systems.multiblocks.BlockData;
import com.cout970.magneticraft.systems.multiblocks.IMultiblockComponent;
import com.cout970.magneticraft.systems.multiblocks.Multiblock;
import com.cout970.magneticraft.systems.multiblocks.MultiblockContext;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/cout970/magneticraft/systems/multiblocks/SingleBlockComponent;", "Lcom/cout970/magneticraft/systems/multiblocks/IMultiblockComponent;", "origin", "Lnet/minecraft/block/state/IBlockState;", "replacement", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;)V", "getOrigin", "()Lnet/minecraft/block/state/IBlockState;", "getReplacement", "activateBlock", "", "relativePos", "Lnet/minecraft/util/math/BlockPos;", "context", "Lcom/cout970/magneticraft/systems/multiblocks/MultiblockContext;", "checkBlock", "", "Lnet/minecraft/util/text/ITextComponent;", "deactivateBlock", "getBlockData", "Lcom/cout970/magneticraft/systems/multiblocks/BlockData;", "getBlueprintBlocks", "Lnet/minecraft/item/ItemStack;", "multiblock", "Lcom/cout970/magneticraft/systems/multiblocks/Multiblock;", "blockPos", "Magneticraft_1.12"})
public final class SingleBlockComponent
implements IMultiblockComponent {
    @NotNull
    private final IBlockState origin;
    @NotNull
    private final IBlockState replacement;

    @Override
    @NotNull
    public List<ITextComponent> checkBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        IBlockState state = context.getWorld().func_180495_p(pos);
        if (Intrinsics.areEqual((Object)state, (Object)this.origin) ^ true) {
            if (Debug.INSTANCE.getDEBUG() && context.getPlayer() != null) {
                FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
                Intrinsics.checkExpressionValueIsNotNull((Object)fMLCommonHandler, (String)"FMLCommonHandler.instance()");
                if (fMLCommonHandler.getEffectiveSide() == Side.SERVER) {
                    context.getWorld().func_175656_a(pos, this.origin);
                }
            }
            String keyStr = "text.magneticraft.multiblock.invalid_block";
            String string = "[%d, %d, %d]";
            Object[] objectArray = new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
            String vecStr = string2;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = vecStr;
            IBlockState iBlockState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            objectArray2[1] = ResourcesKt.prettyFormat(iBlockState);
            objectArray2[2] = ResourcesKt.prettyFormat(this.origin);
            return CollectionsKt.listOf((Object)ResourcesKt.i18n(keyStr, objectArray2));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public BlockData getBlockData(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        IBlockState state;
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        IBlockState iBlockState = state = context.getWorld().func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        return new BlockData(iBlockState, pos);
    }

    @Override
    public void activateBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        context.getWorld().func_175656_a(pos, this.replacement);
        IMultiblockComponent.DefaultImpls.activateBlock(this, relativePos, context);
    }

    @Override
    public void deactivateBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        IMultiblockComponent.DefaultImpls.deactivateBlock(this, relativePos, context);
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        Block block = Blocks.field_150350_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"Blocks.AIR");
        if (Intrinsics.areEqual((Object)this.origin, (Object)block.func_176223_P()) ^ true) {
            context.getWorld().func_175656_a(pos, this.origin);
        }
    }

    @Override
    @NotNull
    public List<ItemStack> getBlueprintBlocks(@NotNull Multiblock multiblock, @NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull((Object)multiblock, (String)"multiblock");
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"blockPos");
        return CollectionsKt.listOf((Object)new ItemStack(this.origin.func_177230_c(), 1, this.origin.func_177230_c().func_176201_c(this.origin)));
    }

    @NotNull
    public final IBlockState getOrigin() {
        return this.origin;
    }

    @NotNull
    public final IBlockState getReplacement() {
        return this.replacement;
    }

    public SingleBlockComponent(@NotNull IBlockState origin, @NotNull IBlockState replacement) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        this.origin = origin;
        this.replacement = replacement;
    }
}

