/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.multiblocks;

import com.cout970.magneticraft.api.multiblock.IMultiblock;
import com.cout970.magneticraft.api.multiblock.IMultiblockManager;
import com.cout970.magneticraft.api.multiblock.MultiBlockEvent;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockBigCombustionChamber;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockBigElectricFurnace;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockBigSteamBoiler;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockContainer;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockGrinder;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockHydraulicPress;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockOilHeater;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockPumpjack;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockRefinery;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockShelvingUnit;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockSieve;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockSolarMirror;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockSolarPanel;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockSolarTower;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockSteamEngine;
import com.cout970.magneticraft.features.multiblocks.structures.MultiblockSteamTurbine;
import com.cout970.magneticraft.misc.CollectionsKt;
import com.cout970.magneticraft.misc.vector.EnumFacingKt;
import com.cout970.magneticraft.systems.multiblocks.IMultiblockComponent;
import com.cout970.magneticraft.systems.multiblocks.Multiblock;
import com.cout970.magneticraft.systems.multiblocks.MultiblockContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u0004H\u0016J\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/cout970/magneticraft/systems/multiblocks/MultiblockManager;", "Lcom/cout970/magneticraft/api/multiblock/IMultiblockManager;", "()V", "multiblocks", "", "", "Lcom/cout970/magneticraft/systems/multiblocks/Multiblock;", "activateMultiblockStructure", "", "context", "Lcom/cout970/magneticraft/systems/multiblocks/MultiblockContext;", "applyFacing", "Lnet/minecraft/util/math/BlockPos;", "pos", "checkMultiblockStructure", "", "Lnet/minecraft/util/text/ITextComponent;", "deactivateMultiblockStructure", "getMultiblock", "name", "getRegisteredMultiblocks", "Lcom/cout970/magneticraft/api/multiblock/IMultiblock;", "registerDefaults", "registerMultiblock", "mb", "Magneticraft_1.12"})
public final class MultiblockManager
implements IMultiblockManager {
    private static final Map<String, Multiblock> multiblocks;
    public static final MultiblockManager INSTANCE;

    public final void registerMultiblock(@NotNull Multiblock mb) {
        Intrinsics.checkParameterIsNotNull((Object)mb, (String)"mb");
        Object object = multiblocks;
        String string = mb.getName();
        boolean bl = false;
        Map<String, Multiblock> map = object;
        boolean bl2 = false;
        if (map.containsKey(string)) {
            object = "Multiblock with name: " + mb.getName() + " is already registered";
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        multiblocks.put(mb.getName(), mb);
    }

    @Override
    @NotNull
    public Multiblock getMultiblock(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Multiblock multiblock = multiblocks.get(name);
        if (multiblock == null) {
            String string = "Unregistered magneticraft Multiblock: " + name + ", Please contact with the author";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return multiblock;
    }

    public final void registerDefaults() {
        this.registerMultiblock(MultiblockSolarPanel.INSTANCE);
        this.registerMultiblock(MultiblockShelvingUnit.INSTANCE);
        this.registerMultiblock(MultiblockSteamEngine.INSTANCE);
        this.registerMultiblock(MultiblockGrinder.INSTANCE);
        this.registerMultiblock(MultiblockSieve.INSTANCE);
        this.registerMultiblock(MultiblockSolarTower.INSTANCE);
        this.registerMultiblock(MultiblockSolarMirror.INSTANCE);
        this.registerMultiblock(MultiblockContainer.INSTANCE);
        this.registerMultiblock(MultiblockPumpjack.INSTANCE);
        this.registerMultiblock(MultiblockHydraulicPress.INSTANCE);
        this.registerMultiblock(MultiblockOilHeater.INSTANCE);
        this.registerMultiblock(MultiblockRefinery.INSTANCE);
        this.registerMultiblock(MultiblockBigCombustionChamber.INSTANCE);
        this.registerMultiblock(MultiblockBigSteamBoiler.INSTANCE);
        this.registerMultiblock(MultiblockSteamTurbine.INSTANCE);
        this.registerMultiblock(MultiblockBigElectricFurnace.INSTANCE);
    }

    @Override
    @NotNull
    public Map<String, IMultiblock> getRegisteredMultiblocks() {
        return MapsKt.toMutableMap(multiblocks);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ITextComponent> checkMultiblockStructure(@NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean bl = false;
        List list = new ArrayList();
        int n = 0;
        List data = new ArrayList();
        n = 0;
        int n2 = context.getMultiblock().getSize().func_177956_o();
        while (n < n2) {
            void j;
            int n3 = 0;
            int n4 = context.getMultiblock().getSize().func_177958_n();
            while (n3 < n4) {
                void i;
                int n5 = 0;
                int n6 = context.getMultiblock().getSize().func_177952_p();
                while (n5 < n6) {
                    void k;
                    BlockPos pos = this.applyFacing(context, new BlockPos((int)i, (int)j, (int)k));
                    IMultiblockComponent comp = CollectionsKt.get(context.getMultiblock().getScheme(), (int)i, (int)j, (int)k);
                    List<ITextComponent> res = comp.checkBlock(pos, context);
                    data.add(comp.getBlockData(pos, context));
                    Collection collection = res;
                    boolean bl2 = false;
                    if (!collection.isEmpty()) {
                        list.addAll((Collection)res);
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        list.addAll((Collection)context.getMultiblock().checkExtraRequirements(data, context));
        MinecraftForge.EVENT_BUS.post((Event)new MultiBlockEvent.CheckIntegrity(context.getMultiblock(), context.getWorld(), context.getCenter(), context.getFacing(), context.getPlayer(), list));
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final void activateMultiblockStructure(@NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int n = 0;
        List data = new ArrayList();
        try {
            n = 0;
            int n2 = context.getMultiblock().getSize().func_177956_o();
            while (n < n2) {
                void j;
                int n3 = 0;
                int n4 = context.getMultiblock().getSize().func_177958_n();
                while (n3 < n4) {
                    void i;
                    int n5 = 0;
                    int n6 = context.getMultiblock().getSize().func_177952_p();
                    while (n5 < n6) {
                        void k;
                        BlockPos pos = this.applyFacing(context, new BlockPos((int)i, (int)j, (int)k));
                        IMultiblockComponent comp = CollectionsKt.get(context.getMultiblock().getScheme(), (int)i, (int)j, (int)k);
                        comp.activateBlock(pos, context);
                        data.add(comp.getBlockData(pos, context));
                        ++k;
                    }
                    ++i;
                }
                ++j;
            }
            context.getMultiblock().onActivate(data, context);
            MinecraftForge.EVENT_BUS.post((Event)new MultiBlockEvent.Activate(context.getMultiblock(), context.getWorld(), context.getCenter(), context.getFacing()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.deactivateMultiblockStructure(context);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void deactivateMultiblockStructure(@NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int n = 0;
        List data = new ArrayList();
        n = 0;
        int n2 = context.getMultiblock().getSize().func_177956_o();
        while (n < n2) {
            void j;
            int n3 = 0;
            int n4 = context.getMultiblock().getSize().func_177958_n();
            while (n3 < n4) {
                void i;
                int n5 = 0;
                int n6 = context.getMultiblock().getSize().func_177952_p();
                while (n5 < n6) {
                    void k;
                    BlockPos pos = this.applyFacing(context, new BlockPos((int)i, (int)j, (int)k));
                    IMultiblockComponent comp = CollectionsKt.get(context.getMultiblock().getScheme(), (int)i, (int)j, (int)k);
                    comp.deactivateBlock(pos, context);
                    data.add(comp.getBlockData(pos, context));
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        context.getMultiblock().onDeactivate(data, context);
        MinecraftForge.EVENT_BUS.post((Event)new MultiBlockEvent.Deactivate(context.getMultiblock(), context.getWorld(), context.getCenter(), context.getFacing()));
    }

    @NotNull
    public final BlockPos applyFacing(@NotNull MultiblockContext context, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        BlockPos center = context.getMultiblock().getCenter();
        BlockPos origin = pos.func_177973_b((Vec3i)center);
        BlockPos blockPos = BlockPos.field_177992_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"BlockPos.ORIGIN");
        BlockPos blockPos2 = origin;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"origin");
        BlockPos normalized = EnumFacingKt.rotatePoint(EnumFacing.SOUTH, blockPos, blockPos2);
        EnumFacing enumFacing = context.getFacing();
        BlockPos blockPos3 = BlockPos.field_177992_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"BlockPos.ORIGIN");
        return EnumFacingKt.rotatePoint(enumFacing, blockPos3, normalized);
    }

    private MultiblockManager() {
    }

    static {
        MultiblockManager multiblockManager;
        INSTANCE = multiblockManager = new MultiblockManager();
        boolean bl = false;
        multiblocks = new LinkedHashMap();
    }
}

