/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.manual;

import com.cout970.magneticraft.misc.LoggerKt;
import com.cout970.magneticraft.misc.ResourceList;
import com.cout970.magneticraft.systems.manual.Book;
import com.cout970.magneticraft.systems.manual.ChaptersKt;
import com.cout970.magneticraft.systems.manual.MarkdownDocument;
import com.cout970.magneticraft.systems.manual.MdLink;
import com.cout970.magneticraft.systems.manual.MdRenderer;
import com.cout970.magneticraft.systems.manual.MdTag;
import com.cout970.magneticraft.systems.manual.MdText;
import com.cout970.magneticraft.systems.manual.Section;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0002\u001a\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"checkInvalidLinks", "", "sections", "", "Lcom/cout970/magneticraft/systems/manual/Section;", "errorDocument", "Lcom/cout970/magneticraft/systems/manual/MarkdownDocument;", "getLinks", "", "tags", "Lcom/cout970/magneticraft/systems/manual/MdTag;", "loadBook", "Lcom/cout970/magneticraft/systems/manual/Book;", "Magneticraft_1.12"})
public final class ChaptersKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Book loadBook() {
        try {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            List parsed2;
            Object element$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Object object;
            Collection collection;
            void $this$mapTo$iv$iv3;
            String lang;
            List<String> langOptions = ResourceList.INSTANCE.getGuideBookLanguages();
            Minecraft minecraft = Minecraft.func_71410_x();
            Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
            LanguageManager languageManager = minecraft.func_135016_M();
            Intrinsics.checkExpressionValueIsNotNull((Object)languageManager, (String)"Minecraft.getMinecraft().languageManager");
            Language language = languageManager.func_135041_c();
            Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"Minecraft.getMinecraft()\u2026geManager.currentLanguage");
            String currentLang = language.func_135034_a();
            String string = lang = langOptions.contains(currentLang) ? currentLang : "en_us";
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lang");
            List<ResourceLocation> locations = ResourceList.INSTANCE.getGuideBookPages(string);
            Iterable $this$map$iv = locations;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                ResourceLocation resourceLocation = (ResourceLocation)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Minecraft minecraft2 = Minecraft.func_71410_x();
                Intrinsics.checkExpressionValueIsNotNull((Object)minecraft2, (String)"Minecraft.getMinecraft()");
                object = TuplesKt.to((Object)it, (Object)minecraft2.func_110442_L().func_110536_a((ResourceLocation)it));
                collection.add(object);
            }
            List resources = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = resources;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo22 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                Triple triple;
                IResource res;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl2 = false;
                Pair $dstr$loc$res = (Pair)element$iv$iv;
                boolean bl3 = false;
                ResourceLocation loc = (ResourceLocation)$dstr$loc$res.component1();
                IResource iResource = res = (IResource)$dstr$loc$res.component2();
                Intrinsics.checkExpressionValueIsNotNull((Object)iResource, (String)"res");
                InputStream inputStream = iResource.func_110527_b();
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"res.inputStream");
                Object object2 = inputStream;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String text2 = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)object2, charset));
                object2 = text2;
                boolean bl5 = false;
                if (object2.length() == 0) {
                    triple = null;
                } else {
                    String string2 = loc.func_110623_a();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"loc.resourcePath");
                    String name = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string2, (CharSequence)("guide/" + lang + '/')), (CharSequence)".md");
                    String prefix = StringsKt.substringBeforeLast((String)name, (char)'/', (String)"");
                    triple = new Triple((Object)text2, (Object)prefix, (Object)name);
                }
                if (triple == null) continue;
                Triple triple2 = triple;
                boolean bl6 = false;
                boolean bl7 = false;
                Triple it$iv$iv = triple2;
                boolean bl8 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List texts = (List)destination$iv$iv2;
            List list = parsed2 = texts.parallelStream().map(loadBook.parsed.1.INSTANCE).collect(Collectors.toList());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"parsed");
            Iterable $this$map$iv2 = list;
            boolean $i$f$map2 = false;
            Iterable $i$f$mapNotNullTo22 = $this$map$iv2;
            Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void $dstr$md$name;
                element$iv$iv = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl9 = false;
                MarkdownDocument md = (MarkdownDocument)$dstr$md$name.component1();
                String name = (String)$dstr$md$name.component2();
                object = new Section(name, md);
                collection.add(object);
            }
            List sections = (List)destination$iv$iv3;
            ChaptersKt.checkInvalidLinks(sections);
            Iterable $this$map$iv3 = sections;
            boolean $i$f$map3 = false;
            destination$iv$iv3 = $this$map$iv3;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Section bl9 = (Section)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl10 = false;
                object = TuplesKt.to((Object)it.getName(), (Object)it);
                collection.add(object);
            }
            Map pages = MapsKt.toMap((Iterable)((List)destination$iv$iv4));
            Section section = (Section)pages.get("index");
            if (section == null) {
                String string3 = "No index page";
                boolean bl11 = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            Map map = pages;
            Section section2 = section;
            return new Book(section2, map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Book(new Section("Error", ChaptersKt.errorDocument()), MapsKt.emptyMap());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkInvalidLinks(List<Section> sections) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = sections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Section section = (Section)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        Set names = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = sections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Section sec = (Section)element$iv;
            boolean bl = false;
            List<String> links = ChaptersKt.getLinks(sec.getDocument().getRoot());
            String loc = sec.getDocument().getLocation();
            Iterable $this$forEach$iv2 = links;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                String url2 = (String)MdRenderer.INSTANCE.parseUrl(loc, it).getFirst();
                if (names.contains(url2)) continue;
                LoggerKt.logError("Invalid link url: {} at {}", url2, sec.getName());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getLinks(List<? extends MdTag> tags) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Object list$iv$iv;
        MdTag it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = tags;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (MdTag)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ChaptersKt.getLinks(it.getChilds());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List chinkLinks = (List)destination$iv$iv;
        $this$flatMap$iv = tags;
        Collection collection = chinkLinks;
        boolean $i$f$filterIsInstance = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MdLink)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<String> collection2 = (List)destination$iv$iv;
        $this$filterIsInstance$iv = collection2;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (MdLink)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            String string = ((MdLink)it).getUrl();
            collection2.add(string);
        }
        collection2 = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)collection2);
    }

    @NotNull
    public static final MarkdownDocument errorDocument() {
        List tags = CollectionsKt.listOf((Object)new MdText("An Error occurred loading the book, please report to the mod author"));
        return new MarkdownDocument(tags, "");
    }
}

