/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.integration.buildcraft;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import buildcraft.api.fuels.IFuelManager;
import buildcraft.api.mj.MjAPI;
import com.cout970.magneticraft.api.internal.registries.fuel.FluidFuel;
import com.cout970.magneticraft.api.registries.fuel.IFluidFuel;
import com.cout970.magneticraft.api.registries.fuel.IFluidFuelManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u000eH\u0002J\f\u0010\u0016\u001a\u00020\u000e*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\b*\u00020\u0019H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/cout970/magneticraft/systems/integration/buildcraft/BuildcraftFuelManager;", "Lcom/cout970/magneticraft/api/registries/fuel/IFluidFuelManager;", "()V", "parent", "Lbuildcraft/api/fuels/IFuelManager;", "getParent", "()Lbuildcraft/api/fuels/IFuelManager;", "createFuel", "Lcom/cout970/magneticraft/api/registries/fuel/IFluidFuel;", "fluidStack", "Lnet/minecraftforge/fluids/FluidStack;", "burningTime", "", "powerPerCycle", "", "findFuel", "getFuels", "", "registerFuel", "", "recipe", "removeFuel", "convertPower", "", "wrap", "Lbuildcraft/api/fuels/IFuel;", "Magneticraft_1.12"})
public final class BuildcraftFuelManager
implements IFluidFuelManager {
    @NotNull
    public final IFuelManager getParent() {
        IFuelManager iFuelManager = BuildcraftFuelRegistry.fuel;
        if (iFuelManager == null) {
            Intrinsics.throwNpe();
        }
        return iFuelManager;
    }

    @Override
    @Nullable
    public IFluidFuel findFuel(@NotNull FluidStack fluidStack) {
        Intrinsics.checkParameterIsNotNull((Object)fluidStack, (String)"fluidStack");
        IFuel iFuel = this.getParent().getFuel(fluidStack);
        return iFuel != null ? this.wrap(iFuel) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IFluidFuel> getFuels() {
        void $this$mapTo$iv$iv;
        Collection collection = this.getParent().getFuels();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"parent.fuels");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IFuel iFuel = (IFuel)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            IFluidFuel iFluidFuel = this.wrap((IFuel)v1);
            collection2.add(iFluidFuel);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean registerFuel(@NotNull IFluidFuel recipe) {
        Intrinsics.checkParameterIsNotNull((Object)recipe, (String)"recipe");
        return this.getParent().addFuel(recipe.getFluid(), this.convertPower(recipe.getPowerPerCycle()), recipe.getTotalBurningTime()) != null;
    }

    @Override
    public boolean removeFuel(@NotNull IFluidFuel recipe) {
        Intrinsics.checkParameterIsNotNull((Object)recipe, (String)"recipe");
        return false;
    }

    @Override
    @NotNull
    public IFluidFuel createFuel(@NotNull FluidStack fluidStack, int burningTime, double powerPerCycle) {
        Intrinsics.checkParameterIsNotNull((Object)fluidStack, (String)"fluidStack");
        return new FluidFuel(fluidStack, burningTime, powerPerCycle);
    }

    private final IFluidFuel wrap(@NotNull IFuel $this$wrap) {
        FluidStack fluidStack = $this$wrap.getFluid();
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"fluid");
        return new FluidFuel(fluidStack, $this$wrap.getTotalBurningTime(), this.convertPower($this$wrap.getPowerPerCycle()));
    }

    private final double convertPower(long $this$convertPower) {
        return (double)10 * ((double)$this$convertPower / (double)MjAPI.MJ);
    }

    private final long convertPower(double $this$convertPower) {
        return (long)($this$convertPower * (double)MjAPI.MJ / (double)10);
    }
}

