/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.computer;

import com.cout970.magneticraft.api.computer.ICPU;
import com.cout970.magneticraft.api.computer.IDevice;
import com.cout970.magneticraft.api.computer.IMotherboard;
import com.cout970.magneticraft.api.computer.IRAM;
import com.cout970.magneticraft.api.computer.IROM;
import com.cout970.magneticraft.api.computer.IRW;
import com.cout970.magneticraft.api.computer.IResettable;
import com.cout970.magneticraft.systems.computer.Bus;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020\fH\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016J\b\u0010%\u001a\u00020\u001aH\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0006\u0010(\u001a\u00020\u001aJ\b\u0010)\u001a\u00020\u001aH\u0016J\u0014\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cH\u0016J\u000e\u0010\u0018\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\fJ\b\u0010,\u001a\u00020\u001aH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/cout970/magneticraft/systems/computer/Motherboard;", "Lcom/cout970/magneticraft/api/computer/IMotherboard;", "cpu", "Lcom/cout970/magneticraft/api/computer/ICPU;", "ram", "Lcom/cout970/magneticraft/api/computer/IRAM;", "rom", "Lcom/cout970/magneticraft/api/computer/IROM;", "(Lcom/cout970/magneticraft/api/computer/ICPU;Lcom/cout970/magneticraft/api/computer/IRAM;Lcom/cout970/magneticraft/api/computer/IROM;)V", "bus", "Lcom/cout970/magneticraft/systems/computer/Bus;", "clock", "", "cpuCycles", "cyclesPerTick", "getCyclesPerTick", "()I", "setCyclesPerTick", "(I)V", "deviceMap", "Lgnu/trove/map/hash/TIntObjectHashMap;", "Lcom/cout970/magneticraft/api/computer/IDevice;", "getDeviceMap", "()Lgnu/trove/map/hash/TIntObjectHashMap;", "sleep", "deserialize", "", "map", "", "", "", "getBus", "Lcom/cout970/magneticraft/api/computer/IRW;", "getCPU", "getClock", "getRAM", "getROM", "halt", "isOnline", "", "iterate", "reset", "serialize", "ticks", "start", "Companion", "Magneticraft_1.12"})
public final class Motherboard
implements IMotherboard {
    private int cyclesPerTick;
    @NotNull
    private final TIntObjectHashMap<IDevice> deviceMap;
    private final Bus bus;
    private int cpuCycles;
    private int clock;
    private int sleep;
    private final ICPU cpu;
    private final IRAM ram;
    private final IROM rom;
    public static final int CPU_START_POINT = 57344;
    public static final Companion Companion = new Companion(null);

    public final int getCyclesPerTick() {
        return this.cyclesPerTick;
    }

    public final void setCyclesPerTick(int n) {
        this.cyclesPerTick = n;
    }

    @NotNull
    public final TIntObjectHashMap<IDevice> getDeviceMap() {
        return this.deviceMap;
    }

    public final void iterate() {
        if (this.sleep > 0) {
            int n = this.sleep;
            this.sleep = n + -1;
            return;
        }
        if (this.cpuCycles >= 0) {
            this.cpuCycles += this.cyclesPerTick;
            if (this.cpuCycles > this.cyclesPerTick * 10) {
                this.cpuCycles = this.cyclesPerTick * 10;
            }
            while (this.cpuCycles > 0) {
                int n = this.cpuCycles;
                this.cpuCycles = n + -1;
                n = this.clock;
                this.clock = n + 1;
                this.cpu.iterate();
            }
        }
    }

    public final void sleep(int ticks) {
        if (ticks > 0) {
            this.cpuCycles = 0;
            this.sleep = ticks;
        }
    }

    @Override
    public void start() {
        this.cpuCycles = 0;
    }

    @Override
    public void halt() {
        this.cpuCycles = -1;
    }

    @Override
    public boolean isOnline() {
        return this.cpuCycles >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void reset() {
        void $this$filterIsInstanceTo$iv$iv;
        this.clock = 0;
        this.cpu.reset();
        Object[] objectArray = this.deviceMap.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"deviceMap.values()");
        Object[] $this$filterIsInstance$iv = objectArray;
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IResettable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IResettable it = (IResettable)element$iv;
            boolean bl = false;
            it.reset();
        }
        Closeable closeable = this.rom.getBIOS();
        boolean bl = false;
        object = null;
        try {
            int r;
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            int index = 57344;
            while ((r = it.read()) != -1) {
                this.ram.writeByte(index++, (byte)r);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    @Override
    @NotNull
    public IRW getBus() {
        return this.bus;
    }

    @Override
    @NotNull
    public ICPU getCPU() {
        return this.cpu;
    }

    @Override
    @NotNull
    public IRAM getRAM() {
        return this.ram;
    }

    @Override
    @NotNull
    public IROM getROM() {
        return this.rom;
    }

    @Override
    public int getClock() {
        return this.clock;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"sleep", (Object)this.sleep), TuplesKt.to((Object)"cycles", (Object)this.cpuCycles), TuplesKt.to((Object)"cpu", this.cpu.serialize()), TuplesKt.to((Object)"ram", this.ram.serialize())});
    }

    public void deserialize(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Object object = map.get("sleep");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.sleep = (Integer)object;
        Object object2 = map.get("cycles");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.cpuCycles = (Integer)object2;
        Object object3 = map.get("cpu");
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        }
        this.cpu.deserialize((Map)object3);
        Object object4 = map.get("ram");
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        }
        this.ram.deserialize((Map)object4);
    }

    public Motherboard(@NotNull ICPU cpu, @NotNull IRAM ram, @NotNull IROM rom) {
        Intrinsics.checkParameterIsNotNull((Object)cpu, (String)"cpu");
        Intrinsics.checkParameterIsNotNull((Object)ram, (String)"ram");
        Intrinsics.checkParameterIsNotNull((Object)rom, (String)"rom");
        this.cpu = cpu;
        this.ram = ram;
        this.rom = rom;
        this.cyclesPerTick = 50000;
        this.deviceMap = new TIntObjectHashMap();
        this.bus = new Bus(this.ram, (Function1<? super Integer, ? extends IDevice>)((Function1)new Function1<Integer, IDevice>(this){
            final /* synthetic */ Motherboard this$0;

            public final IDevice invoke(int it) {
                return (IDevice)this.this$0.getDeviceMap().get(it);
            }
            {
                this.this$0 = motherboard;
                super(1);
            }
        }));
        this.cpuCycles = -1;
        this.cpu.setMotherboard(this);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cout970/magneticraft/systems/computer/Motherboard$Companion;", "", "()V", "CPU_START_POINT", "", "Magneticraft_1.12"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

