/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.computer;

import com.cout970.magneticraft.api.computer.IDevice;
import com.cout970.magneticraft.api.computer.IRW;
import com.cout970.magneticraft.api.core.ITileRef;
import com.cout970.magneticraft.systems.computer.DeviceRobotControl;
import com.cout970.magneticraft.systems.computer.IMiningRobot;
import com.cout970.magneticraft.systems.computer.ReadOnlyByte;
import com.cout970.magneticraft.systems.computer.ReadOnlyInt;
import com.cout970.magneticraft.systems.computer.ReadOnlyShort;
import com.cout970.magneticraft.systems.computer.ReadWriteByte;
import com.cout970.magneticraft.systems.computer.ReadWriteStruct;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u0011\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J\u0011\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00190\u0019H\u0096\u0001J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u001bJ\b\u0010#\u001a\u00020\u0010H\u0016J \u0010$\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001bH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/cout970/magneticraft/systems/computer/DeviceRobotControl;", "Lcom/cout970/magneticraft/api/computer/IDevice;", "Lcom/cout970/magneticraft/api/core/ITileRef;", "tile", "robot", "Lcom/cout970/magneticraft/systems/computer/IMiningRobot;", "(Lcom/cout970/magneticraft/api/core/ITileRef;Lcom/cout970/magneticraft/systems/computer/IMiningRobot;)V", "memStruct", "Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "getMemStruct", "()Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "getRobot", "()Lcom/cout970/magneticraft/systems/computer/IMiningRobot;", "getTile", "()Lcom/cout970/magneticraft/api/core/ITileRef;", "deserialize", "", "map", "", "", "", "getPos", "Lnet/minecraft/util/math/BlockPos;", "kotlin.jvm.PlatformType", "getWorld", "Lnet/minecraft/world/World;", "readByte", "", "bus", "Lcom/cout970/magneticraft/api/computer/IRW;", "addr", "", "serialize", "signal", "data", "update", "writeByte", "Magneticraft_1.12"})
public final class DeviceRobotControl
implements IDevice,
ITileRef {
    @NotNull
    private final ReadWriteStruct memStruct;
    @NotNull
    private final ITileRef tile;
    @NotNull
    private final IMiningRobot robot;

    @NotNull
    public final ReadWriteStruct getMemStruct() {
        return this.memStruct;
    }

    public final void signal(byte data) {
        byte signal = data;
        switch (signal) {
            case 1: {
                this.robot.move(true);
                break;
            }
            case 2: {
                this.robot.move(false);
                break;
            }
            case 3: {
                this.robot.rotateLeft();
                break;
            }
            case 4: {
                this.robot.rotateRight();
                break;
            }
            case 5: {
                this.robot.rotateUp();
                break;
            }
            case 6: {
                this.robot.rotateDown();
                break;
            }
            case 7: {
                this.robot.mine();
                break;
            }
            case 8: {
                this.robot.scan();
            }
        }
    }

    @Override
    public void update() {
    }

    @Override
    public byte readByte(@NotNull IRW bus2, int addr) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        return this.memStruct.read(addr);
    }

    @Override
    public void writeByte(@NotNull IRW bus2, int addr, byte data) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        this.memStruct.write(addr, data);
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        boolean bl = false;
        return MapsKt.emptyMap();
    }

    public void deserialize(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
    }

    @NotNull
    public final ITileRef getTile() {
        return this.tile;
    }

    @NotNull
    public final IMiningRobot getRobot() {
        return this.robot;
    }

    public DeviceRobotControl(@NotNull ITileRef tile, @NotNull IMiningRobot robot) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        Intrinsics.checkParameterIsNotNull((Object)robot, (String)"robot");
        this.tile = tile;
        this.robot = robot;
        this.memStruct = new ReadWriteStruct("robot", new ReadWriteStruct("device_header", new ReadOnlyByte("online", (Function0<Byte>)((Function0)memStruct.1.INSTANCE)), new ReadOnlyByte("type", (Function0<Byte>)((Function0)memStruct.2.INSTANCE)), new ReadOnlyShort("status", (Function0<Short>)((Function0)memStruct.3.INSTANCE))), new ReadWriteByte("signal", (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(this){
            final /* synthetic */ DeviceRobotControl this$0;

            public final void invoke(byte it) {
                this.this$0.signal(it);
            }
            {
                this.this$0 = deviceRobotControl;
                super(1);
            }
        }), (Function0<Byte>)((Function0)memStruct.5.INSTANCE)), new ReadOnlyByte("requestStatus", (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceRobotControl this$0;

            public final byte invoke() {
                return (byte)this.this$0.getRobot().getStatus().ordinal();
            }
            {
                this.this$0 = deviceRobotControl;
                super(0);
            }
        })), new ReadOnlyByte("cooldown", (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceRobotControl this$0;

            public final byte invoke() {
                return (byte)this.this$0.getRobot().getCooldown();
            }
            {
                this.this$0 = deviceRobotControl;
                super(0);
            }
        })), new ReadOnlyByte("orientation", (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceRobotControl this$0;

            public final byte invoke() {
                return (byte)this.this$0.getRobot().getOrientationFlag();
            }
            {
                this.this$0 = deviceRobotControl;
                super(0);
            }
        })), new ReadOnlyInt("batteryCapacity", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceRobotControl this$0;

            public final int invoke() {
                return this.this$0.getRobot().getBatterySize();
            }
            {
                this.this$0 = deviceRobotControl;
                super(0);
            }
        })), new ReadOnlyInt("batteryEnergy", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceRobotControl this$0;

            public final int invoke() {
                return this.this$0.getRobot().getBatteryCharge();
            }
            {
                this.this$0 = deviceRobotControl;
                super(0);
            }
        })), new ReadOnlyInt("failReason", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceRobotControl this$0;

            public final int invoke() {
                return this.this$0.getRobot().getFailReason();
            }
            {
                this.this$0 = deviceRobotControl;
                super(0);
            }
        })), new ReadOnlyInt("scanResult", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceRobotControl this$0;

            public final int invoke() {
                return this.this$0.getRobot().getScanResult();
            }
            {
                this.this$0 = deviceRobotControl;
                super(0);
            }
        })));
    }

    @Override
    public BlockPos getPos() {
        return this.tile.getPos();
    }

    @Override
    public World getWorld() {
        return this.tile.getWorld();
    }
}

