/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.computer;

import com.cout970.magneticraft.api.computer.IDevice;
import com.cout970.magneticraft.api.computer.IRW;
import com.cout970.magneticraft.api.core.ITileRef;
import com.cout970.magneticraft.systems.computer.DeviceNetworkCard;
import com.cout970.magneticraft.systems.computer.FakeRef;
import com.cout970.magneticraft.systems.computer.ReadOnlyByte;
import com.cout970.magneticraft.systems.computer.ReadOnlyInt;
import com.cout970.magneticraft.systems.computer.ReadOnlyShort;
import com.cout970.magneticraft.systems.computer.ReadWriteByte;
import com.cout970.magneticraft.systems.computer.ReadWriteByteArray;
import com.cout970.magneticraft.systems.computer.ReadWriteInt;
import com.cout970.magneticraft.systems.computer.ReadWriteStruct;
import com.cout970.magneticraft.systems.config.Config;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \\2\u00020\u00012\u00020\u0002:\u0001\\B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010<\u001a\u00020=J\u001c\u0010>\u001a\u00020=2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B0@H\u0016J\u0006\u0010C\u001a\u00020\u0006J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020GH\u0016J-\u0010H\u001a\u00020=2\u0006\u0010I\u001a\u00020\u00062\u0016\u0010J\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010B0K\"\u0004\u0018\u00010BH\u0002\u00a2\u0006\u0002\u0010LJ \u0010M\u001a\u00020=2\u0018\u0010N\u001a\u0014\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020-0OJ\u0006\u0010P\u001a\u00020=J\u0006\u0010Q\u001a\u00020=J\u0018\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0006H\u0016J\u0014\u0010W\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B0@H\u0016J\u000e\u0010X\u001a\u00020=2\u0006\u0010X\u001a\u00020\u0006J\b\u0010Y\u001a\u00020=H\u0016J \u0010Z\u001a\u00020=2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u00062\u0006\u0010[\u001a\u00020SH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\b\"\u0004\b\u0017\u0010\nR\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001b\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b \u0010\bR\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0014R\u001a\u0010'\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\b\"\u0004\b)\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0014\u00102\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\bR\u0011\u00104\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0014R\u001a\u00106\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\b\"\u0004\b8\u0010\nR\u001a\u00109\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\b\"\u0004\b;\u0010\n\u00a8\u0006]"}, d2={"Lcom/cout970/magneticraft/systems/computer/DeviceNetworkCard;", "Lcom/cout970/magneticraft/api/computer/IDevice;", "Lcom/cout970/magneticraft/api/core/ITileRef;", "parent", "(Lcom/cout970/magneticraft/api/core/ITileRef;)V", "connectionError", "", "getConnectionError", "()I", "setConnectionError", "(I)V", "debugLevel", "getDebugLevel", "setDebugLevel", "hardwareLock", "getHardwareLock", "setHardwareLock", "inputBuffer", "", "getInputBuffer", "()[B", "inputBufferPtr", "getInputBufferPtr", "setInputBufferPtr", "internetAllowed", "", "getInternetAllowed", "()Z", "isActive", "setActive", "(Z)V", "maxSockets", "getMaxSockets", "memStruct", "Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "getMemStruct", "()Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "outputBuffer", "getOutputBuffer", "outputBufferPtr", "getOutputBufferPtr", "setOutputBufferPtr", "getParent", "()Lcom/cout970/magneticraft/api/core/ITileRef;", "socket", "Ljava/net/Socket;", "getSocket", "()Ljava/net/Socket;", "setSocket", "(Ljava/net/Socket;)V", "status", "getStatus", "targetIp", "getTargetIp", "targetMac", "getTargetMac", "setTargetMac", "targetPort", "getTargetPort", "setTargetPort", "closeTcpConnection", "", "deserialize", "map", "", "", "", "getMacAddress", "getPos", "Lnet/minecraft/util/math/BlockPos;", "getWorld", "Lnet/minecraft/world/World;", "log", "level", "any", "", "(I[Ljava/lang/Object;)V", "openConnection", "factory", "Lkotlin/Function2;", "openTcpConnection", "openTcpSslConnection", "readByte", "", "bus", "Lcom/cout970/magneticraft/api/computer/IRW;", "addr", "serialize", "signal", "update", "writeByte", "data", "Companion", "Magneticraft_1.12"})
public final class DeviceNetworkCard
implements IDevice,
ITileRef {
    private final int status = 0;
    private boolean isActive;
    @NotNull
    private final byte[] targetIp;
    private int targetPort;
    private int targetMac;
    @NotNull
    private final byte[] inputBuffer;
    private int inputBufferPtr;
    @NotNull
    private final byte[] outputBuffer;
    private int outputBufferPtr;
    private int hardwareLock;
    private int connectionError;
    private int debugLevel;
    @Nullable
    private Socket socket;
    @NotNull
    private final ReadWriteStruct memStruct;
    @NotNull
    private final ITileRef parent;
    private static int activeSockets;
    public static final int NO_ERROR = 0;
    public static final int INVALID_PORT = 1;
    public static final int INVALID_IP_SIZE = 2;
    public static final int EXCEPTION_PARSING_IP = 3;
    public static final int EXCEPTION_OPEN_SOCKET = 4;
    public static final int INTERNET_NOT_ALLOWED = 5;
    public static final int MAX_SOCKET_REACH = 6;
    public static final int SOCKET_CLOSED = 7;
    public static final int UNABLE_TO_READ_PACKET = 8;
    public static final int UNABLE_TO_SEND_PACKET = 9;
    public static final int INVALID_OUTPUT_BUFFER_POINTER = 10;
    public static final int INVALID_INPUT_BUFFER_POINTER = 11;
    public static final Companion Companion;

    public final int getStatus() {
        return this.status;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final void setActive(boolean bl) {
        this.isActive = bl;
    }

    public final boolean getInternetAllowed() {
        return Config.INSTANCE.getAllowTcpConnections();
    }

    public final int getMaxSockets() {
        return Config.INSTANCE.getMaxTcpConnections();
    }

    @NotNull
    public final byte[] getTargetIp() {
        return this.targetIp;
    }

    public final int getTargetPort() {
        return this.targetPort;
    }

    public final void setTargetPort(int n) {
        this.targetPort = n;
    }

    public final int getTargetMac() {
        return this.targetMac;
    }

    public final void setTargetMac(int n) {
        this.targetMac = n;
    }

    @NotNull
    public final byte[] getInputBuffer() {
        return this.inputBuffer;
    }

    public final int getInputBufferPtr() {
        return this.inputBufferPtr;
    }

    public final void setInputBufferPtr(int n) {
        this.inputBufferPtr = n;
    }

    @NotNull
    public final byte[] getOutputBuffer() {
        return this.outputBuffer;
    }

    public final int getOutputBufferPtr() {
        return this.outputBufferPtr;
    }

    public final void setOutputBufferPtr(int n) {
        this.outputBufferPtr = n;
    }

    public final int getHardwareLock() {
        return this.hardwareLock;
    }

    public final void setHardwareLock(int n) {
        this.hardwareLock = n;
    }

    public final int getConnectionError() {
        return this.connectionError;
    }

    public final void setConnectionError(int n) {
        this.connectionError = n;
    }

    public final int getDebugLevel() {
        return this.debugLevel;
    }

    public final void setDebugLevel(int n) {
        this.debugLevel = n;
    }

    @Nullable
    public final Socket getSocket() {
        return this.socket;
    }

    public final void setSocket(@Nullable Socket socket) {
        this.socket = socket;
    }

    @NotNull
    public final ReadWriteStruct getMemStruct() {
        return this.memStruct;
    }

    public final int getMacAddress() {
        if (Intrinsics.areEqual((Object)this.parent, (Object)FakeRef.INSTANCE)) {
            return (int)2882400001L;
        }
        return this.parent.getPos().hashCode();
    }

    private final void log(int level, Object ... any) {
        if (this.debugLevel > level) {
            String string = ArraysKt.joinToString$default((Object[])any, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    @Override
    public void update() {
        block11: {
            String string;
            boolean bl;
            DeviceNetworkCard deviceNetworkCard;
            int n;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            StringBuilder stringBuilder;
            int n3;
            Socket it;
            block12: {
                Socket socket = this.socket;
                if (socket == null) break block11;
                Socket socket2 = socket;
                boolean bl2 = false;
                boolean bl3 = false;
                it = socket2;
                boolean bl4 = false;
                if (!it.isClosed()) break block12;
                this.connectionError = 7;
                this.closeTcpConnection();
                break block11;
            }
            if (this.hardwareLock != 0) break block11;
            try {
                if (this.outputBufferPtr > this.outputBuffer.length || this.outputBufferPtr < 0) {
                    this.connectionError = 10;
                    this.log(2, "Error INVALID_OUTPUT_BUFFER_POINTER " + this.outputBufferPtr + " not in [0, " + this.outputBuffer.length + ')');
                    this.closeTcpConnection();
                    return;
                }
                if (this.outputBufferPtr > 0) {
                    it.getOutputStream().write(this.outputBuffer, 0, this.outputBufferPtr);
                    if (this.outputBufferPtr > 0) {
                        byte[] byArray = this.outputBuffer;
                        int n4 = 0;
                        n3 = this.outputBufferPtr;
                        stringBuilder = new StringBuilder().append("Sending data: ");
                        n2 = 0;
                        objectArray = objectArray2 = new Object[1];
                        n = 2;
                        deviceNetworkCard = this;
                        bl = false;
                        string = new String(byArray, n4, n3, Charsets.UTF_8);
                        objectArray2[n2] = stringBuilder.append(string).toString();
                        deviceNetworkCard.log(n, objectArray);
                    }
                    this.outputBufferPtr = 0;
                }
            }
            catch (Exception e) {
                this.connectionError = 9;
                this.log(2, "Error UNABLE_TO_SEND_PACKET");
                this.closeTcpConnection();
                e.printStackTrace();
            }
            try {
                if (this.inputBufferPtr > this.inputBuffer.length || this.inputBufferPtr < 0) {
                    this.connectionError = 11;
                    this.log(2, "Error INVALID_INPUT_BUFFER_POINTER " + this.inputBufferPtr + " no in [0, " + this.inputBuffer.length + ')');
                    this.closeTcpConnection();
                    return;
                }
                if (this.inputBufferPtr != 0) break block11;
                int read2 = it.getInputStream().read(this.inputBuffer, 0, this.inputBuffer.length);
                if (read2 > 0) {
                    this.inputBufferPtr += read2;
                    byte[] byArray = this.inputBuffer;
                    n3 = 0;
                    stringBuilder = new StringBuilder().append("Receiving data: ");
                    n2 = 0;
                    objectArray = objectArray2 = new Object[1];
                    n = 2;
                    deviceNetworkCard = this;
                    bl = false;
                    string = new String(byArray, n3, read2, Charsets.UTF_8);
                    objectArray2[n2] = stringBuilder.append(string).toString();
                    deviceNetworkCard.log(n, objectArray);
                } else if (read2 == -1) {
                    this.connectionError = 7;
                    this.closeTcpConnection();
                }
            }
            catch (Exception e) {
                this.connectionError = 8;
                this.log(2, "Error UNABLE_TO_READ_PACKET");
                this.closeTcpConnection();
                e.printStackTrace();
            }
        }
    }

    public final void signal(int signal) {
        switch (signal) {
            case 1: {
                this.openTcpConnection();
                break;
            }
            case 2: {
                this.closeTcpConnection();
                break;
            }
            case 3: {
                this.openTcpSslConnection();
            }
        }
    }

    public final void closeTcpConnection() {
        Socket socket = this.socket;
        if (socket != null) {
            Socket socket2 = socket;
            boolean bl = false;
            boolean bl2 = false;
            Socket it = socket2;
            boolean bl3 = false;
            this.log(1, "Closing connection");
            int n = activeSockets;
            activeSockets = n + -1;
            it.close();
        }
        this.socket = null;
    }

    public final void openTcpConnection() {
        this.openConnection((Function2<? super String, ? super Integer, ? extends Socket>)((Function2)openTcpConnection.1.INSTANCE));
    }

    public final void openTcpSslConnection() {
        this.openConnection((Function2<? super String, ? super Integer, ? extends Socket>)((Function2)openTcpSslConnection.1.INSTANCE));
    }

    public final void openConnection(@NotNull Function2<? super String, ? super Integer, ? extends Socket> factory) {
        Intrinsics.checkParameterIsNotNull(factory, (String)"factory");
        this.log(1, "Opening connection");
        if (!this.getInternetAllowed()) {
            this.connectionError = 5;
            this.log(1, "Error: INTERNET_NOT_ALLOWED");
            return;
        }
        if (activeSockets >= this.getMaxSockets()) {
            this.connectionError = 6;
            this.log(1, "Error: MAX_SOCKET_REACH");
            return;
        }
        if (this.targetPort <= 0 || this.targetPort > 65535) {
            this.connectionError = 1;
            this.log(1, "Error: INVALID_PORT");
            return;
        }
        String ipStr = null;
        try {
            int size = ArraysKt.indexOf((byte[])this.targetIp, (byte)0);
            if (size == -1 || size >= 80) {
                this.connectionError = 2;
                return;
            }
            byte[] tmp = new byte[size];
            System.arraycopy(this.targetIp, 0, tmp, 0, size);
            byte[] byArray = tmp;
            Charset charset = Charset.forName("US-ASCII");
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"US-ASCII\")");
            Charset charset2 = charset;
            boolean bl = false;
            boolean bl2 = false;
            ipStr = new String(byArray, charset2);
            this.log(1, "Ip parsed: '" + ipStr + '\'');
        }
        catch (Exception e) {
            e.printStackTrace();
            this.connectionError = 3;
            this.log(1, "Error: EXCEPTION_PARSING_IP");
            return;
        }
        try {
            this.socket = (Socket)factory.invoke((Object)ipStr, (Object)this.targetPort);
            this.connectionError = 0;
            int e = activeSockets;
            activeSockets = e + 1;
            this.outputBufferPtr = 0;
            this.inputBufferPtr = 0;
            this.log(1, "Socket created with ip '" + ipStr + "' and port '" + this.targetPort + '\'');
        }
        catch (Exception e) {
            e.printStackTrace();
            this.connectionError = 4;
            this.log(1, "Error: EXCEPTION_OPEN_SOCKET");
            this.closeTcpConnection();
        }
    }

    @Override
    public byte readByte(@NotNull IRW bus2, int addr) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        return this.memStruct.read(addr);
    }

    @Override
    public void writeByte(@NotNull IRW bus2, int addr, byte data) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        this.memStruct.write(addr, data);
    }

    @Override
    @NotNull
    public World getWorld() {
        World world = this.parent.getWorld();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"parent.world");
        return world;
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        BlockPos blockPos = this.parent.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"parent.pos");
        return blockPos;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        return MapsKt.emptyMap();
    }

    public void deserialize(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
    }

    @NotNull
    public final ITileRef getParent() {
        return this.parent;
    }

    public DeviceNetworkCard(@NotNull ITileRef parent) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        this.parent = parent;
        this.isActive = true;
        this.targetIp = new byte[80];
        this.inputBuffer = new byte[1024];
        this.outputBuffer = new byte[1024];
        this.memStruct = new ReadWriteStruct("network_header", new ReadWriteStruct("device_header", new ReadOnlyByte("online", (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final byte invoke() {
                return this.this$0.isActive() ? (byte)1 : 0;
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        })), new ReadOnlyByte("type", (Function0<Byte>)((Function0)memStruct.2.INSTANCE)), new ReadOnlyShort("status", (Function0<Short>)((Function0)new Function0<Short>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final short invoke() {
                return (short)this.this$0.getStatus();
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        }))), new ReadOnlyByte("internetAllowed", (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final byte invoke() {
                return this.this$0.getInternetAllowed() ? (byte)1 : 0;
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        })), new ReadOnlyByte("maxSockets", (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final byte invoke() {
                return (byte)this.this$0.getMaxSockets();
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        })), new ReadOnlyByte("activeSockets", (Function0<Byte>)((Function0)memStruct.6.INSTANCE)), new ReadWriteByte("signal", (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final void invoke(byte it) {
                this.this$0.signal(it);
            }
            {
                this.this$0 = deviceNetworkCard;
                super(1);
            }
        }), (Function0<Byte>)((Function0)memStruct.8.INSTANCE)), new ReadOnlyInt("macAddress", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final int invoke() {
                return this.this$0.getMacAddress();
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        })), new ReadWriteInt("targetMac", (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final void invoke(int it) {
                this.this$0.setTargetMac(it);
            }
            {
                this.this$0 = deviceNetworkCard;
                super(1);
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final int invoke() {
                return this.this$0.getTargetMac();
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        })), new ReadWriteInt("targetPort", (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final void invoke(int it) {
                this.this$0.setTargetPort(it);
            }
            {
                this.this$0 = deviceNetworkCard;
                super(1);
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final int invoke() {
                return this.this$0.getTargetPort();
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        })), new ReadWriteByteArray("targetIp", this.targetIp), new ReadOnlyInt("connectionOpen", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final int invoke() {
                Socket socket = this.this$0.getSocket();
                return socket == null || socket.isClosed() ? 0 : 1;
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        })), new ReadOnlyInt("connectionError", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final int invoke() {
                return this.this$0.getConnectionError();
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        })), new ReadWriteInt("inputBufferPtr", (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final void invoke(int it) {
                this.this$0.setInputBufferPtr(it);
            }
            {
                this.this$0 = deviceNetworkCard;
                super(1);
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final int invoke() {
                return this.this$0.getInputBufferPtr();
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        })), new ReadWriteInt("outputBufferPtr", (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final void invoke(int it) {
                this.this$0.setOutputBufferPtr(it);
            }
            {
                this.this$0 = deviceNetworkCard;
                super(1);
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final int invoke() {
                return this.this$0.getOutputBufferPtr();
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        })), new ReadWriteInt("hardwareLock", (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final void invoke(int it) {
                this.this$0.setHardwareLock(it);
            }
            {
                this.this$0 = deviceNetworkCard;
                super(1);
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceNetworkCard this$0;

            public final int invoke() {
                return this.this$0.getHardwareLock();
            }
            {
                this.this$0 = deviceNetworkCard;
                super(0);
            }
        })), new ReadWriteByteArray("inputBuffer", this.inputBuffer), new ReadWriteByteArray("outputBuffer ", this.outputBuffer));
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/cout970/magneticraft/systems/computer/DeviceNetworkCard$Companion;", "", "()V", "EXCEPTION_OPEN_SOCKET", "", "EXCEPTION_PARSING_IP", "INTERNET_NOT_ALLOWED", "INVALID_INPUT_BUFFER_POINTER", "INVALID_IP_SIZE", "INVALID_OUTPUT_BUFFER_POINTER", "INVALID_PORT", "MAX_SOCKET_REACH", "NO_ERROR", "SOCKET_CLOSED", "UNABLE_TO_READ_PACKET", "UNABLE_TO_SEND_PACKET", "activeSockets", "getActiveSockets", "()I", "setActiveSockets", "(I)V", "Magneticraft_1.12"})
    public static final class Companion {
        public final int getActiveSockets() {
            return activeSockets;
        }

        public final void setActiveSockets(int n) {
            activeSockets = n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

