/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.computer;

import com.cout970.magneticraft.api.computer.IDevice;
import com.cout970.magneticraft.api.computer.IRW;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/cout970/magneticraft/systems/computer/Bus;", "Lcom/cout970/magneticraft/api/computer/IRW;", "ram", "getDevice", "Lkotlin/Function1;", "", "Lcom/cout970/magneticraft/api/computer/IDevice;", "(Lcom/cout970/magneticraft/api/computer/IRW;Lkotlin/jvm/functions/Function1;)V", "getGetDevice", "()Lkotlin/jvm/functions/Function1;", "getRam", "()Lcom/cout970/magneticraft/api/computer/IRW;", "setRam", "(Lcom/cout970/magneticraft/api/computer/IRW;)V", "readByte", "", "addr", "readWord", "writeByte", "", "data", "writeWord", "isExternal", "", "Magneticraft_1.12"})
public final class Bus
implements IRW {
    @NotNull
    private IRW ram;
    @NotNull
    private final Function1<Integer, IDevice> getDevice;

    private final boolean isExternal(int $this$isExternal) {
        return $this$isExternal >>> 24 == 255;
    }

    @Override
    public byte readByte(int addr) {
        if (this.isExternal(addr)) {
            int ext = addr >> 16 & 0xFF;
            IDevice iDevice = (IDevice)this.getDevice.invoke((Object)ext);
            if (iDevice == null) {
                return 0;
            }
            IDevice dev = iDevice;
            return dev.readByte(this, addr & 0xFFFF);
        }
        return this.ram.readByte(addr);
    }

    @Override
    public void writeByte(int addr, byte data) {
        if (this.isExternal(addr)) {
            int ext = addr >> 16 & 0xFF;
            IDevice iDevice = (IDevice)this.getDevice.invoke((Object)ext);
            if (iDevice == null) {
                return;
            }
            IDevice dev = iDevice;
            dev.writeByte(this, addr & 0xFFFF, data);
        } else {
            this.ram.writeByte(addr, data);
        }
    }

    @Override
    public void writeWord(int addr, int data) {
        if (this.isExternal(addr)) {
            int ext = addr >> 16 & 0xFF;
            IDevice iDevice = (IDevice)this.getDevice.invoke((Object)ext);
            if (iDevice == null) {
                return;
            }
            IDevice dev = iDevice;
            byte a = (byte)(data >> 24 & 0xFF);
            byte b = (byte)(data >> 16 & 0xFF);
            byte c = (byte)(data >> 8 & 0xFF);
            byte d = (byte)(data & 0xFF);
            dev.writeByte(this, addr + 3 & 0xFFFF, a);
            dev.writeByte(this, addr + 2 & 0xFFFF, b);
            dev.writeByte(this, addr + 1 & 0xFFFF, c);
            dev.writeByte(this, addr & 0xFFFF, d);
        } else {
            this.ram.writeWord(addr, data);
        }
    }

    @Override
    public int readWord(int addr) {
        if (this.isExternal(addr)) {
            int ext = addr >> 16 & 0xFF;
            IDevice iDevice = (IDevice)this.getDevice.invoke((Object)ext);
            if (iDevice == null) {
                return 0;
            }
            IDevice dev = iDevice;
            byte a = dev.readByte(this, addr + 3 & 0xFFFF);
            byte b = dev.readByte(this, addr + 2 & 0xFFFF);
            byte c = dev.readByte(this, addr + 1 & 0xFFFF);
            byte d = dev.readByte(this, addr & 0xFFFF);
            int ai = (a & 0xFF) << 24;
            int bi = (b & 0xFF) << 16;
            int ci = (c & 0xFF) << 8;
            int di = d & 0xFF;
            return ai | bi | ci | di;
        }
        return this.ram.readWord(addr);
    }

    @NotNull
    public final IRW getRam() {
        return this.ram;
    }

    public final void setRam(@NotNull IRW iRW) {
        Intrinsics.checkParameterIsNotNull((Object)iRW, (String)"<set-?>");
        this.ram = iRW;
    }

    @NotNull
    public final Function1<Integer, IDevice> getGetDevice() {
        return this.getDevice;
    }

    public Bus(@NotNull IRW ram, @NotNull Function1<? super Integer, ? extends IDevice> getDevice) {
        Intrinsics.checkParameterIsNotNull((Object)ram, (String)"ram");
        Intrinsics.checkParameterIsNotNull(getDevice, (String)"getDevice");
        this.ram = ram;
        this.getDevice = getDevice;
    }
}

