/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.misc.vector;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u0000 :2\u00020\u0001:\u0001:B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001c\u001a\u00020\u0000J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0004J\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\u001d\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00072\b\b\u0002\u0010\u0004\u001a\u00020\u0007H\u00c6\u0001J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010'\u001a\u00020\u0000J\t\u0010(\u001a\u00020\u0014H\u00d6\u0001J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010+\u001a\u00020\u0000J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003H\u0086\u0002J\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070.J\u001d\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000.2\u0006\u0010&\u001a\u00020\u0000H\u0086\u0004J\t\u00100\u001a\u000201H\u00d6\u0001J\u001a\u00102\u001a\u00020\u00002\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000704J\t\u00105\u001a\u00020\u0000H\u0086\u0002J\u0011\u00106\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\bJ\u0011\u00107\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003H\u0086\bJ\u0006\u00108\u001a\u00020\u0000J\u0006\u00109\u001a\u00020\u0000R\u0011\u0010\t\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u001a\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0016\u00a8\u0006;"}, d2={"Lcom/cout970/magneticraft/misc/vector/Vec2d;", "", "x", "", "y", "(Ljava/lang/Number;Ljava/lang/Number;)V", "(Ljava/lang/Number;)V", "", "(DD)V", "length", "getLength", "()D", "lengthSquared", "getLengthSquared", "getX", "xf", "", "getXf", "()F", "xi", "", "getXi", "()I", "getY", "yf", "getYf", "yi", "getYi", "center", "centeredAt", "pos", "component1", "component2", "copy", "div", "v", "equals", "", "other", "floor", "hashCode", "minus", "plus", "swap", "times", "toPair", "Lkotlin/Pair;", "toPoint", "toString", "", "transform", "op", "Lkotlin/Function1;", "unaryMinus", "withX", "withY", "xCenter", "yCenter", "Companion", "Magneticraft_1.12"})
public final class Vec2d {
    private final double x;
    private final double y;
    @NotNull
    private static final Vec2d ZERO;
    public static final Companion Companion;

    public final double getLengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public final double getLength() {
        return Math.sqrt(this.getLengthSquared());
    }

    public final float getXf() {
        return (float)this.x;
    }

    public final float getYf() {
        return (float)this.y;
    }

    public final int getXi() {
        return (int)this.x;
    }

    public final int getYi() {
        return (int)this.y;
    }

    @NotNull
    public final Pair<Double, Double> toPair() {
        return TuplesKt.to((Object)this.x, (Object)this.y);
    }

    @NotNull
    public final Vec2d swap() {
        return new Vec2d(this.y, this.x);
    }

    @NotNull
    public final Vec2d withX(@NotNull Number x) {
        int $i$f$withX = 0;
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        return new Vec2d(x.doubleValue(), this.getY());
    }

    @NotNull
    public final Vec2d withY(@NotNull Number y) {
        int $i$f$withY = 0;
        Intrinsics.checkParameterIsNotNull((Object)y, (String)"y");
        return new Vec2d(this.getX(), y.doubleValue());
    }

    @NotNull
    public final Vec2d plus(@NotNull Number v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new Vec2d(v.doubleValue() + this.x, v.doubleValue() + this.y);
    }

    @NotNull
    public final Vec2d plus(@NotNull Vec2d v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new Vec2d(v.x + this.x, v.y + this.y);
    }

    @NotNull
    public final Vec2d minus(@NotNull Number v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new Vec2d(this.x - v.doubleValue(), this.y - v.doubleValue());
    }

    @NotNull
    public final Vec2d minus(@NotNull Vec2d v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new Vec2d(this.x - v.x, this.y - v.y);
    }

    @NotNull
    public final Vec2d times(@NotNull Vec2d v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new Vec2d(v.x * this.x, v.y * this.y);
    }

    @NotNull
    public final Vec2d times(@NotNull Number v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new Vec2d(v.doubleValue() * this.x, v.doubleValue() * this.y);
    }

    @NotNull
    public final Vec2d div(@NotNull Vec2d v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new Vec2d(this.x / v.x, this.y / v.y);
    }

    @NotNull
    public final Vec2d div(@NotNull Number v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new Vec2d(this.x / v.doubleValue(), this.y / v.doubleValue());
    }

    @NotNull
    public final Vec2d unaryMinus() {
        return new Vec2d(-this.x, -this.y);
    }

    @NotNull
    public final Vec2d center() {
        return new Vec2d(this.x / (double)2, this.y / (double)2);
    }

    @NotNull
    public final Vec2d xCenter() {
        return new Vec2d(this.x / (double)2, this.y);
    }

    @NotNull
    public final Vec2d yCenter() {
        return new Vec2d(this.x, this.y / (double)2);
    }

    @NotNull
    public final Vec2d centeredAt(@NotNull Vec2d pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.minus(this.center());
    }

    @NotNull
    public final Vec2d centeredAt(@NotNull Number x, @NotNull Number y) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull((Object)y, (String)"y");
        return new Vec2d(x, y).minus(this.center());
    }

    @NotNull
    public final Pair<Vec2d, Vec2d> toPoint(@NotNull Vec2d other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Pair((Object)this, (Object)other.minus(this));
    }

    @NotNull
    public final Vec2d floor() {
        return new Vec2d((Number)((int)this.x), (Number)((int)this.y));
    }

    @NotNull
    public final Vec2d transform(@NotNull Function1<? super Double, Double> op) {
        Intrinsics.checkParameterIsNotNull(op, (String)"op");
        return new Vec2d(((Number)op.invoke((Object)this.x)).doubleValue(), ((Number)op.invoke((Object)this.y)).doubleValue());
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vec2d(@NotNull Number x, @NotNull Number y) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull((Object)y, (String)"y");
        this(x.doubleValue(), y.doubleValue());
    }

    public Vec2d(@NotNull Number x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        this(x.doubleValue(), x.doubleValue());
    }

    static {
        Companion = new Companion(null);
        ZERO = new Vec2d(0.0, 0.0);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final Vec2d copy(double x, double y) {
        return new Vec2d(x, y);
    }

    public static /* synthetic */ Vec2d copy$default(Vec2d vec2d, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = vec2d.x;
        }
        if ((n & 2) != 0) {
            d2 = vec2d.y;
        }
        return vec2d.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Vec2d(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        return (int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vec2d)) break block3;
                Vec2d vec2d = (Vec2d)object;
                if (Double.compare(this.x, vec2d.x) != 0 || Double.compare(this.y, vec2d.y) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cout970/magneticraft/misc/vector/Vec2d$Companion;", "", "()V", "ZERO", "Lcom/cout970/magneticraft/misc/vector/Vec2d;", "getZERO", "()Lcom/cout970/magneticraft/misc/vector/Vec2d;", "Magneticraft_1.12"})
    public static final class Companion {
        @NotNull
        public final Vec2d getZERO() {
            return ZERO;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

