/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.internal.registries.fuel;

import com.cout970.magneticraft.api.internal.registries.fuel.FluidFuel;
import com.cout970.magneticraft.api.registries.fuel.IFluidFuel;
import com.cout970.magneticraft.api.registries.fuel.IFluidFuelManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u0012\u0010\u0003\u001a\u00020\u00018\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/cout970/magneticraft/api/internal/registries/fuel/FluidFuelManager;", "Lcom/cout970/magneticraft/api/registries/fuel/IFluidFuelManager;", "()V", "FLUID_FUEL_MANAGER", "fuels", "", "Lcom/cout970/magneticraft/api/registries/fuel/IFluidFuel;", "createFuel", "fluidStack", "Lnet/minecraftforge/fluids/FluidStack;", "burningTime", "", "powerPerCycle", "", "findFuel", "getFuels", "registerFuel", "", "recipe", "removeFuel", "Magneticraft_1.12"})
public final class FluidFuelManager
implements IFluidFuelManager {
    @JvmField
    @NotNull
    public static IFluidFuelManager FLUID_FUEL_MANAGER;
    private static final List<IFluidFuel> fuels;
    public static final FluidFuelManager INSTANCE;

    @Override
    @Nullable
    public IFluidFuel findFuel(@NotNull FluidStack fluidStack) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)fluidStack, (String)"fluidStack");
            Iterable $this$firstOrNull$iv = fuels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IFluidFuel it = (IFluidFuel)element$iv;
                boolean bl = false;
                if (!it.matches(fluidStack)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    public List<IFluidFuel> getFuels() {
        List<IFluidFuel> list = Collections.unmodifiableList(fuels);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(fuels)");
        return list;
    }

    @Override
    public boolean registerFuel(@NotNull IFluidFuel recipe) {
        Intrinsics.checkParameterIsNotNull((Object)recipe, (String)"recipe");
        FluidStack fluidStack = recipe.getFluid();
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"recipe.fluid");
        if (this.findFuel(fluidStack) != null) {
            return false;
        }
        if ((double)recipe.getTotalBurningTime() <= 0.0) {
            return false;
        }
        if (recipe.getPowerPerCycle() <= 0.0) {
            return false;
        }
        Collection collection = fuels;
        boolean bl = false;
        collection.add(recipe);
        return true;
    }

    @Override
    public boolean removeFuel(@NotNull IFluidFuel recipe) {
        Intrinsics.checkParameterIsNotNull((Object)recipe, (String)"recipe");
        return fuels.remove(recipe);
    }

    @Override
    @NotNull
    public IFluidFuel createFuel(@NotNull FluidStack fluidStack, int burningTime, double powerPerCycle) {
        Intrinsics.checkParameterIsNotNull((Object)fluidStack, (String)"fluidStack");
        return new FluidFuel(fluidStack, burningTime, powerPerCycle);
    }

    private FluidFuelManager() {
    }

    static {
        FluidFuelManager fluidFuelManager;
        INSTANCE = fluidFuelManager = new FluidFuelManager();
        FLUID_FUEL_MANAGER = INSTANCE;
        boolean bl = false;
        fuels = new ArrayList();
    }
}

