/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.internal.heat;

import com.cout970.magneticraft.api.core.ITileRef;
import com.cout970.magneticraft.api.core.NodeID;
import com.cout970.magneticraft.api.heat.IHeatNode;
import com.cout970.magneticraft.api.internal.heat.HeatNodeKt;
import com.cout970.magneticraft.misc.HeatKt;
import com.cout970.magneticraft.misc.NBTKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0012H\u0016J\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0005J\u000e\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u0005J\b\u0010)\u001a\u00020\bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006*"}, d2={"Lcom/cout970/magneticraft/api/internal/heat/HeatNode;", "Lcom/cout970/magneticraft/api/heat/IHeatNode;", "ref", "Lcom/cout970/magneticraft/api/core/ITileRef;", "mass", "", "conductivity", "name", "", "(Lcom/cout970/magneticraft/api/core/ITileRef;DDLjava/lang/String;)V", "internalEnergy", "getRef", "()Lcom/cout970/magneticraft/api/core/ITileRef;", "applyHeat", "", "heat", "deserializeNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "equals", "", "other", "", "getConductivity", "getId", "Lcom/cout970/magneticraft/api/core/NodeID;", "getInternalEnergy", "getMass", "getMolarMass", "getPos", "Lnet/minecraft/util/math/BlockPos;", "getTemperature", "getWorld", "Lnet/minecraft/world/World;", "hashCode", "", "serializeNBT", "setInternalEnergy", "e", "setTemperature", "temp", "toString", "Magneticraft_1.12"})
public final class HeatNode
implements IHeatNode {
    private double internalEnergy;
    @NotNull
    private final ITileRef ref;
    private final double mass;
    private final double conductivity;
    private final String name;

    @Override
    @NotNull
    public World getWorld() {
        World world = this.ref.getWorld();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"ref.world");
        return world;
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        BlockPos blockPos = this.ref.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"ref.pos");
        return blockPos;
    }

    @Override
    @NotNull
    public NodeID getId() {
        BlockPos blockPos = this.getPos();
        WorldProvider worldProvider = this.getWorld().field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
        return new NodeID(this.name, blockPos, worldProvider.getDimension());
    }

    @Override
    public double getTemperature() {
        double moles = this.mass * (double)1000 / this.getMolarMass();
        return 0.6666666666666666 * this.internalEnergy / (moles * 8.3144598);
    }

    public final void setTemperature(double temp) {
        double d = 0.0;
        boolean bl = false;
        double temperature = Math.max(d, temp);
        this.internalEnergy = HeatNodeKt.tempToEnergy(this, temperature);
    }

    @Override
    public double getInternalEnergy() {
        return this.internalEnergy;
    }

    public final void setInternalEnergy(double e) {
        double d;
        double d2 = 0.0;
        HeatNode heatNode = this;
        boolean bl = false;
        heatNode.internalEnergy = d = Math.max(d2, e);
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public double getMolarMass() {
        return 55.845;
    }

    @Override
    public double getConductivity() {
        return this.conductivity;
    }

    @Override
    public void applyHeat(double heat) {
        double d;
        double d2 = 0.0;
        double d3 = this.internalEnergy + heat;
        HeatNode heatNode = this;
        boolean bl = false;
        heatNode.internalEnergy = d = Math.max(d2, d3);
    }

    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        this.internalEnergy = nbt2.func_74769_h("U");
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        return NBTKt.newNbt((Function1<? super NBTTagCompound, Unit>)((Function1)new Function1<NBTTagCompound, Unit>(this){
            final /* synthetic */ HeatNode this$0;

            public final void invoke(@NotNull NBTTagCompound $this$newNbt) {
                Intrinsics.checkParameterIsNotNull((Object)$this$newNbt, (String)"$receiver");
                $this$newNbt.func_74780_a("U", HeatNode.access$getInternalEnergy$p(this.this$0));
            }
            {
                this.this$0 = heatNode;
                super(1);
            }
        }));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HeatNode)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.ref, (Object)((HeatNode)other).ref) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.name, (Object)((HeatNode)other).name) ^ true);
    }

    public int hashCode() {
        int result = this.ref.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "HeatNode(mass=" + this.mass + ", internalEnergy=" + this.internalEnergy + ')';
    }

    @NotNull
    public final ITileRef getRef() {
        return this.ref;
    }

    public HeatNode(@NotNull ITileRef ref, double mass, double conductivity, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.ref = ref;
        this.mass = mass;
        this.conductivity = conductivity;
        this.name = name;
        this.setTemperature(HeatKt.getSTANDARD_AMBIENT_TEMPERATURE());
    }

    public /* synthetic */ HeatNode(ITileRef iTileRef, double d, double d2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        if ((n & 4) != 0) {
            d2 = 73.0;
        }
        if ((n & 8) != 0) {
            string = "heat_node_1";
        }
        this(iTileRef, d, d2, string);
    }

    public static final /* synthetic */ double access$getInternalEnergy$p(HeatNode $this) {
        return $this.internalEnergy;
    }

    public static final /* synthetic */ void access$setInternalEnergy$p(HeatNode $this, double d) {
        $this.internalEnergy = d;
    }
}

