/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.internal.heat;

import com.cout970.magneticraft.api.heat.IHeatConnection;
import com.cout970.magneticraft.api.heat.IHeatNode;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/cout970/magneticraft/api/internal/heat/HeatConnection;", "Lcom/cout970/magneticraft/api/heat/IHeatConnection;", "firstNode", "Lcom/cout970/magneticraft/api/heat/IHeatNode;", "secondNode", "(Lcom/cout970/magneticraft/api/heat/IHeatNode;Lcom/cout970/magneticraft/api/heat/IHeatNode;)V", "equals", "", "other", "", "getFirstNode", "getSecondNode", "getSeparationDistance", "", "hashCode", "", "iterate", "", "toString", "", "Magneticraft_1.12"})
public class HeatConnection
implements IHeatConnection {
    private final IHeatNode firstNode;
    private final IHeatNode secondNode;

    @Override
    @NotNull
    public IHeatNode getFirstNode() {
        return this.firstNode;
    }

    @Override
    @NotNull
    public IHeatNode getSecondNode() {
        return this.secondNode;
    }

    @Override
    public double getSeparationDistance() {
        BlockPos blockPos = this.firstNode.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"firstNode.pos");
        BlockPos blockPos2 = this.secondNode.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"secondNode.pos");
        return BlockPosKt.getLength(BlockPosKt.minus(blockPos, blockPos2));
    }

    @Override
    public void iterate() {
        double conductivity = 1.0 / (1.0 / this.firstNode.getConductivity() + 1.0 / this.secondNode.getConductivity());
        double tempDiff = this.firstNode.getTemperature() - this.secondNode.getTemperature();
        double heatTransfer = -conductivity * tempDiff / this.getSeparationDistance();
        this.secondNode.applyHeat(-heatTransfer);
        this.firstNode.applyHeat(heatTransfer);
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof IHeatConnection) {
            return Intrinsics.areEqual((Object)this.firstNode, (Object)((IHeatConnection)other).getFirstNode()) && Intrinsics.areEqual((Object)this.secondNode, (Object)((IHeatConnection)other).getSecondNode());
        }
        return super.equals(other);
    }

    public int hashCode() {
        return (super.hashCode() * 31 + this.firstNode.hashCode()) * 31 + this.secondNode.hashCode();
    }

    @NotNull
    public String toString() {
        return "HeatConnection(firstNode=" + this.firstNode + ", secondNode=" + this.secondNode + ')';
    }

    public HeatConnection(@NotNull IHeatNode firstNode, @NotNull IHeatNode secondNode) {
        Intrinsics.checkParameterIsNotNull((Object)firstNode, (String)"firstNode");
        Intrinsics.checkParameterIsNotNull((Object)secondNode, (String)"secondNode");
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }
}

