/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.internal.energy;

import com.cout970.magneticraft.api.core.NodeID;
import com.cout970.magneticraft.api.energy.IElectricConnection;
import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/cout970/magneticraft/api/internal/energy/ElectricConnection;", "Lcom/cout970/magneticraft/api/energy/IElectricConnection;", "firstNode", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "secondNode", "(Lcom/cout970/magneticraft/api/energy/IElectricNode;Lcom/cout970/magneticraft/api/energy/IElectricNode;)V", "equals", "", "other", "", "getFirstNode", "getSecondNode", "getSeparationDistance", "", "hashCode", "", "iterate", "", "toString", "", "Magneticraft_1.12"})
public class ElectricConnection
implements IElectricConnection {
    private final IElectricNode firstNode;
    private final IElectricNode secondNode;

    @Override
    @NotNull
    public IElectricNode getFirstNode() {
        return this.firstNode;
    }

    @Override
    @NotNull
    public IElectricNode getSecondNode() {
        return this.secondNode;
    }

    @Override
    public double getSeparationDistance() {
        BlockPos blockPos = this.firstNode.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"firstNode.pos");
        BlockPos blockPos2 = this.secondNode.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"secondNode.pos");
        return BlockPosKt.getLength(BlockPosKt.minus(blockPos, blockPos2));
    }

    @Override
    public void iterate() {
        World world = this.firstNode.getWorld();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"firstNode.world");
        World $this$isClient$iv = world;
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            return;
        }
        double R = (this.firstNode.getResistance() + this.secondNode.getResistance()) * this.getSeparationDistance();
        double C = 1.0 / (1.0 / this.firstNode.getCapacity() + 1.0 / this.secondNode.getCapacity());
        double V = (this.firstNode.getVoltage() * this.firstNode.getCapacity() + this.secondNode.getVoltage() * this.secondNode.getCapacity()) / (this.firstNode.getCapacity() + this.secondNode.getCapacity()) - this.secondNode.getVoltage();
        double I = (1.0 - Math.exp((double)-1 / (R * C))) * V * this.secondNode.getCapacity() / this.firstNode.getCapacity() * C * (double)2;
        this.firstNode.applyCurrent(-I);
        this.secondNode.applyCurrent(I);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof IElectricConnection)) return super.equals(other);
        NodeID nodeID = this.firstNode.getId();
        IElectricNode iElectricNode = ((IElectricConnection)other).getFirstNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElectricNode, (String)"other.firstNode");
        if (!Intrinsics.areEqual((Object)nodeID, (Object)iElectricNode.getId())) return false;
        NodeID nodeID2 = this.secondNode.getId();
        IElectricNode iElectricNode2 = ((IElectricConnection)other).getSecondNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElectricNode2, (String)"other.secondNode");
        if (!Intrinsics.areEqual((Object)nodeID2, (Object)iElectricNode2.getId())) return false;
        return true;
    }

    public int hashCode() {
        return (super.hashCode() * 31 + this.firstNode.getId().hashCode()) * 31 + this.secondNode.getId().hashCode();
    }

    @NotNull
    public String toString() {
        return "ElectricConnection(firstNode=" + this.firstNode + ", secondNode=" + this.secondNode + ')';
    }

    public ElectricConnection(@NotNull IElectricNode firstNode, @NotNull IElectricNode secondNode) {
        Intrinsics.checkParameterIsNotNull((Object)firstNode, (String)"firstNode");
        Intrinsics.checkParameterIsNotNull((Object)secondNode, (String)"secondNode");
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }
}

