/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.modernmetals.integration.plugins;

import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.MMDPlugin;
import com.mcmoddev.lib.integration.plugins.TinkersConstruct;
import com.mcmoddev.lib.integration.plugins.tinkers.TinkerTraitLocation;
import com.mcmoddev.lib.integration.plugins.tinkers.TinkersMaterial;
import com.mcmoddev.lib.integration.plugins.tinkers.events.MaterialRegistrationEvent;
import com.mcmoddev.lib.integration.plugins.tinkers.events.TinkersAlloyRecipeEvent;
import com.mcmoddev.lib.util.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.TConstruct;

@MMDPlugin(addonId="modernmetals", pluginId="tconstruct", versions="tconstruct@[1.12.2-2.7.4.0,)")
public class MMeTinkersConstruct
implements IIntegration {
    public static final String PLUGIN_MODID = "tconstruct";

    public void init() {
        TinkersConstruct.INSTANCE.init();
        if (!TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            return;
        }
        if (!Config.Options.isModEnabled((String)PLUGIN_MODID)) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void materialRegistration(MaterialRegistrationEvent ev) {
        ModContainer oldActive = Loader.instance().activeModContainer();
        ModContainer newActive = (ModContainer)Loader.instance().getIndexedModList().get("modernmetals");
        Loader.instance().setActiveModContainer(newActive);
        this.registerMaterial(Materials.hasMaterial((String)"beryllium"), "beryllium", true, false, ev);
        this.registerMaterial(Materials.hasMaterial((String)"boron"), "boron", true, false, ev);
        this.registerMaterial(Materials.hasMaterial((String)"cadmium"), "cadmium", true, false, ev);
        this.registerMaterial(Materials.hasMaterial((String)"chromium"), "chromium", true, false, ev, "magnetic", TinkerTraitLocation.HEAD, "magnetic2");
        this.registerMaterial(Materials.hasMaterial((String)"galvanizedsteel"), "galvanizedsteel", true, false, ev, TinkerTraitLocation.HEAD, "sharp", "stiff");
        this.registerMaterial(Materials.hasMaterial((String)"iridium"), "iridium", true, false, ev, "brittle");
        this.registerMaterial(Materials.hasMaterial((String)"magnesium"), "magnesium", true, false, ev, "reactive");
        this.registerMaterial(Materials.hasMaterial((String)"manganese"), "manganese", true, false, ev, "brittle");
        this.registerMaterial(Materials.hasMaterial((String)"nichrome"), "nichrome", true, false, ev);
        this.registerMaterial(Materials.hasMaterial((String)"osmium"), "osmium", true, false, ev, "heavy", "brittle");
        this.registerMaterial(Materials.hasMaterial((String)"plutonium"), "plutonium", true, false, ev, "radioactive", TinkerTraitLocation.HEAD, "toxic", TinkerTraitLocation.PROJECTILE, "toxic");
        this.registerMaterial(Materials.hasMaterial((String)"rutile"), "rutile", true, false, ev);
        this.registerMaterial(Materials.hasMaterial((String)"stainlesssteel"), "stainlesssteel", true, false, ev, TinkerTraitLocation.HEAD, "sharp", "stiff");
        this.registerMaterial(Materials.hasMaterial((String)"tantalum"), "tantalum", true, false, ev);
        this.registerMaterial(Materials.hasMaterial((String)"thorium"), "thorium", true, false, ev);
        this.registerMaterial(Materials.hasMaterial((String)"titanium"), "titanium", true, false, ev);
        this.registerMaterial(Materials.hasMaterial((String)"tungsten"), "tungsten", true, false, ev);
        this.registerMaterial(Materials.hasMaterial((String)"uranium"), "uranium", true, false, ev, "radioactive", TinkerTraitLocation.HEAD, "poisonous", TinkerTraitLocation.PROJECTILE, "poisonous");
        this.registerMaterial(Materials.hasMaterial((String)"zirconium"), "zirconium", true, false, ev);
        Loader.instance().setActiveModContainer(oldActive);
    }

    private void registerMaterial(boolean active, String name, boolean castable, boolean craftable, MaterialRegistrationEvent ev, Object ... traits) {
        if (active) {
            TinkersMaterial mat = new TinkersMaterial(Materials.getMaterialByName((String)name)).setCastable(castable).setCraftable(craftable).setToolForge(true);
            for (int i = 0; i < traits.length; ++i) {
                String trait;
                Object item = traits[i];
                if (item instanceof TinkerTraitLocation) {
                    TinkerTraitLocation loc = (TinkerTraitLocation)item;
                    trait = ((String)traits[++i]).toLowerCase(Locale.US);
                    mat.addTrait(trait, loc);
                    continue;
                }
                trait = ((String)item).toLowerCase(Locale.US);
                mat.addTrait(trait);
            }
            ev.getRegistry().register((IForgeRegistryEntry)mat.create());
        }
    }

    private void registerMaterial(boolean active, String name, boolean castable, boolean craftable, MaterialRegistrationEvent ev) {
        if (active) {
            TinkersMaterial mat = new TinkersMaterial(Materials.getMaterialByName((String)name)).setCastable(castable).setCraftable(craftable).setToolForge(true).create();
            ev.getRegistry().register((IForgeRegistryEntry)mat);
        }
    }

    private void registerAlloy(TinkersAlloyRecipeEvent ev, String outputMaterialName, int outputAmount, Object[] recipe) {
        ArrayList<String> materialNames = new ArrayList<String>();
        materialNames.add(outputMaterialName);
        Arrays.asList(recipe).stream().filter(elem -> elem instanceof String).forEach(elem -> materialNames.add((String)elem));
        if (!this.hasMaterials(materialNames)) {
            return;
        }
        FluidStack[] rest = new FluidStack[recipe.length / 2];
        int i = 0;
        int j = 0;
        while (i < recipe.length) {
            rest[j] = FluidRegistry.getFluidStack((String)((String)recipe[i]), (int)((Integer)recipe[i + 1]));
            i += 2;
            ++j;
        }
        ev.addAlloyRecipe(outputMaterialName, outputAmount, rest);
    }

    private boolean hasMaterials(List<String> materialNames) {
        for (String name : materialNames) {
            if (Materials.hasMaterial((String)name)) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void registerMyAlloys(TinkersAlloyRecipeEvent ev) {
        ModContainer oldActive = Loader.instance().activeModContainer();
        ModContainer newActive = (ModContainer)Loader.instance().getIndexedModList().get("modernmetals");
        Loader.instance().setActiveModContainer(newActive);
        this.registerAlloy(ev, "galvanizedsteel", 2, new Object[]{"steel", 1, "zinc", 1});
        this.registerAlloy(ev, "nichrome", 2, new Object[]{"nickel", 1, "chromium", 1});
        this.registerAlloy(ev, "stainlesssteel", 2, new Object[]{"steel", 1, "chromium", 1});
        this.registerAlloy(ev, "titanium", 2, new Object[]{"rutile", 1, "magnesium", 1});
        Loader.instance().setActiveModContainer(oldActive);
    }
}

