/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.modernmetals.integration.plugins;

import cofh.api.util.ThermalExpansionHelper;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.MMDPlugin;
import com.mcmoddev.lib.integration.plugins.ThermalExpansion;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@MMDPlugin(addonId="modernmetals", pluginId="thermalexpansion")
public class MMeThermalExpansion
extends ThermalExpansion
implements IIntegration {
    public void init() {
        if (!Config.Options.isModEnabled((String)"thermalexpansion")) {
            return;
        }
    }

    @SubscribeEvent
    public void regShit(RegistryEvent.Register<IRecipe> event) {
        MMDMaterial steel;
        List<String> materials = Arrays.asList("aluminumbrass", "beryllium", "boron", "cadmium", "chromium", "galvanizedsteel", "magnesium", "manganese", "nichrome", "osmium", "plutonium", "rutile", "stainlesssteel", "tantalum", "thorium", "titanium", "tungsten", "uranium", "zirconium");
        materials.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(materialName -> {
            MMeThermalExpansion.addFurnace((String)materialName);
            MMeThermalExpansion.addCrucible((String)materialName);
            MMeThermalExpansion.addPlatePress((String)materialName);
            MMeThermalExpansion.addPressStorage((String)materialName);
        });
        this.maybeAddMagmaticFuels("plutonium", "uranium");
        if (MMeThermalExpansion.hasMaterials("steel", "chromium", "stainlesssteel") && MMeThermalExpansion.materialsHaveItems(Arrays.asList("steel", "chromium", "stainlesssteel"), Names.INGOT.toString())) {
            steel = Materials.getMaterialByName((String)"steel");
            MMDMaterial chromium = Materials.getMaterialByName((String)"chromium");
            MMDMaterial stainlessSteel = Materials.getMaterialByName((String)"stainlesssteel");
            ThermalExpansionHelper.addSmelterRecipe((int)4000, (ItemStack)steel.getItemStack(Names.INGOT, 1), (ItemStack)chromium.getItemStack(Names.INGOT, 1), (ItemStack)stainlessSteel.getItemStack(Names.INGOT, 2));
        }
        if (MMeThermalExpansion.hasMaterials("steel", "zinc", "galvanizedsteel") && MMeThermalExpansion.materialsHaveItems(Arrays.asList("steel", "zinc", "galvanizedsteel"), Names.INGOT.toString())) {
            steel = Materials.getMaterialByName((String)"steel");
            MMDMaterial galvanizedSteel = Materials.getMaterialByName((String)"galvanizedsteel");
            MMDMaterial zinc = Materials.getMaterialByName((String)"zinc");
            ThermalExpansionHelper.addSmelterRecipe((int)4000, (ItemStack)steel.getItemStack(Names.INGOT, 1), (ItemStack)zinc.getItemStack(Names.INGOT, 1), (ItemStack)galvanizedSteel.getItemStack(Names.INGOT, 2));
        }
        if (MMeThermalExpansion.hasMaterials("rutile", "magnesium", "titanium") && MMeThermalExpansion.materialsHaveItems(Arrays.asList("rutile", "magnesium", "titanium"), Names.INGOT.toString())) {
            MMDMaterial magnesium = Materials.getMaterialByName((String)"magnesium");
            MMDMaterial rutile = Materials.getMaterialByName((String)"rutile");
            MMDMaterial titanium = Materials.getMaterialByName((String)"titanium");
            ThermalExpansionHelper.addSmelterRecipe((int)4000, (ItemStack)rutile.getItemStack(Names.INGOT, 1), (ItemStack)magnesium.getItemStack(Names.INGOT, 1), (ItemStack)titanium.getItemStack(Names.INGOT, 2));
        }
    }

    private void maybeAddMagmaticFuels(String ... materials) {
        Arrays.asList(materials).stream().filter(Materials::hasMaterial).map(Materials::getMaterialByName).forEach(mat -> {
            int fuelRF = this.getFuelRF(mat.getName());
            if (fuelRF > 0) {
                String fluidName = mat.getFluid().getName();
                ThermalExpansionHelper.addMagmaticFuel((String)fluidName, (int)fuelRF);
            }
        });
    }

    private int getFuelRF(String name) {
        if (name.equals("uranium")) {
            return 750000;
        }
        if (name.equals("plutonium")) {
            return 1000000;
        }
        return 0;
    }

    private static boolean materialsHaveItems(List<String> materialNames, String ... items) {
        for (String item : items) {
            for (String materialName : materialNames) {
                if (Materials.getMaterialByName((String)materialName).hasItem(item)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean hasMaterials(String ... materials) {
        for (String materialName : materials) {
            if (Materials.hasMaterial((String)materialName)) continue;
            return false;
        }
        return true;
    }
}

