/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.modernmetals.integration.plugins;

import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.MMDPlugin;
import com.mcmoddev.lib.integration.plugins.DenseOres;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;

@MMDPlugin(addonId="modernmetals", pluginId="denseores")
public class MMeDenseOres
extends DenseOres
implements IIntegration {
    public void init() {
        if (!Config.Options.isModEnabled((String)"denseores")) {
            return;
        }
        MMeDenseOres.registerOres();
    }

    private static void registerOres() {
        List<String> materials = Arrays.asList("aluminum", "cadmium", "chromium", "iridium", "magnesium", "manganese", "osmium", "plutonium", "rutile", "tantalum", "titanium", "tungsten", "uranium", "zirconium");
        materials.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(materialName -> {
            MMDMaterial material = Materials.getMaterialByName((String)materialName);
            if (material.isEmpty()) {
                MMeDenseOres.registerOre((String)String.format("%s_%s", materialName, "ore"), (String)"stone", (int)0);
            }
        });
    }
}

