/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.modernmetals.init;

import com.mcmoddev.lib.material.MMDMaterialType;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class Materials
extends com.mcmoddev.lib.init.Materials {
    private Materials() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void init() {
        List<String> materials = Arrays.asList("aluminum", "beryllium", "boron", "chromium", "magnesium", "manganese", "osmium", "rutile", "tantalum", "thorium", "tungsten", "zirconium");
        List<String> rareMaterials = Arrays.asList("cadmium", "iridium", "plutonium", "uranium");
        List<String> alloyMaterials = Arrays.asList("aluminumbrass", "galvanizedsteel", "nichrome", "stainlesssteel");
        materials.stream().filter(Config.Options::isMaterialEnabled).forEach(name -> Materials.createMaterial((String)name, (MMDMaterialType.MaterialType)MMDMaterialType.MaterialType.METAL, (double)Materials.getHardness(name), (double)Materials.getStrength(name), (double)Materials.getMagic(name), (int)Materials.getColor(name)));
        alloyMaterials.stream().filter(Config.Options::isMaterialEnabled).forEach(name -> Materials.createAlloyMaterial((String)name, (MMDMaterialType.MaterialType)MMDMaterialType.MaterialType.METAL, (double)Materials.getHardness(name), (double)Materials.getStrength(name), (double)Materials.getMagic(name), (int)Materials.getColor(name)));
        rareMaterials.stream().filter(Config.Options::isMaterialEnabled).forEach(name -> Materials.createRareMaterial((String)name, (MMDMaterialType.MaterialType)MMDMaterialType.MaterialType.METAL, (double)Materials.getHardness(name), (double)Materials.getStrength(name), (double)Materials.getMagic(name), (int)Materials.getColor(name)));
        if (Config.Options.isMaterialEnabled((String)"titanium")) {
            String name2 = "titanium";
            Materials.createSpecialMaterial((String)"titanium", (MMDMaterialType.MaterialType)MMDMaterialType.MaterialType.METAL, (double)Materials.getHardness("titanium"), (double)Materials.getStrength("titanium"), (double)Materials.getMagic("titanium"), (int)Materials.getColor("titanium"));
        }
    }

    private static int getColor(@Nonnull String name) {
        switch (name) {
            case "aluminum": {
                return -3815231;
            }
            case "aluminumbrass": {
                return -1332650;
            }
            case "cadmium": {
                return -3549990;
            }
            case "chromium": {
                return -3289649;
            }
            case "galvanizedsteel": {
                return -6576478;
            }
            case "iridium": {
                return -463412;
            }
            case "magnesium": {
                return -8421513;
            }
            case "manganese": {
                return -667686;
            }
            case "nichrome": {
                return -2187180;
            }
            case "osmium": {
                return -8614247;
            }
            case "plutonium": {
                return -5032982;
            }
            case "rutile": {
                return -4222325;
            }
            case "stainlesssteel": {
                return -3817535;
            }
            case "tantalum": {
                return -3883326;
            }
            case "titanium": {
                return -9209730;
            }
            case "tungsten": {
                return -6908266;
            }
            case "uranium": {
                return -5786811;
            }
            case "zirconium": {
                return -7170157;
            }
            case "beryllium": {
                return -2763819;
            }
            case "boron": {
                return -7829368;
            }
            case "thorium": {
                return -11576742;
            }
        }
        return -16777216;
    }

    private static double getMagic(@Nonnull String name) {
        switch (name) {
            case "aluminum": 
            case "aluminumbrass": 
            case "cadmium": 
            case "chromium": 
            case "galvanizedsteel": 
            case "iridium": 
            case "magnesium": 
            case "manganese": 
            case "nichrome": 
            case "osmium": 
            case "plutonium": 
            case "rutile": 
            case "stainlesssteel": 
            case "tantalum": 
            case "titanium": 
            case "tungsten": 
            case "uranium": 
            case "zirconium": {
                return 4.5;
            }
            case "beryllium": 
            case "boron": 
            case "thorium": {
                return 1.0;
            }
        }
        return 1.0;
    }

    private static double getStrength(@Nonnull String name) {
        switch (name) {
            case "tantalum": {
                return 17.5;
            }
            case "titanium": 
            case "uranium": {
                return 16.25;
            }
            case "stainlesssteel": {
                return 16.0;
            }
            case "nichrome": {
                return 15.5;
            }
            case "galvanizedsteel": {
                return 15.25;
            }
            case "tungsten": {
                return 12.5;
            }
            case "boron": {
                return 8.0;
            }
            case "aluminumbrass": 
            case "plutonium": {
                return 7.5;
            }
            case "aluminum": {
                return 3.75;
            }
            case "magnesium": 
            case "zirconium": {
                return 3.5;
            }
            case "chromium": 
            case "iridium": {
                return 3.0;
            }
            case "manganese": 
            case "osmium": {
                return 2.75;
            }
            case "beryllium": {
                return 2.5;
            }
            case "cadmium": 
            case "thorium": {
                return 1.0;
            }
            case "rutile": {
                return 0.25;
            }
        }
        return 1.0;
    }

    private static double getHardness(@Nonnull String name) {
        switch (name) {
            case "boron": {
                return 9.5;
            }
            case "chromium": {
                return 9.0;
            }
            case "tungsten": {
                return 7.5;
            }
            case "osmium": {
                return 7.0;
            }
            case "iridium": 
            case "tantalum": 
            case "titanium": {
                return 6.5;
            }
            case "nichrome": 
            case "rutile": 
            case "stainlesssteel": 
            case "uranium": {
                return 6.0;
            }
            case "beryllium": 
            case "galvanizedsteel": {
                return 5.5;
            }
            case "manganese": 
            case "zirconium": {
                return 5.0;
            }
            case "plutonium": {
                return 4.0;
            }
            case "thorium": {
                return 3.0;
            }
            case "aluminum": 
            case "magnesium": {
                return 2.5;
            }
            case "cadmium": {
                return 2.0;
            }
            case "aluminumbrass": {
                return 1.0;
            }
        }
        return 1.0;
    }
}

