/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.modernmetals.init;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Oredicts;
import com.mcmoddev.modernmetals.ModernMetals;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="modernmetals")
public class Items
extends com.mcmoddev.lib.init.Items {
    protected Items() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void init() {
        List<String> materials = Arrays.asList("aluminum", "aluminumbrass", "beryllium", "boron", "cadmium", "chromium", "galvanizedsteel", "iridium", "magnesium", "manganese", "nichrome", "osmium", "plutonium", "rutile", "stainlesssteel", "tantalum", "thorium", "titanium", "tungsten", "uranium", "zirconium");
        List<String> materialsIC2Support = Arrays.asList("aluminumbrass", "galvanizedsteel", "nichrome", "osmium", "stainlesssteel", "uranium");
        List<String> materialsModSupport = Arrays.asList("aluminum", "beryllium", "boron", "cadmium", "chromium", "iridium", "magnesium", "manganese", "plutonium", "rutile", "tantalum", "thorium", "titanium", "tungsten", "zirconium");
        List<Names> itemsToMake = Arrays.asList(Names.BLEND, Names.INGOT, Names.NUGGET, Names.POWDER, Names.SMALLBLEND, Names.SMALLPOWDER, Names.ARROW, Names.AXE, Names.BOLT, Names.BOOTS, Names.BOW, Names.CHESTPLATE, Names.CRACKHAMMER, Names.CROSSBOW, Names.DOOR, Names.FISHING_ROD, Names.HELMET, Names.HOE, Names.HORSE_ARMOR, Names.LEGGINGS, Names.PICKAXE, Names.SHEARS, Names.SHIELD, Names.SHOVEL, Names.SCYTHE, Names.SLAB, Names.SWORD, Names.ROD, Names.GEAR);
        materials.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(materialName -> {
            MMDMaterial material = Materials.getMaterialByName((String)materialName);
            itemsToMake.stream().forEach(name -> Items.create((Names)name, (MMDMaterial)material));
        });
        materialsModSupport.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(materialName -> {
            MMDMaterial material = Materials.getMaterialByName((String)materialName);
            Items.create((Names)Names.CASING, (MMDMaterial)material);
            Items.create((Names)Names.DENSE_PLATE, (MMDMaterial)material);
            if (material.hasOre()) {
                Arrays.asList(Names.CRUSHED, Names.CRUSHED_PURIFIED, Names.SHARD, Names.CLUMP, Names.POWDER_DIRTY, Names.CRYSTAL).stream().forEach(name -> Items.create((Names)name, (MMDMaterial)material));
            }
        });
        materialsIC2Support.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(materialName -> {
            MMDMaterial material = Materials.getMaterialByName((String)materialName);
            Items.create((Names)Names.CASING, (MMDMaterial)material);
            Items.create((Names)Names.DENSE_PLATE, (MMDMaterial)material);
        });
        if (Materials.hasMaterial((String)"osmium")) {
            MMDMaterial osmium = Materials.getMaterialByName((String)"osmium");
            Items.create((Names)Names.CRUSHED, (MMDMaterial)osmium);
            Items.create((Names)Names.CRUSHED_PURIFIED, (MMDMaterial)osmium);
        }
        if (Materials.hasMaterial((String)"uranium")) {
            MMDMaterial uranium = Materials.getMaterialByName((String)"uranium");
            Items.create((Names)Names.SHARD, (MMDMaterial)uranium);
            Items.create((Names)Names.CLUMP, (MMDMaterial)uranium);
            Items.create((Names)Names.POWDER_DIRTY, (MMDMaterial)uranium);
            Items.create((Names)Names.CRYSTAL, (MMDMaterial)uranium);
        }
    }

    private static boolean filterFunc(ItemStack itemStack) {
        return itemStack.func_77973_b().getRegistryName().func_110624_b().equals("modernmetals");
    }

    private static Item mapFunc(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModernMetals.logger.fatal("RegistryEvent.Register<Item>");
        Materials.getMaterialsByMod((String)"modernmetals").stream().forEach(mat -> mat.getItems().stream().filter(Items::filterFunc).map(Items::mapFunc).forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0)));
        Oredicts.registerItemOreDictionaryEntries();
        Oredicts.registerBlockOreDictionaryEntries();
    }
}

