/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.modernmetals.init;

import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class Fluids
extends com.mcmoddev.lib.init.Fluids {
    private Fluids() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void init() {
        List<String> materials = Arrays.asList("aluminum", "aluminumbrass", "beryllium", "boron", "cadmium", "chromium", "galvanizedsteel", "iridium", "magnesium", "manganese", "nichrome", "osmium", "plutonium", "rutile", "stainlesssteel", "tantalum", "thorium", "titanium", "tungsten", "uranium", "zirconium");
        materials.stream().filter(Materials::hasMaterial).filter(Config.Options::isFluidEnabled).forEach(materialName -> {
            Fluids.addFluid((String)materialName, (int)2000, (int)10000, (int)Fluids.getTemperature(materialName), (int)10);
            Fluids.addFluidBlock((String)materialName);
        });
    }

    private static int getTemperature(@Nonnull String name) {
        switch (name) {
            case "aluminum": {
                return 330;
            }
            case "aluminumbrass": {
                return 500;
            }
            case "beryllium": 
            case "boron": {
                return 400;
            }
            case "cadmium": {
                return 300;
            }
            case "thorium": {
                return 514;
            }
        }
        return 769;
    }
}

