/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ServerUtils;
import codechicken.nei.network.NEIServerPacketHandler;
import codechicken.nei.util.LogHelper;
import codechicken.nei.util.NEIServerUtils;
import java.io.File;
import java.util.HashSet;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PlayerSave {
    public EntityPlayerMP player;
    private File saveFile;
    private NBTTagCompound nbt;
    public ItemStack[] creativeInv;
    private boolean creativeInvDirty;
    private boolean isDirty;
    private boolean wasOp;
    public HashSet<EntityItem> magneticItems = new HashSet();

    public PlayerSave(EntityPlayerMP player, File saveLocation) {
        this.player = player;
        this.wasOp = ServerUtils.mc().func_184103_al().func_152596_g(player.func_146103_bH());
        this.saveFile = new File(saveLocation, player.func_70005_c_() + ".dat");
        if (!this.saveFile.getParentFile().exists()) {
            this.saveFile.getParentFile().mkdirs();
        }
        this.load();
    }

    private void load() {
        this.nbt = new NBTTagCompound();
        try {
            if (!this.saveFile.exists()) {
                this.saveFile.createNewFile();
            }
            if (this.saveFile.length() > 0L) {
                this.nbt = NEIServerUtils.readNBT(this.saveFile);
            }
        }
        catch (Exception e) {
            LogHelper.errorError("Error loading player save: " + this.player, e);
        }
        this.loadCreativeInv();
    }

    private void loadCreativeInv() {
        this.creativeInv = new ItemStack[54];
        ArrayUtils.fillArray((Object[])this.creativeInv, (Object)ItemStack.field_190927_a);
        NBTTagList itemList = this.nbt.func_150295_c("creativeitems", 10);
        if (itemList != null) {
            InventoryUtils.readItemStacksFromTag((ItemStack[])this.creativeInv, (NBTTagList)itemList);
        }
    }

    public void save() {
        if (!this.isDirty) {
            return;
        }
        if (this.creativeInvDirty) {
            this.saveCreativeInv();
        }
        try {
            NEIServerUtils.writeNBT(this.nbt, this.saveFile);
            this.isDirty = false;
        }
        catch (Exception e) {
            LogHelper.errorError("Error saving player: " + this.player, e);
        }
    }

    private void saveCreativeInv() {
        NBTTagList invsave = InventoryUtils.writeItemStacksToTag((ItemStack[])this.creativeInv);
        this.nbt.func_74782_a("creativeitems", (NBTBase)invsave);
        this.creativeInvDirty = false;
    }

    public void setCreativeDirty() {
        this.isDirty = true;
        this.creativeInvDirty = true;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public void updateOpChange() {
        boolean isOp = ServerUtils.mc().func_184103_al().func_152596_g(this.player.func_146103_bH());
        if (isOp != this.wasOp) {
            NEIServerPacketHandler.sendServerSideCheck(this.player);
            this.wasOp = isOp;
        }
    }

    public boolean isActionEnabled(String name) {
        return this.getEnabledActions().func_74767_n(name);
    }

    private NBTTagCompound getEnabledActions() {
        NBTTagCompound tag = this.nbt.func_74775_l("enabledActions");
        if (!this.nbt.func_74764_b("enabledActions")) {
            this.nbt.func_74782_a("enabledActions", (NBTBase)tag);
        }
        return tag;
    }

    public void changeActionState(String name, boolean enabled) {
        this.getEnabledActions().func_74757_a(name, enabled);
        NEIServerPacketHandler.sendActionStateChange(this.player, name, enabled);
        this.setDirty();
    }

    public void onWorldReload() {
        NEIServerPacketHandler.sendServerSideCheck(this.player);
        this.magneticItems.clear();
    }
}

