/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import primal_tech.PrimalTech;
import primal_tech.tiles.TileEntityWoodenBasin;

public class BlockWoodenBasin
extends Block
implements ITileEntityProvider {
    public BlockWoodenBasin() {
        super(Material.field_151575_d);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(PrimalTech.TAB);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWoodenBasin();
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityWoodenBasin tile = (TileEntityWoodenBasin)world.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        IFluidHandler fluidHandler = this.getFluidHandler((IBlockAccess)world, pos);
        if (fluidHandler != null && FluidUtil.getFluidHandler((ItemStack)heldItem) != null) {
            FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
            return FluidUtil.getFluidHandler((ItemStack)heldItem) != null;
        }
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityWoodenBasin) {
            int i;
            TileEntityWoodenBasin tile = (TileEntityWoodenBasin)world.func_175625_s(pos);
            if (!player.func_70093_af()) {
                if (tile != null && heldItem.func_190926_b() && tile.tank.getFluidAmount() >= 1000 && !tile.getMixing()) {
                    tile.setMixing(true);
                    tile.setStirCount(tile.getStirCount() + 1);
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.25f);
                    world.func_184138_a(pos, state, state, 3);
                    return true;
                }
                if (!heldItem.func_190926_b()) {
                    for (i = 0; i <= 3; ++i) {
                        if (!tile.func_70301_a(i).func_190926_b()) continue;
                        ItemStack ingredient = heldItem.func_77946_l();
                        ingredient.func_190920_e(1);
                        tile.func_70299_a(i, ingredient);
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                        tile.setStirCount(0);
                        tile.setMixing(false);
                        world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187806_ee, SoundCategory.BLOCKS, 0.75f, 2.0f);
                        world.func_184138_a(pos, state, state, 3);
                        return true;
                    }
                }
            }
            if (player.func_70093_af()) {
                for (i = 3; i >= 0; --i) {
                    if (tile.func_70301_a(i).func_190926_b()) continue;
                    if (!player.field_71071_by.func_70441_a(tile.func_70301_a(i))) {
                        ForgeHooks.onPlayerTossEvent((EntityPlayer)player, (ItemStack)tile.func_70301_a(i), (boolean)false);
                    }
                    tile.func_70299_a(i, ItemStack.field_190927_a);
                    tile.setStirCount(0);
                    tile.setMixing(false);
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 2.0f);
                    world.func_184138_a(pos, state, state, 3);
                    return true;
                }
            }
        }
        return true;
    }

    @Nullable
    private IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos) {
        TileEntityWoodenBasin tileentity = (TileEntityWoodenBasin)world.func_175625_s(pos);
        return (IFluidHandler)tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }
}

