/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin.workstation;

import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.ocelot.vehicle.jei.VehicleModJei;
import com.ocelot.vehicle.jei.plugin.workstation.VehicleIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class VehicleRecipeWrapper
implements IRecipeWrapper {
    public static final float SCALE = 20.0f;
    public static final int MATERIAL_SLOTS = 8;
    private final IDrawableStatic slot;
    private final IDrawableStatic slotIconColor;
    private final IDrawableStatic slotIconNone;
    private final List<List<ItemStack>> itemInputs;
    private final VehicleIngredient vehicleOutput;

    VehicleRecipeWrapper(IGuiHelper guiHelper, List<List<ItemStack>> itemInputs, VehicleIngredient vehicleOutput) {
        this.slot = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 176, 43, 18, 18);
        this.slotIconColor = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 194, 43, 16, 16);
        this.slotIconNone = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 210, 43, 16, 16);
        this.itemInputs = itemInputs;
        this.vehicleOutput = vehicleOutput;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.itemInputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.vehicleOutput.crate);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        EntityVehicle vehicle = this.vehicleOutput.vehicle;
        if (SlotType.COLOR.isApplicable(vehicle)) {
            this.slotIconColor.draw(minecraft, 1, 65);
        } else {
            this.slotIconNone.draw(minecraft, 1, 65);
        }
        if (!SlotType.ENGINE.isApplicable(vehicle)) {
            this.slotIconNone.draw(minecraft, 21, 65);
        }
        if (!SlotType.WHEELS.isApplicable(vehicle)) {
            this.slotIconNone.draw(minecraft, 41, 65);
        }
        for (int i = 0; i < 8; ++i) {
            this.slot.draw(minecraft, i * 18, 95);
        }
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"jev.category.vehicle.materials", (Object[])new Object[0]), 0, 85, 0x404040);
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)72.0f, (float)50.0f, (float)100.0f);
        GlStateManager.func_179114_b((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + minecraft.func_184121_ak()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)20.0f, (float)-20.0f, (float)20.0f);
        VehicleProperties properties = VehicleProperties.getProperties(this.vehicleOutput.vehicle.getClass());
        if (properties != null) {
            PartPosition position = properties.getDisplayPosition();
            GlStateManager.func_179139_a((double)position.getScale(), (double)position.getScale(), (double)position.getScale());
            GlStateManager.func_179114_b((float)((float)position.getRotX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)position.getRotY()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)position.getRotZ()), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)position.getX(), (double)position.getY(), (double)position.getZ());
        }
        minecraft.func_175598_ae().func_78715_a(this.vehicleOutput.vehicle.getClass()).func_76986_a((Entity)vehicle, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GlStateManager.func_179097_i();
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> tooltip = new ArrayList<String>();
        this.addSlotTooltip(tooltip, 0, 64, mouseX, mouseY, SlotType.COLOR);
        this.addSlotTooltip(tooltip, 20, 64, mouseX, mouseY, SlotType.ENGINE);
        this.addSlotTooltip(tooltip, 40, 64, mouseX, mouseY, SlotType.WHEELS);
        return tooltip;
    }

    private void addSlotTooltip(List<String> tooltip, int slotX, int slotY, int mouseX, int mouseY, SlotType type) {
        if (mouseX >= slotX && mouseX < slotX + 18 && mouseY >= slotY && mouseY < slotY + 18) {
            if (!type.isApplicable(this.vehicleOutput.vehicle)) {
                tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)("vehicle.tooltip." + type.registryName), (Object[])new Object[0]));
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"vehicle.tooltip.not_applicable", (Object[])new Object[0]));
            } else if (type == SlotType.COLOR) {
                tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"vehicle.tooltip.optional", (Object[])new Object[0]));
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)("vehicle.tooltip." + type.registryName), (Object[])new Object[0]));
            }
        }
    }

    private static enum SlotType {
        COLOR("paint_color", EntityVehicle::canBeColored),
        ENGINE("engine", vehicle -> vehicle instanceof EntityPoweredVehicle && ((EntityPoweredVehicle)vehicle).getEngineType() != EngineType.NONE),
        WHEELS("wheels", vehicle -> vehicle instanceof EntityPoweredVehicle && ((EntityPoweredVehicle)vehicle).canChangeWheels());

        private final String registryName;
        private final Function<EntityVehicle, Boolean> applicable;

        private SlotType(String registryName, Function<EntityVehicle, Boolean> applicable) {
            this.registryName = registryName;
            this.applicable = applicable;
        }

        public boolean isApplicable(EntityVehicle vehicle) {
            return this.applicable.apply(vehicle);
        }

        public String getRegistryName() {
            return this.registryName;
        }
    }
}

